/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.ImagePlanProgressTracker;
import com.sun.pkg.client.LicenseAction;
import com.sun.pkg.client.Manifest;
import com.sun.pkg.client.SystemInfo;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class Client {
    static final String usage = "Usage:\n    java -jar pkg-client.jar [options] command [cmd_options] [operands]\nwhere command is one of:\n    list [-a]                      - list packages, list all with -a\n    install [-l] pkgs...           - install packages, list license(s) with -l\n    uninstall pkgs...              - uninstall packages\n    image-create -a prefix=url dir - create a new image with the specified initial authority\n    image-update [-n]              - update each installed package to the most recent version\n                                     just print with -n, do not actually update\n    refresh                        - refresh the catalogs\n    prefs                          - print information from preferences (proxy, update check)\n    info                           - print information about the image\n    set-property pname pvalue      - set a property value\n";

    Client() {
    }

    public static void main(String[] args) throws Exception {
        String command;
        Image.setDefaultClientName("com.sun.pkg.client.Client");
        File cwd = new File(System.getProperty("user.dir"));
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        if ((command = args[0]).equals("list")) {
            boolean all = false;
            if (args.length >= 2 && args[1].equals("-a")) {
                all = true;
            }
            Image img = new Image(cwd);
            List<Image.FmriState> list = img.getInventory(null, all);
            for (Image.FmriState fs : list) {
                StringBuffer sb = new StringBuffer();
                StringBuffer flags = new StringBuffer();
                sb.append(fs.fmri.toString());
                sb.append(" - " + fs.fmri.getAuthority());
                if (fs.installed) {
                    flags.append("I");
                }
                if (fs.upgradable) {
                    flags.append("U");
                }
                if (flags.length() > 0) {
                    sb.append(" (").append(flags).append(")");
                }
                System.out.println(sb);
            }
        } else if (command.equals("refresh")) {
            Image img = new Image(cwd);
            img.refreshCatalogs();
        } else if (command.equals("install")) {
            boolean showLicenses = false;
            ArrayList<String> pnames = new ArrayList<String>();
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals("-l")) {
                    showLicenses = true;
                    continue;
                }
                pnames.add(args[i]);
            }
            Image img = new Image(cwd);
            Image.ImagePlan ip = img.makeInstallPlan((Collection<String>)pnames);
            if (showLicenses) {
                StringBuffer licenseText = new StringBuffer();
                for (Fmri f : ip.getProposedFmris()) {
                    Manifest m = img.getManifest(f);
                    List<LicenseAction> lla = m.getActionsByType(LicenseAction.class);
                    for (LicenseAction la : lla) {
                        licenseText.append("===== ").append(la.getName()).append(" =====\n");
                        licenseText.append("\n");
                        licenseText.append(la.getText());
                        licenseText.append("\n\n");
                    }
                }
                if (licenseText.length() > 0) {
                    System.out.println(licenseText);
                }
            }
            ip.execute(new ProgressTrackerImpl());
        } else if (command.equals("uninstall")) {
            Image img = new Image(cwd);
            Image.ImagePlan ip = img.makeUninstallPlan(img.getVersionsInstalled(Arrays.asList(args).subList(1, args.length)));
            ip.execute(new ProgressTrackerImpl());
        } else if (command.equals("image-create")) {
            if (args.length == 4 && args[1].equals("-a")) {
                String[] prefixAndURL = args[2].split("=");
                if (prefixAndURL.length == 2) {
                    Image.create(new File(args[3]), prefixAndURL[0], new URL(prefixAndURL[1]));
                } else {
                    System.out.println("Malformed -a option: " + args[1]);
                    System.exit(1);
                }
            } else {
                System.out.println("image-create command requires the -a option and a directory name");
                System.exit(1);
            }
        } else if (command.equals("image-update")) {
            boolean noexec = args.length >= 2 && args[1].equals("-n");
            Image img = new Image(cwd);
            List<Image.FmriState> installed = img.getInventory(null, false);
            String[] ipkgs = new String[installed.size()];
            int i = 0;
            for (Image.FmriState fs : installed) {
                ipkgs[i++] = fs.fmri.getName();
            }
            Image.ImagePlan ip = img.makeInstallPlan(ipkgs);
            Fmri[] proposed = ip.getProposedFmris();
            if (proposed.length > 0) {
                System.out.println("The following installed packages will be updated:");
                for (Image.FmriState fs : installed) {
                    for (Fmri p : proposed) {
                        if (!fs.fmri.getName().equals(p.getName())) continue;
                        System.out.println("" + fs.fmri + " -> " + p);
                    }
                }
                if (!noexec) {
                    System.out.println("Updating the image...");
                    ip.execute(new ProgressTrackerImpl());
                }
            } else {
                System.out.println("No packages need to be updated.");
            }
        } else if (command.equals("prefs")) {
            Proxy p = SystemInfo.getProxy();
            if (p == null) {
                System.out.println("no proxy");
            } else {
                InetSocketAddress isa = (InetSocketAddress)p.address();
                System.out.println("proxy: " + isa.getHostName() + ":" + isa.getPort());
            }
            System.out.println("update check frequency: " + (Object)((Object)SystemInfo.getUpdateCheckFrequency()));
        } else if (command.equals("info")) {
            Image img = new Image(cwd);
            System.out.println("preferred authority: " + img.getPreferredAuthorityName());
        } else if (command.equals("set-property")) {
            if (args.length != 3) {
                System.err.println(usage);
                System.exit(1);
            }
            Image img = new Image(cwd);
            img.setProperty(args[1], args[2]);
            img.saveConfig();
        } else if (!command.equals("test")) {
            System.err.println(usage);
            System.exit(1);
        }
        System.exit(0);
    }

    private static class ProgressTrackerImpl
    extends ImagePlanProgressTracker {
        long bytes;
        int total;
        int totalForPhase;
        int index;

        private ProgressTrackerImpl() {
        }

        public void startDownloadPhase(int totalPackages) {
            System.out.println(totalPackages + " packages to be downloaded");
        }

        public void startPackageDownload(Fmri pkg, int totalDownloadFiles, long l) {
            System.out.println("Downloading " + pkg + " of " + totalDownloadFiles + " files");
            this.bytes = 0L;
            this.total = totalDownloadFiles;
        }

        public void onFileDownloadProgress(int index, long xferedBytes) {
            this.bytes += xferedBytes;
            System.out.print("\rDownloading " + this.bytes / 1024L + "KB for " + (index + 1) + "/" + this.total);
        }

        public void endPackageDownload(Fmri pkg, int totalDownloadFiles) {
            System.out.println();
        }

        public void startActions(int totalActions) {
            this.total = totalActions;
            this.index = 0;
        }

        public void startRemovalPhase(int totalRemovalActions) {
            this.totalForPhase = totalRemovalActions;
            System.out.println("Removal phase: " + totalRemovalActions);
        }

        public void onRemovalAction(Action a) {
            ++this.index;
            System.out.print("\rRemoving " + this.index + "/" + this.total);
        }

        public void endRemovalPhase() {
            if (this.totalForPhase > 0) {
                System.out.println();
            }
        }

        public void startUpdatePhase(int totalUpdateActions) {
            this.totalForPhase = totalUpdateActions;
            System.out.println("Update phase: " + totalUpdateActions);
        }

        public void onUpdateAction(Action from, Action to) {
            ++this.index;
            System.out.print("\rUpdating " + this.index + "/" + this.total);
        }

        public void endUpdatePhase() {
            if (this.totalForPhase > 0) {
                System.out.println();
            }
        }

        public void startInstallPhase(int totalInstallActions) {
            this.totalForPhase = totalInstallActions;
            System.out.println("Install phase: " + totalInstallActions);
        }

        public void onInstallAction(Action a) {
            ++this.index;
            System.out.print("\rInstalling " + this.index + "/" + this.total);
        }

        public void endInstallPhase() {
            if (this.totalForPhase > 0) {
                System.out.println();
            }
        }
    }
}

