/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class Extension
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private OBJECT_IDENTIFIER extnId;
    private boolean critical;
    private OCTET_STRING extnValue;
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public OBJECT_IDENTIFIER getExtnId() {
        return this.extnId;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public OCTET_STRING getExtnValue() {
        return this.extnValue;
    }

    private Extension() {
    }

    public Extension(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, boolean bl, OCTET_STRING oCTET_STRING) {
        this.extnId = oBJECT_IDENTIFIER;
        this.critical = bl;
        this.extnValue = oCTET_STRING;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.extnId);
        if (this.critical) {
            sEQUENCE.addElement(new BOOLEAN(true));
        }
        sEQUENCE.addElement(this.extnValue);
        sEQUENCE.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(BOOLEAN.getTemplate(), new BOOLEAN(false));
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new Extension((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), ((BOOLEAN)sEQUENCE.elementAt(1)).toBoolean(), (OCTET_STRING)sEQUENCE.elementAt(2));
        }
    }
}

