/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.provider.task.Task;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;

public class UnregisterTask
extends Task {
    private static Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private Package gPackage;
    private SystemProduct gProduct;

    public UnregisterTask(Package aPackage, SystemProduct aProduct) {
        this.gPackage = aPackage;
        this.gProduct = aProduct;
    }

    boolean perform(ProgressListener aListener) {
        block10: {
            if (this.gPackage != null) {
                try {
                    BusRequest theSIMSPkgReq = new BusRequest("SIMSRequest", (Object)new SIMSControl(SIMSControl.SIMSCommand.UNREGISTER_PACKAGE, this.gPackage));
                    BusResponse theSIMSPkgResp = ControlBus.getInstance().publishRequest(theSIMSPkgReq, "svc://general/sims");
                    if (theSIMSPkgResp.getException() != null) {
                        LOGGER.log(Level.SEVERE, "CANNOT_UNREGISTER_PACKAGE", theSIMSPkgResp.getException());
                        return false;
                    }
                    break block10;
                }
                catch (InvalidArgumentException theEIAEx) {
                    theEIAEx.addContext("CANNOT_UNREGISTER_PACKAGE", new String[]{"package=" + this.gPackage.getName()});
                    LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
                    return false;
                }
                catch (NoSuchMemberException theNSEx) {
                    theNSEx.addContext("CANNOT_UNREGISTER_PACKAGE", new String[]{"package=" + this.gPackage.getName()});
                    LOGGER.log(Level.SEVERE, "CANNOT_UNREGISTER", theNSEx);
                    return false;
                }
            }
            if (this.gProduct != null && this.gPackage == null) {
                try {
                    BusRequest theSIMSProdReq = new BusRequest("SIMSRequest", (Object)new SIMSControl(SIMSControl.SIMSCommand.UNREGISTER_PRODUCT, this.gProduct));
                    BusResponse theSIMProdResp = ControlBus.getInstance().publishRequest(theSIMSProdReq, "svc://general/sims");
                    if (theSIMProdResp.getException() != null) {
                        LOGGER.log(Level.SEVERE, "CANNOT_UNREGISTER", theSIMProdResp.getException());
                        return false;
                    }
                    break block10;
                }
                catch (InvalidArgumentException theEIAEx) {
                    theEIAEx.addContext("CANNOT_UNREGISTER_PRODUCT", new String[]{"product=" + this.gProduct.getName()});
                    LOGGER.log(Level.SEVERE, "BUS_REQUEST_FAILED", theEIAEx);
                    return false;
                }
                catch (NoSuchMemberException theNSEx) {
                    theNSEx.addContext("CANNOT_UNREGISTER_PRODUCT", new String[]{"product=" + this.gProduct.getName()});
                    LOGGER.log(Level.SEVERE, "CANNOT_UNREGISTER", theNSEx);
                    return false;
                }
            }
            LOGGER.log(Level.WARNING, "NO_PKG_OR_PROD_TO_UNREGISTER");
            return false;
        }
        return true;
    }
}

