/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openinstaller.util.EnhancedException;

public class TextDetection {
    private static String lineSeparator = null;

    public static boolean isTextFile(File aFile) throws EnhancedException {
        boolean theIsText = true;
        int theBytesToRead = Math.min((int)aFile.length(), 5120);
        byte[] theFileBytes = new byte[theBytesToRead];
        try {
            if (aFile.exists() && aFile.isFile()) {
                theIsText = TextDetection.endsWithLine(aFile);
                if (theIsText) {
                    FileInputStream theFin = new FileInputStream(aFile);
                    int theBytesRead = theFin.read(theFileBytes);
                    theFin.close();
                    ByteArrayInputStream theBin = new ByteArrayInputStream(theFileBytes, 0, theBytesRead);
                    DataInputStream theDin = new DataInputStream(theBin);
                    for (int lines = 0; lines < 10 && theBin.available() > 255 && theIsText; ++lines) {
                        try {
                            TextDetection.readNextTextLine(theDin);
                            continue;
                        }
                        catch (EnhancedException theEe) {
                            theIsText = false;
                        }
                    }
                }
                return theIsText;
            }
        }
        catch (IOException theIoe) {
            throw new EnhancedException("ERROR_CHECKING_TEXT_FILE", (Throwable)theIoe, "file=" + aFile.getName());
        }
        return false;
    }

    private static void readNextTextLine(DataInput aDin) throws EnhancedException {
        boolean theEofOK = true;
        int theCharacterCount = 0;
        try {
            while (theCharacterCount < 255) {
                char theChar = (char)aDin.readByte();
                theEofOK = false;
                if (theChar == lineSeparator.charAt(0)) {
                    boolean theIsEndOfLine = true;
                    int theEolIndex = 1;
                    char theTestChar = '\u0000';
                    while (theIsEndOfLine && theEolIndex < lineSeparator.length()) {
                        theTestChar = (char)aDin.readByte();
                        if (theTestChar == lineSeparator.charAt(++theEolIndex - 1)) continue;
                        theIsEndOfLine = false;
                        theCharacterCount += theEolIndex;
                    }
                    if (theIsEndOfLine) {
                        return;
                    }
                    theCharacterCount += theEolIndex;
                    continue;
                }
                ++theCharacterCount;
            }
        }
        catch (EOFException theEofe) {
            if (!theEofOK) {
                throw new EnhancedException("NOT_TEXT_FILE", (Throwable)theEofe, new String[0]);
            }
        }
        catch (IOException theIoe) {
            throw new EnhancedException("NOT_TEXT_FILE", (Throwable)theIoe, new String[0]);
        }
    }

    private static boolean endsWithLine(File aFile) throws EnhancedException {
        try {
            RandomAccessFile theRaf = new RandomAccessFile(aFile, "r");
            if (theRaf.length() > (long)lineSeparator.length()) {
                theRaf.seek(theRaf.length() - (long)lineSeparator.length());
                for (int theIndex = 0; theIndex < lineSeparator.length(); ++theIndex) {
                    char theLineSepChar = (char)theRaf.readByte();
                    if (theLineSepChar == lineSeparator.charAt(theIndex)) continue;
                    theRaf.close();
                    return false;
                }
                theRaf.close();
                return true;
            }
            theRaf.close();
        }
        catch (IOException theIoe) {
            throw new EnhancedException("FILE_NO_LINE_SEP", (Throwable)theIoe, "file=" + aFile.getName());
        }
        return false;
    }

    static {
        lineSeparator = System.getProperty("line.separator");
    }
}

