/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import java.io.File;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.oor.OORPathType;
import org.openinstaller.provider.conf.oor.OORRelativeType;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.desktopintegration.DesktopIntegrator;

public abstract class BaseDesktopIntegrator
implements DesktopIntegrator {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    protected static String getInstallHome() throws EnhancedException {
        return (String)ConfigHelper.getValue((String)"InstallHome.directory.INSTALL_HOME");
    }

    protected String convertPath(OORPathType aPathType) throws EnhancedException {
        String theFilePath = aPathType.getPath();
        OORRelativeType theLocationRelative = aPathType.getRelative();
        if (theFilePath == null) {
            if (theLocationRelative != null) {
                theFilePath = "";
            } else {
                throw new EnhancedException("INVALID_SHORTCUT_DESCRIPTION", new String[0]);
            }
        }
        LOGGER.fine("The relative type is " + theLocationRelative);
        String theConvertedPath = "";
        if (theLocationRelative == null) {
            theConvertedPath = new File(theFilePath).getAbsolutePath();
        }
        switch (theLocationRelative) {
            case OOR_USER_DESKTOP_FOLDER: {
                theConvertedPath = new File(this.getDesktopFolder(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_ALL_DESKTOP_FOLDER: {
                theConvertedPath = new File(this.getAllUsersDesktopFolder(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_USER_PROGRAM_MENU: {
                theConvertedPath = new File(this.getProgramMenuFolder(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_ALL_PROGRAM_MENU: {
                theConvertedPath = new File(this.getAllUsersProgramMenuFolder(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_USER_START_MENU: {
                theConvertedPath = new File(this.getStartMenuFolder(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_ALL_START_MENU: {
                theConvertedPath = new File(this.getAllUsersStartMenuFolder(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_INSTALL_HOME: {
                theConvertedPath = new File(BaseDesktopIntegrator.getInstallHome(), theFilePath).getAbsolutePath();
                break;
            }
            case OOR_NONE: {
                theConvertedPath = new File(theFilePath).getAbsolutePath();
                break;
            }
        }
        return this.makeFailSafe(theConvertedPath);
    }

    private String makeFailSafe(String aPath) {
        String theFailSafePath = aPath;
        char theSeparator = File.separatorChar;
        if (aPath != null && !"".equalsIgnoreCase(aPath)) {
            theFailSafePath = theFailSafePath.replace('\\', theSeparator);
            theFailSafePath = theFailSafePath.replace('/', theSeparator);
        }
        return theFailSafePath;
    }
}

