/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.ui;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class GUIUtils {
    public static void resizeInnerAndCenterFrameOnScreen(JFrame aFrame, double aWidth, double aHeight) {
        double theOrgHeight;
        double theOrgWidth;
        Dimension theDisplay = Toolkit.getDefaultToolkit().getScreenSize();
        if (!aFrame.isVisible()) {
            aFrame.setLocation(theDisplay.width, theDisplay.height);
            aFrame.setVisible(true);
        }
        if (aWidth == 0.0 || aHeight == 0.0) {
            theOrgWidth = aFrame.getWidth();
            theOrgHeight = aFrame.getHeight();
        } else {
            theOrgWidth = aWidth;
            theOrgHeight = aHeight;
        }
        ((Graphics2D)aFrame.getGraphics()).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        ((Graphics2D)aFrame.getGraphics()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double theWidth = aFrame.getBounds().getBounds2D().getWidth();
        double theHeight = aFrame.getBounds().getBounds2D().getHeight();
        double theRootPaneWidth = aFrame.getRootPane().getBounds().getBounds2D().getWidth();
        double theRootPaneHeight = aFrame.getRootPane().getBounds().getBounds2D().getHeight();
        aFrame.setBounds((int)(((double)theDisplay.width - theOrgWidth) / 2.0), (int)(((double)theDisplay.height - theOrgHeight) / 2.0), (int)(2.0 * theOrgWidth - theRootPaneWidth - theOrgWidth + theWidth), (int)(2.0 * theOrgHeight - theRootPaneHeight - theOrgHeight + theHeight));
        aFrame.validate();
    }
}

