/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Container;
import charva.awt.FlowLayout;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.ScrollEvent;
import charvax.swing.JViewport;
import charvax.swing.border.Border;

public class JPanel
extends Container {
    private Border _border = null;

    public JPanel() {
        this._layoutMgr = new FlowLayout();
    }

    public JPanel(LayoutManager layout_) {
        this._layoutMgr = layout_;
    }

    public void setBorder(Border border_) {
        this._border = border_;
    }

    public Border getBorder() {
        return this._border;
    }

    public Insets getInsets() {
        if (this._border != null) {
            return this._border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        int colorpair = this.getCursesColor();
        Toolkit term = Toolkit.getDefaultToolkit();
        if (this.getParent() instanceof JViewport) {
            term.resetClipRect();
            term.blankBox(this.getParent().getLocationOnScreen(), this._size, colorpair);
            term.setClipRect(new Rectangle(this.getParent().getLocationOnScreen(), ((JViewport)this.getParent()).getExtentSize()));
        } else {
            term.blankBox(origin, this._size, colorpair);
        }
        if (this._border != null) {
            this._border.paintBorder(this, 0, origin.x, origin.y, this._size.width, this._size.height);
        }
        super.draw();
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (this.getParent() instanceof JViewport) {
            Toolkit term = Toolkit.getDefaultToolkit();
            int key = ke_.getKeyCode();
            if (key == 9) {
                term.getSystemEventQueue().postEvent(new ScrollEvent(this, 102, this.getCurrentFocus().getLocation()));
            } else if (key == 353) {
                term.getSystemEventQueue().postEvent(new ScrollEvent(this, 103, this.getCurrentFocus().getLocation()));
            }
        }
    }

    public String toString() {
        return "JPanel origin=" + this._origin + " size=" + this._size;
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println(this.toString());
        super.debug(level_ + 1);
    }
}

