/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.backends.svr4;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.FractionalProgressListener;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.backends.svr4.SolarisPackageUtils;
import org.openinstaller.sims.util.Encoders;
import org.openinstaller.sims.util.SimsUtils;
import org.openinstaller.sims.util.TempFileManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SIMSBackend
extends Backend {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final String PKG_ARCH = "all";
    private static final String PKG_BASEDIR = "/";

    @Override
    public void initialize() throws SIMSException {
        SolarisPackageUtils.checkUtils();
        this.setPermissions();
    }

    private void setPermissions() throws SIMSException {
        File theDB;
        File theInstallHome;
        StringBuffer thePerms = new StringBuffer();
        String theAltRoot = this.getAttribute(Backend.Attribute.ALTERNATE_ROOT);
        String theDomain = this.getAttribute(Backend.Attribute.DOMAIN);
        try {
            theInstallHome = SimsUtils.getFinalAltRoot(theAltRoot, theDomain);
        }
        catch (EnhancedException theEx) {
            throw new SIMSException(theEx, "CANT_SET_PERMS", "root=" + theAltRoot, "domain=" + theDomain);
        }
        LOGGER.fine("Checking DB at " + theDB);
        for (theDB = new File(theInstallHome, "var/sadm/install/contents"); theDB != null && !theDB.exists(); theDB = theDB.getParentFile()) {
            LOGGER.fine("Checking DB at " + theDB);
        }
        if (theDB == null) {
            throw new SIMSException("PACKAGE_DB_NO_ACCESS", "path=" + theInstallHome, "file=var/sadm/install/contents");
        }
        if (theDB.canWrite()) {
            LOGGER.fine("DB at " + theDB + " is WRITABLE");
            thePerms.append('w');
        }
        if (theDB.canRead()) {
            LOGGER.fine("DB at " + theDB + " is READABLE");
            thePerms.append('r');
        }
        LOGGER.fine("Setting permissions to " + thePerms.toString() + " for DB" + theDB);
        this.setAttribute(Backend.Attribute.PERMISSIONS, thePerms.toString());
    }

    @Override
    public void registerProduct(SystemProduct aProduct, ProgressListener aListener) throws SIMSException {
        String thePkgName = SolarisPackageUtils.createSIMSPkgName("sims-product" + aProduct.getID(), aProduct.getVersion(), aProduct.getInstance());
        HashMap<SolarisPackageUtils.PkgInfoEntry, String> theEntries = new HashMap<SolarisPackageUtils.PkgInfoEntry, String>();
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.ARCH, PKG_ARCH);
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.CATEGORY, "system,sims-product");
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.NAME, "openInstaller Product Tracking Package for " + aProduct.getID());
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.BASEDIR, PKG_BASEDIR);
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.PKG, thePkgName);
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_PRODUCT_NAME, aProduct.getID());
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_PRODUCT_READABLE_NAME, aProduct.getShortDescription());
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_INSTANCE_ID, aProduct.getInstance());
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_PRODUCT_BASEDIR, aProduct.getLocation());
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.VERSION, Version.encode((Version)aProduct.getVersion()));
        if (aProduct.getRelease() != null) {
            theEntries.put(SolarisPackageUtils.PkgInfoEntry.SUNW_PRODVERS, Version.encode((Version)aProduct.getRelease()));
        }
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_CRITICAL, String.valueOf(aProduct.isCritical()));
        theEntries.put(SolarisPackageUtils.PkgInfoEntry.DESC, aProduct.getDescription());
        Set<SystemProduct> theContainedProducts = aProduct.getContainedProducts();
        Set<SystemProduct> theRequiredProducts = aProduct.getRequiredProducts();
        Set<Package> theContainedPackages = aProduct.getContainedPackages();
        Set<VersionRange> theCompatibleVersions = aProduct.getCompatibleVersions();
        if (!theContainedProducts.isEmpty()) {
            theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_CONTAINED_PRODUCTS, Encoders.encodeProducts(theContainedProducts));
        }
        if (!theRequiredProducts.isEmpty()) {
            theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_REQUIRED_PRODUCTS, Encoders.encodeProducts(theRequiredProducts));
        }
        if (!theContainedPackages.isEmpty()) {
            theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_CONTAINED_PACKAGES, Encoders.encodePackages(theContainedPackages));
        }
        if (!theCompatibleVersions.isEmpty()) {
            theEntries.put(SolarisPackageUtils.PkgInfoEntry.SIMS_COMPATIBLE_VERSIONS, VersionRange.encodeVersionRanges(theCompatibleVersions));
        }
        try {
            if (this.isDryRun()) {
                LOGGER.log(Level.INFO, "SIMS_DRY_RUN", aProduct.getID());
            } else {
                FractionalProgressListener theFPL = new FractionalProgressListener(aListener, 0, 40);
                File thePkgSrcDir = SolarisPackageUtils.createMetaPkg(thePkgName, theFPL, theEntries, null);
                SolarisPackageUtils.installPkg(thePkgSrcDir, thePkgName, this.getAttribute(Backend.Attribute.DOMAIN), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT));
            }
        }
        catch (EnhancedException theEx) {
            theEx.logFatal();
            throw new SIMSException(theEx, "CANNOT_INSTALL_PACKAGE", "package=" + thePkgName);
        }
        TempFileManager.deleteTempFiles();
        if (aListener != null) {
            aListener.updateProgress(100);
        }
    }

    @Override
    public void registerPackage(Package aPkg, ProgressListener aListener) {
    }

    @Override
    public void unregisterProduct(SystemProduct aProduct, ProgressListener aListener) throws SIMSException {
        if (aListener != null) {
            aListener.updateProgress(50);
        }
        try {
            if (this.isDryRun()) {
                LOGGER.log(Level.INFO, "SIMS_DRY_RUN", new String[]{"product=", aProduct.getID()});
            } else {
                String thePkgName = SolarisPackageUtils.findProduct(aProduct.getID(), aProduct.getVersion(), aProduct.getInstance(), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
                SolarisPackageUtils.removePkg(thePkgName, this.getAttribute(Backend.Attribute.DOMAIN), this.getAttribute(Backend.Attribute.ALTERNATE_ROOT));
            }
        }
        catch (EnhancedException theEe) {
            throw new SIMSException(theEe, "CANNOT_REGISTER_PACKAGE", "product=" + aProduct.getID());
        }
        if (aListener != null) {
            aListener.updateProgress(100);
        }
    }

    @Override
    public void unregisterPackage(Package aPkg, ProgressListener aListener) {
    }

    @Override
    public List<SystemProduct> getAllProducts(List<Package> aPkgList, ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        List<String> theMetaPkgNames = SolarisPackageUtils.getAllPackageNames(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), "sims-product");
        ArrayList<SystemProduct> theProdsWithContainedOrRequiredProds = new ArrayList<SystemProduct>();
        Hashtable<SystemProduct, SystemProduct[]> theContainedProductsMap = new Hashtable<SystemProduct, SystemProduct[]>();
        Hashtable<SystemProduct, SystemProduct[]> theRequiredProductsMap = new Hashtable<SystemProduct, SystemProduct[]>();
        FractionalProgressListener theIndexListener = new FractionalProgressListener(aListener, 20, 80);
        FractionalProgressListener theCrossLinkListener = new FractionalProgressListener(aListener, 80, 100);
        List<SystemProduct> theProducts = this.buildProductIndex(theMetaPkgNames, theProdsWithContainedOrRequiredProds, theContainedProductsMap, theRequiredProductsMap, aPkgList, theIndexListener);
        this.crossLinkProducts(theProducts, theProdsWithContainedOrRequiredProds, theContainedProductsMap, theRequiredProductsMap, theCrossLinkListener);
        return theProducts;
    }

    private void crossLinkProducts(List<SystemProduct> aCompleteProductList, List<SystemProduct> aFilteredProductsList, Map<SystemProduct, SystemProduct[]> aContainedProductsMap, Map<SystemProduct, SystemProduct[]> aRequiredProductsMap, ProgressListener aListener) {
        int theTotalPkgCount = aFilteredProductsList.size();
        int theCountOfProcessedPkgs = 0;
        for (SystemProduct theNextProduct : aFilteredProductsList) {
            int theIndex;
            SystemProduct[] theContainedProducts = aContainedProductsMap.get(theNextProduct);
            SystemProduct[] theRequiredProducts = aRequiredProductsMap.get(theNextProduct);
            if (theContainedProducts != null) {
                for (SystemProduct theTmpProduct : theContainedProducts) {
                    theIndex = aCompleteProductList.indexOf(theTmpProduct);
                    try {
                        if (theIndex == -1) {
                            theTmpProduct.setState(Backend.EntityState.NOT_INSTALLED);
                            theNextProduct.addContainedProduct(theTmpProduct);
                            LOGGER.log(Level.FINE, "PRODUCT_CONTAINMENT", new Object[]{theNextProduct.getID(), theTmpProduct, theTmpProduct});
                            continue;
                        }
                        theNextProduct.addContainedProduct(aCompleteProductList.get(theIndex));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CROSS_LINK_PRODUCTS", theEIAEx);
                    }
                }
            }
            if (theRequiredProducts != null) {
                for (SystemProduct theTmpProduct : theRequiredProducts) {
                    theIndex = aCompleteProductList.indexOf(theTmpProduct);
                    try {
                        if (theIndex == -1) {
                            theNextProduct.setState(Backend.EntityState.DAMAGED);
                            theTmpProduct.setState(Backend.EntityState.NOT_INSTALLED);
                            theNextProduct.addRequiredProduct(theTmpProduct);
                            LOGGER.log(Level.FINE, "PRODUCT_REQUIRES", new Object[]{theNextProduct.getID(), theTmpProduct, theTmpProduct});
                            continue;
                        }
                        theNextProduct.addRequiredProduct(aCompleteProductList.get(theIndex));
                    }
                    catch (InvalidArgumentException theEIAEx) {
                        LOGGER.log(Level.WARNING, "CANNOT_CROSS_LINK_PRODUCTS", theEIAEx);
                    }
                }
            }
            aListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
        }
    }

    private List<SystemProduct> buildProductIndex(List<String> aMetaPkgNameSet, List<SystemProduct> aFilteredProductList, Map<SystemProduct, SystemProduct[]> aContainedProductsMap, Map<SystemProduct, SystemProduct[]> aRequiredProductsMap, List<Package> aCompletePkgList, ProgressListener aIndexListener) throws SIMSException {
        ArrayList<SystemProduct> theProducts = new ArrayList<SystemProduct>();
        int theCountOfProcessedPkgs = 0;
        int theTotalPkgCount = aMetaPkgNameSet.size();
        for (String thePkgName : aMetaPkgNameSet) {
            Map<SolarisPackageUtils.PkgInfoEntry, String> thePkgInfo = SolarisPackageUtils.getInfo(thePkgName, this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
            String theName = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_PRODUCT_NAME);
            String theShortDesc = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_PRODUCT_READABLE_NAME);
            String theVersion = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.VERSION);
            String theInstance = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_INSTANCE_ID);
            String theCriticalFlag = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_CRITICAL);
            String theRelease = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SUNW_PRODVERS);
            if (theName == null || theVersion == null || theInstance == null) {
                LOGGER.log(Level.SEVERE, "CORRUPT_PKGINFO", thePkgName);
                continue;
            }
            try {
                String theCompatibleVersionInfo;
                String theContainedPackageInfo;
                SystemProduct theNewProduct = new SystemProduct(theName, new Version(theVersion), theInstance, theShortDesc);
                if ("true".equalsIgnoreCase(theCriticalFlag)) {
                    LOGGER.finest("@ Setting critical flag for " + theNewProduct.getID() + " to " + theCriticalFlag);
                    theNewProduct.setCritical(true);
                }
                if (theRelease != null) {
                    theNewProduct.setRelease(new Version(theRelease));
                }
                theNewProduct.setLocation(thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_PRODUCT_BASEDIR));
                theNewProduct.setState(Backend.EntityState.INSTALLED);
                theProducts.add(theNewProduct);
                String theContainedProductInfo = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_CONTAINED_PRODUCTS);
                String theRequiredProductInfo = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_REQUIRED_PRODUCTS);
                if (theContainedProductInfo != null) {
                    SystemProduct[] theContainedProducts = Encoders.decodeProducts(theContainedProductInfo);
                    aContainedProductsMap.put(theNewProduct, theContainedProducts);
                    aFilteredProductList.add(theNewProduct);
                }
                if (theRequiredProductInfo != null) {
                    SystemProduct[] theRequiredProducts = Encoders.decodeProducts(theRequiredProductInfo);
                    aRequiredProductsMap.put(theNewProduct, theRequiredProducts);
                    aFilteredProductList.add(theNewProduct);
                }
                if ((theContainedPackageInfo = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_CONTAINED_PACKAGES)) != null) {
                    Package[] theContainedPackageSpecs;
                    for (Package theTmpPkg : theContainedPackageSpecs = Encoders.decodePackages(theContainedPackageInfo)) {
                        int theIndex = aCompletePkgList.indexOf(theTmpPkg);
                        if (theIndex == -1) {
                            theTmpPkg.setState(Backend.EntityState.NOT_INSTALLED);
                            theNewProduct.addContainedPackage(theTmpPkg);
                            LOGGER.log(Level.FINE, "PRODUCT_PKG_CONTAINMENT", new String[]{theName, theTmpPkg.getName()});
                            continue;
                        }
                        theNewProduct.addContainedPackage(aCompletePkgList.get(theIndex));
                    }
                }
                if ((theCompatibleVersionInfo = thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_COMPATIBLE_VERSIONS)) != null) {
                    VersionRange[] theCompatibleRanges;
                    for (VersionRange theRange : theCompatibleRanges = VersionRange.decodeVersionRanges((String)theCompatibleVersionInfo)) {
                        theNewProduct.addCompatibleVersion(theRange);
                    }
                }
                aIndexListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
            }
            catch (InvalidArgumentException theEIAEx) {
                theEIAEx.addContext("CANNOT_INSTANTIATE_PRODCUT", new String[]{"product=" + theName});
                LOGGER.log(Level.WARNING, "CANNOT_BUILD_PRODUCT_INDEX", theEIAEx);
            }
        }
        for (SystemProduct thePr : theProducts) {
            LOGGER.finest(" ^ Getting product " + thePr.toString() + " state = " + thePr.getState().toString() + " critical = " + thePr.isCritical());
        }
        return theProducts;
    }

    @Override
    public List<Package> getAllPackages(ProgressListener aListener) throws SIMSException, InvalidArgumentException {
        ArrayList<Package> thePackages = new ArrayList<Package>();
        List<String> theUniverse = SolarisPackageUtils.getAllPackageNames(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), null);
        List<String> theProdPkgNames = SolarisPackageUtils.getAllPackageNames(this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN), "sims-product");
        ArrayList<Package> thePackagesWithRequires = new ArrayList<Package>();
        int theCountOfProcessedPkgs = 0;
        int theTotalPkgCount = theProdPkgNames.size();
        for (String thePkgName : theProdPkgNames) {
            try {
                Map<SolarisPackageUtils.PkgInfoEntry, String> thePkgInfo = SolarisPackageUtils.getInfo(thePkgName, this.getAttribute(Backend.Attribute.ALTERNATE_ROOT), this.getAttribute(Backend.Attribute.DOMAIN));
                if (thePkgInfo.containsKey((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_CONTAINED_PACKAGES)) {
                    Package[] theContainedPkgs = Encoders.decodePackages(thePkgInfo.get((Object)SolarisPackageUtils.PkgInfoEntry.SIMS_CONTAINED_PACKAGES));
                    List<Package> theEncodedPkgs = Arrays.asList(theContainedPkgs);
                    for (Package thePotentialPkg : theEncodedPkgs) {
                        if (!theUniverse.contains(thePotentialPkg.getName())) continue;
                        LOGGER.finest("Setting " + thePotentialPkg.toString() + " state.Current State = " + thePotentialPkg.getState().toString());
                        thePotentialPkg.setState(Backend.EntityState.INSTALLED);
                        thePackages.add(thePotentialPkg);
                    }
                    for (Package thePackage : theContainedPkgs) {
                        if (thePackage.getRequiredPackageCount() <= 0) continue;
                        thePackagesWithRequires.add(thePackage);
                    }
                }
            }
            catch (SIMSException theEx) {
                theEx.addContext("CORRUPT_PKG_INFO", new String[]{"package=" + thePkgName});
                throw theEx;
            }
            aListener.updateProgress((int)(100.0 * (double)(++theCountOfProcessedPkgs) / (double)theTotalPkgCount));
        }
        for (Package thePackageWithRequires : thePackagesWithRequires) {
            Iterator<Package> theReqdIt = thePackageWithRequires.getRequiredPackages();
            while (theReqdIt.hasNext()) {
                Package thePackage = theReqdIt.next();
                int theIndex = thePackages.indexOf(thePackage);
                if (theIndex == -1) {
                    LOGGER.log(Level.WARNING, "PACKAGE_DEPENDENCY_WARNING", new Object[]{thePackageWithRequires.getName(), thePackage});
                    thePackageWithRequires.setState(Backend.EntityState.DAMAGED);
                    thePackage.setState(Backend.EntityState.NOT_INSTALLED);
                    thePackageWithRequires.addRequiredPackage(thePackage);
                    continue;
                }
                Package theRequiredPkg = (Package)thePackages.get(theIndex);
                theRequiredPkg.setState(Backend.EntityState.INSTALLED);
                thePackageWithRequires.addRequiredPackage(theRequiredPkg);
            }
        }
        for (Package thePkg : thePackages) {
            LOGGER.finest(" Got PKG = " + thePkg.toString() + " with state = " + thePkg.getState().toString());
        }
        return thePackages;
    }
}

