/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.pkg;

import java.io.File;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.pkg.PackageException;
import org.openinstaller.pkg.RebootRequired;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.InvalidArgumentException;

public class MSIPackageUtils {
    public static final String MSIEXEC_CMD = "msiexec";
    private static boolean gAdminInstall = false;
    private static final int REBOOT_AFTER_INSTALL = 3010;
    private static Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public static void installPkg(File aSrcPath, String aPkgName, String InstallHome) throws PackageException {
        ExecuteCommand theCmd;
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        theInstallCommand.add(MSIEXEC_CMD);
        if (gAdminInstall) {
            theInstallCommand.add(MSIEXEC_OPTS.ADMIN_INSTALL.getOption());
        } else {
            theInstallCommand.add(MSIEXEC_OPTS.INSTALL.getOption());
        }
        theInstallCommand.add(aSrcPath.getPath());
        String theCommand = "TARGETDIR=\"" + InstallHome + "\"";
        theInstallCommand.add(theCommand);
        theInstallCommand.add(MSIEXEC_OPTS.QUIET_MODE.getOption());
        String theMSILog = MSIPackageUtils.getMSILogFile(aPkgName);
        if (theMSILog != null) {
            theInstallCommand.add(MSIEXEC_OPTS.LOG.getOption());
            theInstallCommand.add(theMSILog);
        }
        LOGGER.log(Level.FINE, "InstallCommand=[" + theInstallCommand + "]");
        try {
            theCmd = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "CANT_MSIEXEC", new String[0]);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "CANT_MSIEXEC", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        if (theResult == 0) {
            LOGGER.log(Level.INFO, "INSTALL_SUCCESSFUL", aPkgName);
        } else if (theResult == 3010) {
            RebootRequired.setRebootFlag(true);
            LOGGER.log(Level.INFO, "REBOOT_REQUIRED", new Object[]{aPkgName, "ExitCode=" + theResult});
        } else {
            LOGGER.log(Level.SEVERE, "INSTALL_FAILED, ExitCode=[" + theResult + "]");
            throw new PackageException("MSI_INSTALLATION_FAILED", "package=" + aSrcPath.getPath(), "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
        }
    }

    public static void installPkg(URL aSrcPath, String aPkgName, String InstallHome) throws PackageException {
        ExecuteCommand theCmd;
        ArrayList<String> theInstallCommand = new ArrayList<String>();
        theInstallCommand.add(MSIEXEC_CMD);
        if (gAdminInstall) {
            theInstallCommand.add(MSIEXEC_OPTS.ADMIN_INSTALL.getOption());
        } else {
            theInstallCommand.add(MSIEXEC_OPTS.INSTALL.getOption());
        }
        theInstallCommand.add(aSrcPath.toExternalForm());
        String theCommand = "TARGETDIR=\"" + InstallHome + "\"";
        theInstallCommand.add(theCommand);
        theInstallCommand.add(MSIEXEC_OPTS.QUIET_MODE.getOption());
        String theMSILog = MSIPackageUtils.getMSILogFile(aPkgName);
        if (theMSILog != null) {
            theInstallCommand.add(MSIEXEC_OPTS.LOG.getOption());
            theInstallCommand.add(theMSILog);
        }
        LOGGER.log(Level.FINE, "InstallCommand=[" + theInstallCommand + "]");
        try {
            theCmd = new ExecuteCommand(theInstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "CANT_MSIEXEC", new String[0]);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "CANT_MSIEXEC", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        if (theResult == 0) {
            LOGGER.log(Level.INFO, "INSTALL_SUCCESSFUL", aPkgName);
        } else if (theResult == 3010) {
            RebootRequired.setRebootFlag(true);
            LOGGER.log(Level.INFO, "REBOOT_REQURIED", new Object[]{aPkgName, "ExitCode=" + theResult});
        } else {
            LOGGER.log(Level.SEVERE, "INSTALL_FAILED, ExitCode=[" + theResult + "]");
            throw new PackageException("MSI_INSTALLATION_FAILED", "package=" + aSrcPath.getPath(), "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
        }
    }

    public static String getMSILogFile(String aPkgName) throws PackageException {
        String theMSILogFile = null;
        Object theResponse = null;
        File theTmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (!theTmpDir.exists() && !theTmpDir.mkdir()) {
            throw new PackageException("CANT_CREATE_TMP_DIR", "temp-dir=" + theTmpDir.getName());
        }
        Timestamp theTS = new Timestamp(new Date().getTime());
        SimpleDateFormat theSDFormatter = new SimpleDateFormat("yyMMddHHmmssZ");
        File theLogFile = new File(theTmpDir, aPkgName + theSDFormatter.format(theTS) + ".msilog");
        theMSILogFile = theLogFile.getAbsolutePath();
        return theMSILogFile;
    }

    public static void removePkg(String aPkgName, String aProductGUID) throws PackageException {
        ExecuteCommand theCmd;
        ArrayList<String> theUninstallCommand = new ArrayList<String>();
        theUninstallCommand.add(MSIEXEC_CMD);
        theUninstallCommand.add(MSIEXEC_OPTS.UNINSTALL.getOption());
        theUninstallCommand.add(aProductGUID);
        theUninstallCommand.add(MSIEXEC_OPTS.QUIET_MODE.getOption());
        String theMSILog = MSIPackageUtils.getMSILogFile(aPkgName);
        if (theMSILog != null) {
            theUninstallCommand.add(MSIEXEC_OPTS.LOG.getOption());
            theUninstallCommand.add(theMSILog);
        }
        LOGGER.log(Level.FINE, "Uninstall Command = [" + theUninstallCommand + "]");
        try {
            theCmd = new ExecuteCommand(theUninstallCommand.toArray(new String[0]));
        }
        catch (InvalidArgumentException theEx) {
            throw new PackageException(theEx, "CANT_MSIEXEC", new String[0]);
        }
        theCmd.setCollectOutput(true);
        theCmd.setOutputType(3);
        try {
            theCmd.execute();
        }
        catch (EnhancedException theEEx) {
            throw new PackageException(theEEx, "CANT_MSIEXEC", "command=" + theCmd.toString());
        }
        int theResult = theCmd.getResult();
        if (theResult != 0) {
            LOGGER.log(Level.SEVERE, "UNINSTALL_FAILED", new Object[]{aPkgName, "ExitCode=" + theResult});
            throw new PackageException("MSI_UNINSTALLATION_FAILED", "package=" + aPkgName + ":" + aProductGUID, "exit-code=" + theResult, "output=" + theCmd.getAllOutput());
        }
        LOGGER.log(Level.INFO, "UNINSTALL_SUCCESSFUL", aPkgName);
    }

    public static void updatePkg(String aPatchName, String aPkgName) {
    }

    protected MSIPackageUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MSIEXEC_OPTS {
        INSTALL("/i"),
        UNINSTALL("/x"),
        REPAIR("/fa"),
        PATCH("/p"),
        LOG("/l*v"),
        QUIET_MODE("/qn"),
        ADMIN_INSTALL("/a");

        private String gOpt;

        private MSIEXEC_OPTS(String aOpt) {
            this.gOpt = aOpt;
        }

        private String getOption() {
            return this.gOpt;
        }
    }
}

