/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.logging.Logger;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public class Scripting {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static Interpreter gInterpreter;

    private Scripting() {
    }

    public static Interpreter getInterpreter() throws EnhancedException {
        try {
            if (gInterpreter == null) {
                gInterpreter = new Interpreter();
                gInterpreter.set("bus", (Object)ControlBus.getInstance());
                gInterpreter.set("LOGGER", (Object)LOGGER);
                gInterpreter.eval("this.interpreter.setClassLoader(bus.getClass().getClassLoader())");
                gInterpreter.eval("Thread.currentThread().setContextClassLoader(bus.getClass().getClassLoader())");
                gInterpreter.eval("import org.openinstaller.core.*");
                gInterpreter.eval("import org.openinstaller.util.*");
                gInterpreter.eval("import org.openinstaller.bus.*");
                gInterpreter.eval("import org.openinstaller.bus.*");
                gInterpreter.eval("import org.openinstaller.provider.*");
                gInterpreter.eval("import org.openinstaller.config.*");
                gInterpreter.eval("import org.openinstaller.pkg.*");
                gInterpreter.eval("bsh.Capabilities");
            }
        }
        catch (EvalError theException) {
            gInterpreter = null;
            EnhancedException theRethrown = new EnhancedException("INTEPRETER_CREATION_FAILED", (Throwable)theException, "class=" + ClassUtils.getClassName());
            LOGGER.throwing(ClassUtils.getClassName(), ClassUtils.getMethodName(), theRethrown);
            throw theRethrown;
        }
        catch (Exception theEx) {
            gInterpreter = null;
            EnhancedException theRethrown = new EnhancedException("INTEPRETER_CREATION_FAILED", (Throwable)theEx, "class=" + ClassUtils.getClassName());
            LOGGER.throwing(ClassUtils.getClassName(), ClassUtils.getMethodName(), theRethrown);
            throw theRethrown;
        }
        return gInterpreter;
    }
}

