/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.system;

import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.provider.system.SystemControl;
import org.openinstaller.provider.system.SystemResourceManager;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public class SystemResourceProvider
implements ServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public void init(ControlBus aBus) throws BusException {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        if (!SystemControl.class.isInstance(aReq.getData())) {
            aResp.setException((Exception)((Object)new EnhancedException("INVALID_REQUEST", new String[]{"request=" + aReq})));
            return;
        }
        switch (((SystemControl)aReq.getData()).getCommand()) {
            case GET_SYSTEM_RESOURCES_STATUS: {
                try {
                    aResp.setFinalResult(SystemResourceManager.getSystemResourceStatus());
                }
                catch (EnhancedException theEEx) {
                    aResp.setException((Exception)((Object)theEEx));
                }
                break;
            }
            default: {
                aResp.setException((Exception)((Object)new EnhancedException("INVALID_REQUEST", new String[]{"request=" + aReq})));
            }
        }
    }

    public String getName() {
        return "svc://general/system";
    }

    public void shutdown() {
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }
}

