/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.custom.psp;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.contracts.product.PSPBusRequestType;
import org.openinstaller.contracts.product.PSPControl;
import org.openinstaller.contracts.product.ProductNodeInterface;
import org.openinstaller.provider.ui.ProductSelector;
import org.openinstaller.provider.ui.custom.HTMLPanel;
import org.openinstaller.provider.ui.custom.psp.PSP_ACTIONS;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIProductSelectionPage
extends JPanel
implements ProductSelector {
    static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final String AVAILABLE_LIST_NAME = "AVAILABLE";
    JList gAvailablesList;
    JList gSelectedsList;
    JTextArea gDescription;
    JButton gAddButton;
    private JButton gAddAllButton;
    JButton gRemoveButton;
    private JButton gRemoveAllButton;
    boolean gShowDependencies = true;
    boolean gShowFeatures = true;
    boolean gUnselectDependencies = true;
    private boolean gUnselectFeatures = true;
    private boolean gRootIsAContainer = false;
    private boolean gInitDone = false;

    @Override
    public void addAvailable(ProductNodeInterface aProduct) {
        this.addProduct(aProduct, (DefaultListModel)this.gAvailablesList.getModel());
    }

    @Override
    public void addSelected(ProductNodeInterface aProduct) {
        this.addProduct(aProduct, (DefaultListModel)this.gSelectedsList.getModel());
    }

    public void selectItem(List<String> aSelectedList, JList aSrc) {
        ArrayList<Integer> theIndicesList = new ArrayList<Integer>();
        for (String theSelectedProd : aSelectedList) {
            for (int theListIndex = 0; theListIndex < aSrc.getModel().getSize(); ++theListIndex) {
                ProductNodeInterface theListedProd = (ProductNodeInterface)((DefaultListModel)aSrc.getModel()).getElementAt(theListIndex);
                if (!theListedProd.getID().equalsIgnoreCase(theSelectedProd)) continue;
                LOGGER.finest(" List Index = " + theListIndex + "Listed Prod = " + theListedProd);
                theIndicesList.add(new Integer(theListIndex));
            }
        }
        int[] theSelectedIndices = new int[theIndicesList.size()];
        for (int theIndex = 0; theIndex < theIndicesList.size(); ++theIndex) {
            theSelectedIndices[theIndex] = (Integer)theIndicesList.get(theIndex);
        }
        aSrc.setSelectedIndices(theSelectedIndices);
    }

    public GUIProductSelectionPage() {
        super(new GridBagLayout());
        GridBagConstraints theGridConst = new GridBagConstraints();
        JPanel theButtonPanel = new JPanel(new GridBagLayout());
        theButtonPanel.setOpaque(false);
        GridBagConstraints theButtonConst = new GridBagConstraints();
        theButtonConst.gridx = 0;
        theButtonConst.gridy = 0;
        theButtonConst.weightx = 1.0;
        theButtonConst.insets = new Insets(0, 0, 12, 0);
        theButtonConst.fill = 2;
        this.gAddButton = new JButton(Msg.get((String)"ADD_BUTTON_LABEL", (Object[])new Object[0]));
        this.gAddButton.setEnabled(false);
        theButtonPanel.add((Component)this.gAddButton, theButtonConst);
        theButtonConst.gridy = 1;
        this.gAddAllButton = new JButton(Msg.get((String)"ADD_ALL_BUTTON_LABEL", (Object[])new Object[0]));
        this.gAddAllButton.setEnabled(false);
        theButtonPanel.add((Component)this.gAddAllButton, theButtonConst);
        theButtonConst.gridy = 2;
        this.gRemoveButton = new JButton(Msg.get((String)"REMOVE_BUTTON_LABEL", (Object[])new Object[0]));
        this.gRemoveButton.setEnabled(false);
        theButtonPanel.add((Component)this.gRemoveButton, theButtonConst);
        theButtonConst.gridy = 3;
        this.gRemoveAllButton = new JButton(Msg.get((String)"REMOVE_ALL_BUTTON_LABEL", (Object[])new Object[0]));
        this.gRemoveAllButton.setEnabled(false);
        theButtonPanel.add((Component)this.gRemoveAllButton, theButtonConst);
        theGridConst.gridx = 0;
        theGridConst.gridy = 0;
        theGridConst.gridwidth = 3;
        theGridConst.gridheight = 1;
        theGridConst.weightx = 1.0;
        theGridConst.fill = 2;
        theGridConst.anchor = 19;
        theGridConst.insets = new Insets(12, 12, 17, 12);
        HTMLPanel theHTMLPanel = new HTMLPanel();
        theHTMLPanel.setText(Msg.get((String)"PSP_INTRO_TEXT", (Object[])new Object[0]));
        this.add((Component)theHTMLPanel, theGridConst);
        this.gAvailablesList = new JList(new DefaultListModel());
        this.gAvailablesList.addListSelectionListener(new PSPListsListener());
        this.gAvailablesList.setName(AVAILABLE_LIST_NAME);
        JScrollPane theSelectablesScrollPane = new JScrollPane(this.gAvailablesList);
        theSelectablesScrollPane.setHorizontalScrollBarPolicy(30);
        theSelectablesScrollPane.setVerticalScrollBarPolicy(22);
        theGridConst.fill = 1;
        theGridConst.weighty = 1.0;
        theGridConst.gridy = 1;
        theGridConst.weightx = 1.0;
        theGridConst.gridwidth = 1;
        theGridConst.insets = new Insets(0, 12, 17, 11);
        this.add((Component)theSelectablesScrollPane, theGridConst);
        theGridConst.gridx = 1;
        theGridConst.weightx = 0.0;
        theGridConst.fill = 0;
        theGridConst.insets = new Insets(0, 0, 17, 11);
        theGridConst.anchor = 10;
        this.add((Component)theButtonPanel, theGridConst);
        this.gSelectedsList = new JList(new DefaultListModel());
        JScrollPane theSelectedsScroll = new JScrollPane(this.gSelectedsList);
        theSelectedsScroll.setHorizontalScrollBarPolicy(30);
        theSelectedsScroll.setVerticalScrollBarPolicy(22);
        this.gSelectedsList.addListSelectionListener(new PSPListsListener());
        theGridConst.fill = 1;
        theGridConst.weightx = 1.0;
        theGridConst.gridx = 2;
        theGridConst.insets = new Insets(0, 0, 17, 12);
        this.add((Component)theSelectedsScroll, theGridConst);
        this.gDescription = new JTextArea();
        this.gDescription.setLineWrap(true);
        JScrollPane theTextScroll = new JScrollPane(this.gDescription);
        theTextScroll.setHorizontalScrollBarPolicy(31);
        theTextScroll.setVerticalScrollBarPolicy(22);
        theGridConst.gridx = 0;
        theGridConst.gridy = 2;
        theGridConst.gridwidth = 3;
        theGridConst.insets = new Insets(0, 12, 12, 12);
        this.add((Component)theTextScroll, theGridConst);
        this.gAddButton.setActionCommand("AC_NONE");
        this.gAddAllButton.setActionCommand("AC_NONE");
        this.gRemoveButton.setActionCommand("AC_NONE");
        this.gRemoveAllButton.setActionCommand("AC_NONE");
        this.gAddButton.setName(PSP_ACTIONS.ADD_COMMAND.name());
        this.gAddAllButton.setName(PSP_ACTIONS.ADD_ALL_COMMAND.name());
        this.gRemoveButton.setName(PSP_ACTIONS.REMOVE_COMMAND.name());
        this.gRemoveAllButton.setName(PSP_ACTIONS.REMOVE_ALL_COMMAND.name());
        PSPButtonsListener theButtonListener = new PSPButtonsListener();
        this.gAddButton.addActionListener(theButtonListener);
        this.gAddAllButton.addActionListener(theButtonListener);
        this.gRemoveButton.addActionListener(theButtonListener);
        this.gRemoveAllButton.addActionListener(theButtonListener);
    }

    private void init() {
        if (this.gInitDone) {
            return;
        }
        ControlBus theBus = ControlBus.getInstance();
        try {
            PSPControl thePSPCtrl = new PSPControl(PSPControl.PSPCommand.GET_AVAILABLE_PRODUCTS, (Object)new PSPBusRequestType(this.gShowFeatures, this.gShowDependencies, this.gRootIsAContainer));
            BusResponse theProdSelResp = theBus.publishRequest(new BusRequest("ProductSelectionRequest", (Object)thePSPCtrl), "svc://general/product");
            if (theProdSelResp == null) {
                throw new EnhancedException("CANNOT_GET_PRODUCT_SELECTION_MAP", new String[0]);
            }
            if (theProdSelResp.getException() != null) {
                throw new EnhancedException("CANNOT_GET_PRODUCT_SELECTION_MAP", (Throwable)theProdSelResp.getException(), new String[0]);
            }
            Set theProductList = (Set)theProdSelResp.getResult();
            if (theProductList == null) {
                throw new EnhancedException("CANNOT_GET_PRODUCT_SELECTION_MAP", new String[0]);
            }
            for (ProductNodeInterface theProduct : theProductList) {
                this.addAvailable(theProduct);
            }
            PSPControl thePSPControl = new PSPControl(PSPControl.PSPCommand.GET_SELECTED_PRODUCTS, null);
            BusResponse theSelectedResp = theBus.publishRequest(new BusRequest("SelectedProducts Request", (Object)thePSPControl), "svc://general/product");
            if (null != theSelectedResp && theSelectedResp.getException() == null) {
                List theSelectedList = (List)theSelectedResp.getResult();
                if (null != theSelectedList) {
                    this.gSelectedsList.clearSelection();
                    this.selectItem(theSelectedList, this.gAvailablesList);
                    this.moveSelected(this.gAvailablesList, this.gSelectedsList, false, false);
                }
            } else {
                LOGGER.fine("Could not retrieve the selected product list");
            }
        }
        catch (EnhancedException theEE) {
            LOGGER.fine(theEE.getMessage());
        }
        this.updateAvailableButtons();
        this.gInitDone = true;
    }

    public void setShowFeatures(boolean aValue) {
        this.gShowFeatures = aValue;
    }

    public void setShowDependencies(boolean aValue) {
        this.gShowDependencies = aValue;
    }

    public void setUnselectDependencies(boolean aValue) {
        this.gUnselectDependencies = aValue;
    }

    public void setUnselectFeatures(boolean aValue) {
        this.gUnselectFeatures = aValue;
    }

    public void setRootIsAContainer(boolean aValue) {
        this.gRootIsAContainer = aValue;
    }

    @Override
    public void setName(String aName) {
        this.gSelectedsList.setName(aName);
    }

    void updateDescription() {
        if (this.gSelectedsList.getSelectedValue() != null) {
            this.gDescription.setText(((ProductNodeInterface)this.gSelectedsList.getSelectedValue()).getDescription(Locale.getDefault()));
        } else if (this.gAvailablesList.getSelectedValue() != null) {
            this.gDescription.setText(((ProductNodeInterface)this.gAvailablesList.getSelectedValue()).getDescription(Locale.getDefault()));
        }
    }

    final void updateAvailableButtons() {
        this.gAddAllButton.setEnabled(0 < this.gAvailablesList.getModel().getSize());
        this.gRemoveAllButton.setEnabled(0 < this.gSelectedsList.getModel().getSize());
        this.gAddButton.setEnabled(-1 != this.gAvailablesList.getSelectedIndex());
        this.gRemoveButton.setEnabled(-1 != this.gSelectedsList.getSelectedIndex());
    }

    void moveSelected(JList aSrc, JList aDest, boolean aMoveProvides, boolean aMoveRequires) {
        DefaultListModel theAlist = (DefaultListModel)aSrc.getModel();
        DefaultListModel theBlist = (DefaultListModel)aDest.getModel();
        for (Object theElement : aSrc.getSelectedValues()) {
            if (this.removeProduct(theElement, theAlist)) {
                this.addProduct(theElement, theBlist);
            }
            if (!aMoveProvides) continue;
            ArrayList<ProductNodeInterface> theFeaturesList = new ArrayList<ProductNodeInterface>();
            this.getFeatures(theElement, theFeaturesList);
            for (ProductNodeInterface theFeature : theFeaturesList) {
                if (!this.removeProduct(theFeature, theAlist)) continue;
                this.addProduct(theFeature, theBlist);
            }
        }
        if (aMoveRequires) {
            for (Object theProduct : theBlist.toArray()) {
                ArrayList<ProductNodeInterface> theDepenList = new ArrayList<ProductNodeInterface>();
                this.getDependencies(theProduct, theDepenList);
                for (ProductNodeInterface theDepen : theDepenList) {
                    if (!this.removeProduct(theDepen, theAlist)) continue;
                    this.addProduct(theDepen, theBlist);
                }
            }
        }
        this.updateDescription();
        this.updateAvailableButtons();
    }

    private void getDependencies(Object aElement, List<ProductNodeInterface> aDepenList) {
        for (ProductNodeInterface theDepen : ((ProductNodeInterface)aElement).getDependencies()) {
            if (null != theDepen.getDependencies() && 0 < theDepen.getDependencies().size()) {
                this.getDependencies(theDepen, aDepenList);
            }
            aDepenList.add(theDepen);
        }
    }

    private void getFeatures(Object aElement, List<ProductNodeInterface> aFeaturesList) {
        for (ProductNodeInterface theFeature : ((ProductNodeInterface)aElement).getFeatures()) {
            if (null != theFeature.getFeatures() && 0 < theFeature.getFeatures().size()) {
                this.getFeatures(theFeature, aFeaturesList);
            }
            aFeaturesList.add(theFeature);
        }
    }

    void moveAll(DefaultListModel aSrcList, DefaultListModel aDestList) {
        int size = aSrcList.size();
        for (int i = 0; i < size; ++i) {
            aDestList.addElement(aSrcList.getElementAt(i));
        }
        aSrcList.clear();
        this.updateDescription();
        this.updateAvailableButtons();
    }

    private void addProduct(Object aProduct, DefaultListModel aModel) {
        for (Object theProduct : aModel.toArray()) {
            if (!((ProductNodeInterface)aProduct).getID().equals(((ProductNodeInterface)theProduct).getID())) continue;
            return;
        }
        aModel.addElement(aProduct);
        this.updateDescription();
        this.updateAvailableButtons();
    }

    private boolean removeProduct(Object aProduct, DefaultListModel aModel) {
        boolean theValueIsDeleted = false;
        for (Object theProduct : aModel.toArray()) {
            if (!((ProductNodeInterface)aProduct).getID().equals(((ProductNodeInterface)theProduct).getID())) continue;
            theValueIsDeleted = aModel.removeElement(theProduct);
        }
        return theValueIsDeleted;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        LOGGER.finest("PSP: " + ClassUtils.getFQMethodName() + " called");
        this.init();
    }

    class PSPListsListener
    implements ListSelectionListener {
        PSPListsListener() {
        }

        public void valueChanged(ListSelectionEvent aListSelectionEvent) {
            if (!aListSelectionEvent.getValueIsAdjusting()) {
                JList theSource = (JList)aListSelectionEvent.getSource();
                if (0 != GUIProductSelectionPage.this.gSelectedsList.getSelectedValues().length && 0 != GUIProductSelectionPage.this.gAvailablesList.getSelectedValues().length) {
                    if (theSource.getName().equalsIgnoreCase(GUIProductSelectionPage.AVAILABLE_LIST_NAME)) {
                        GUIProductSelectionPage.this.gSelectedsList.clearSelection();
                    } else if (theSource.getName().equalsIgnoreCase(GUIProductSelectionPage.this.gSelectedsList.getName())) {
                        GUIProductSelectionPage.this.gAvailablesList.clearSelection();
                    }
                }
                if (-1 != theSource.getSelectedIndex() && 1 >= theSource.getSelectedIndices().length) {
                    GUIProductSelectionPage.this.updateDescription();
                } else {
                    GUIProductSelectionPage.this.gDescription.setText("");
                }
                GUIProductSelectionPage.this.updateAvailableButtons();
            }
        }
    }

    class PSPButtonsListener
    implements ActionListener {
        PSPButtonsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String theCommand = ((Component)e.getSource()).getName();
            if (PSP_ACTIONS.ADD_COMMAND.name().equals(theCommand)) {
                GUIProductSelectionPage.this.moveSelected(GUIProductSelectionPage.this.gAvailablesList, GUIProductSelectionPage.this.gSelectedsList, GUIProductSelectionPage.this.gShowFeatures, GUIProductSelectionPage.this.gShowDependencies);
            } else if (PSP_ACTIONS.ADD_ALL_COMMAND.name().equals(theCommand)) {
                GUIProductSelectionPage.this.moveAll((DefaultListModel)GUIProductSelectionPage.this.gAvailablesList.getModel(), (DefaultListModel)GUIProductSelectionPage.this.gSelectedsList.getModel());
            } else if (PSP_ACTIONS.REMOVE_COMMAND.name().equals(theCommand)) {
                GUIProductSelectionPage.this.moveSelected(GUIProductSelectionPage.this.gSelectedsList, GUIProductSelectionPage.this.gAvailablesList, !GUIProductSelectionPage.this.gUnselectFeatures, !GUIProductSelectionPage.this.gUnselectDependencies);
            } else if (PSP_ACTIONS.REMOVE_ALL_COMMAND.name().equals(theCommand)) {
                GUIProductSelectionPage.this.moveAll((DefaultListModel)GUIProductSelectionPage.this.gSelectedsList.getModel(), (DefaultListModel)GUIProductSelectionPage.this.gAvailablesList.getModel());
            } else {
                LOGGER.finest("PSPButtonsListener received an unexpected event: [" + theCommand + "]");
            }
        }
    }
}

