/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.ui.swixgen;

import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.apoc.APOCPropValue;
import org.openinstaller.provider.conf.oor.ConfigType;
import org.openinstaller.provider.ui.swixgen.SwiXMLGridBagConstraints;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwiXMLVisual {
    private static final Logger LOGGER;
    protected String gStartTag = "";
    protected String gEndTag = "";
    protected StringBuffer gAttributes = new StringBuffer();
    protected StringBuffer gGridBagAttributes = new StringBuffer();
    protected static final String PROPVALUE_CONSTANT = "OOR:";
    protected static final String FREEZE_THAW_SEPARATOR = ";";
    protected static final Pattern REPLACEABLE_VARIABLE_PATTERN;
    private String gActionCommand = "";

    public abstract void setValue(List<APOCPropValue> var1) throws EnhancedException;

    public final void setToolTip(String aToolTip) {
        if (null != aToolTip) {
            this.replaceVariables(aToolTip, "tooltiptext");
        }
    }

    public String getSwiXML() {
        return this.gStartTag + this.gAttributes.toString() + " doublebuffered=\"true\"> " + "<gridbagconstraints " + this.gGridBagAttributes.toString() + " /> " + this.gEndTag;
    }

    protected final void setActionCommand(String aActionCommand) {
        this.gActionCommand = aActionCommand;
        if (null != aActionCommand) {
            this.gAttributes.append(" actionCommand=\"").append(aActionCommand).append('\"');
        }
    }

    public final void setGridBagConstraints(SwiXMLGridBagConstraints aGridBagConstraints) {
        this.setGridX(aGridBagConstraints.getGridX());
        this.setGridY(aGridBagConstraints.getGridY());
        this.setGridWidth(aGridBagConstraints.getGridWidth());
        this.setWeightX(aGridBagConstraints.getWeightX());
        this.setWeightY(aGridBagConstraints.getWeightY());
        this.setGridHeight(aGridBagConstraints.getGridHeight());
        this.setAnchor(aGridBagConstraints.getAnchor());
        this.setFill(aGridBagConstraints.getFill());
        this.setInsets(aGridBagConstraints.getInsets());
    }

    public final void setName(String aName) {
        this.gAttributes.append(" name=\"").append(aName).append('\"');
        this.setID(aName);
    }

    private void setID(String aID) {
        this.gAttributes.append(" id=\"").append(aID).append('\"');
    }

    private void setGridX(int aGridX) {
        this.gGridBagAttributes.append(" gridx=\"").append(aGridX).append('\"');
    }

    private void setGridY(int aGridY) {
        this.gGridBagAttributes.append(" gridy=\"").append(aGridY).append('\"');
    }

    private void setGridWidth(int aGridWidth) {
        this.gGridBagAttributes.append(" gridwidth=\"").append(aGridWidth).append('\"');
    }

    private void setGridHeight(int aGridHeight) {
        this.gGridBagAttributes.append(" gridheight=\"").append(aGridHeight).append('\"');
    }

    public void setAnchor(String aAnchor) {
        this.gGridBagAttributes.append(" anchor=\"").append(aAnchor).append('\"');
    }

    private void setFill(String aFill) {
        this.gGridBagAttributes.append(" fill=\"").append(aFill).append('\"');
    }

    private void setInsets(String aInsets) {
        this.gGridBagAttributes.append(" insets=\"").append(aInsets).append('\"');
    }

    private void setWeightX(int aWeightX) {
        this.gGridBagAttributes.append(" weightx=\"").append(aWeightX).append('\"');
    }

    private void setWeightY(int aWeightY) {
        this.gGridBagAttributes.append(" weighty=\"").append(aWeightY).append('\"');
    }

    protected final String getOORValue(List<APOCPropValue> aValue) throws EnhancedException {
        StringTokenizer theTokenizer;
        String theReturnValue = null;
        if (1 == aValue.size()) {
            for (APOCPropValue thePropValue : aValue) {
                if (!thePropValue.getValue().startsWith(PROPVALUE_CONSTANT)) continue;
                String thePropName = thePropValue.getValue().replaceFirst(PROPVALUE_CONSTANT, "");
                theReturnValue = this.getReturnValue(thePropName);
            }
        }
        if (null == theReturnValue && 2 <= (theTokenizer = new StringTokenizer(this.gActionCommand, ".")).countTokens()) {
            theReturnValue = this.getReturnValue(this.gActionCommand);
        }
        return theReturnValue;
    }

    private String getReturnValue(String aConfigVarname) throws EnhancedException {
        ConfigType theConfigType = ConfigHelper.getType(aConfigVarname);
        Object theUnconfirmedValue = ConfigHelper.getUnconfirmedValue(aConfigVarname);
        String theSeparator = ConfigHelper.getSeparator(aConfigVarname);
        String theReturnValue = theUnconfirmedValue == null ? "" : ConfigHelper.freeze(theUnconfirmedValue, theConfigType);
        return theReturnValue;
    }

    protected void replaceVariables(String aSrcString, String aAttributeName) {
        this.gAttributes.append(" ").append(aAttributeName).append("=\"").append(this.convertAPOCVarToFreemarkerVar(aSrcString)).append('\"');
        LOGGER.fine("replaceVariables() for " + ClassUtils.getCallingClassName() + "\nSrc String: " + aSrcString + "\naAttributeName: " + aAttributeName + "\nNew Text: " + this.gAttributes);
    }

    protected String convertAPOCVarToFreemarkerVar(String aString) {
        String theString = this.replaceAllSpecialChar(aString);
        StringBuffer theValue = new StringBuffer();
        Matcher theMatcher = REPLACEABLE_VARIABLE_PATTERN.matcher(theString);
        if (theMatcher.matches()) {
            theValue.append("${").append(theMatcher.group(1)).append("}");
        } else {
            theValue.append(theString);
        }
        String theValueString = theValue.toString();
        LOGGER.finest(ClassUtils.getMethodName() + ": " + theString + " -> " + theValueString);
        return theValueString;
    }

    protected void setEnabled(boolean aEnabled) {
        this.gAttributes.append(" enabled=\"").append(aEnabled).append('\"');
    }

    public String replaceAllSpecialChar(String aOORValue) {
        String theOORValue = aOORValue;
        if (theOORValue != null) {
            theOORValue = theOORValue.replaceAll("&", "&amp;");
            theOORValue = theOORValue.replaceAll("<", "&lt;");
            theOORValue = theOORValue.replaceAll(">", "&gt;");
            theOORValue = theOORValue.replaceAll("\"", "&quot;");
            theOORValue = theOORValue.replaceAll("'", "&apos;");
        }
        return theOORValue;
    }

    static {
        REPLACEABLE_VARIABLE_PATTERN = Pattern.compile("\\$([A-Za-z][A-Za-z0-9_.-]*)");
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
    }
}

