/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.ItemEvent;
import charva.awt.event.KeyEvent;
import charvax.swing.AbstractButton;

public class JCheckBox
extends AbstractButton {
    public JCheckBox() {
        this("", false);
    }

    public JCheckBox(String text_) {
        this(text_, false);
    }

    public JCheckBox(String label_, boolean value_) {
        super.setText(label_);
        super.setSelected(value_);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return super.getText().length() + 4 + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void draw() {
        super.draw();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit term = Toolkit.getDefaultToolkit();
        term.setCursor(origin.addOffset(insets.left, insets.top));
        String valstring = super.isSelected() ? "[*] " : "[ ] ";
        int colorpair = this.getCursesColor();
        int attribute = this._enabled ? Toolkit.A_BOLD : 0;
        term.addString(valstring + super.getLabelString(), attribute, colorpair);
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        Toolkit term = Toolkit.getDefaultToolkit();
        int key = ke_.getKeyCode();
        switch (key) {
            case 9: {
                this.getParent().nextFocus();
                return;
            }
            case 353: {
                this.getParent().previousFocus();
                return;
            }
            case 343: {
                if (!super.isEnabled()) {
                    term.beep();
                    return;
                }
                super.setSelected(!super.isSelected());
                EventQueue queue = term.getSystemEventQueue();
                int state = super.isSelected() ? 100 : 101;
                queue.postEvent(new ItemEvent(this, this, state));
            }
        }
        this.draw();
        this.requestFocus();
        super.requestSync();
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        Toolkit.getDefaultToolkit().setCursor(origin.addOffset(1 + insets.left, 0 + insets.top));
    }

    public String toString() {
        return "JCheckBox location=" + this.getLocation() + " label=\"" + this.getLabel() + "\" actionCommand=\"" + this.getActionCommand() + "\" selected=" + this.isSelected();
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JCheckBox origin=" + this._origin + " size=" + this.getSize() + " label=" + super.getText());
    }
}

