/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.config.PropertySheet;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.core.OrchestratorCommand;
import org.openinstaller.core.PROCESSING_MODE;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.conf.ResultReport;
import org.openinstaller.provider.conf.apoc.APOCProperty;
import org.openinstaller.provider.conf.apoc.APOCSection;
import org.openinstaller.provider.conf.apoc.APOCTemplate;
import org.openinstaller.provider.conf.oor.OORProp;
import org.openinstaller.provider.dependency.InstallableUnitParameter;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.operation.Operation;
import org.openinstaller.provider.task.ConfigTask;
import org.openinstaller.provider.task.InstallImageConfigTask;
import org.openinstaller.provider.task.InstallImageResetTask;
import org.openinstaller.provider.task.InstallTask;
import org.openinstaller.provider.task.ProgressReporter;
import org.openinstaller.provider.task.RegisterTask;
import org.openinstaller.provider.task.Task;
import org.openinstaller.provider.task.UnconfigTask;
import org.openinstaller.provider.task.UninstallTask;
import org.openinstaller.provider.task.UnregisterTask;
import org.openinstaller.sims.FractionalProgressListener;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.FileUtils;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Summary;
import org.openinstaller.util.install.Common;
import org.openinstaller.util.logging.LogUtils;
import org.openinstaller.util.substitution.SubstitutionEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TaskDriver {
    private static final Logger LOGGER;
    private BusResponse gResp;
    private List<Operation> gUniqueOperations;
    private List<Summary> gSummary;
    private File gSummaryFile;
    private File gLogFile;
    private boolean gDryRun = false;
    public static final Map<Operation.OPTYPE, Integer> gOpWeights;
    private Map<String, Map<Operation.OPTYPE, Map<String, Boolean>>> gPkgStatus;

    public void initialize(List<Operation> aUniqueOperations, BusResponse aResp) throws EnhancedException {
        this.gUniqueOperations = aUniqueOperations;
        this.gResp = aResp;
        BusRequest theReq = new BusRequest("ModeRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DRY_RUN_FILE));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
        this.gDryRun = theResp.getResult() != null;
        Task.setDryRun(this.gDryRun);
    }

    public void executeTask() throws EnhancedException {
        this.gPkgStatus = new HashMap<String, Map<Operation.OPTYPE, Map<String, Boolean>>>();
        this.gSummary = new ArrayList<Summary>();
        if (this.gUniqueOperations != null) {
            int theWeightedOperationsCount = this.getWeightedTotal(this.gUniqueOperations);
            Date theStartTime = new Date();
            block20: for (int theCount = 0; theCount < this.gUniqueOperations.size(); ++theCount) {
                int theSecsLeft;
                int theOpsSoFar = this.getWeightedTotal(this.gUniqueOperations.subList(0, theCount));
                final int thePercentComplete = 100 * theOpsSoFar / theWeightedOperationsCount;
                int theOpsAfterThis = this.getWeightedTotal(this.gUniqueOperations.subList(0, theCount + 1));
                final int thePercentCompleteAfterThis = 100 * theOpsAfterThis / theWeightedOperationsCount;
                if (theCount > 0) {
                    Date theCurrentTime = new Date();
                    double theMilliSecsPerOp = (theCurrentTime.getTime() - theStartTime.getTime()) / (long)theOpsSoFar;
                    theSecsLeft = (int)((double)(theWeightedOperationsCount - theOpsSoFar) * theMilliSecsPerOp / 1000.0);
                } else {
                    theSecsLeft = -1;
                }
                final Operation theOp = this.gUniqueOperations.get(theCount);
                Operation.OPTYPE theOPType = theOp.getOperation();
                switch (theOPType) {
                    case INSTALL: {
                        final Package thePkgToInstall = theOp.getMediaPackage();
                        String theProductForThisPkg = theOp.getMediaProduct().getID();
                        LOGGER.log(Level.INFO, "OP_INSTALL", new String[]{"pkg=" + thePkgToInstall.getName(), "prod=" + theProductForThisPkg});
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"INSTALLING", (Object[])new Object[]{thePkgToInstall.getName()}), thePercentComplete, Msg.get((String)"INSTALLING", (Object[])new Object[]{theOp.getMediaProduct().getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        Map<String, String> theParams = this.resolveParameters((List)theOp.getData(), theOp.getMediaProduct().getID());
                        InstallTask theInstallTask = new InstallTask(thePkgToInstall, theOp.getMediaProduct().getID(), theParams, theOp.getMediaPlatform());
                        ProgressListener theUpdater = new ProgressListener(){

                            public void updateProgress(int aProgress) {
                                try {
                                    ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, aProgress, Msg.get((String)"INSTALLING", (Object[])new Object[]{thePkgToInstall.getName()}), aProgress, Msg.get((String)"INSTALLING", (Object[])new Object[]{theOp.getMediaProduct().getDescription()}));
                                    TaskDriver.this.gResp.setResult((Object)theSubtotalProg, true, aProgress);
                                }
                                catch (EnhancedException theEx) {
                                    LOGGER.log(Level.FINE, "Cannot update progress", theEx);
                                }
                            }
                        };
                        FractionalProgressListener fpl = new FractionalProgressListener(theUpdater, thePercentComplete, thePercentCompleteAfterThis);
                        boolean theSuccess = theInstallTask.perform((ProgressListener)fpl);
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"INSTALLED_PACKAGE", (Object[])new Object[]{thePkgToInstall.getName()}), thePercentComplete, Msg.get((String)"INSTALLING", (Object[])new Object[]{theOp.getMediaProduct().getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentCompleteAfterThis);
                        LOGGER.log(Level.FINE, "Subtotal progress: " + thePercentComplete);
                        if (this.gDryRun) {
                            LOGGER.log(Level.FINE, "This is a dry-run mode.  Package will not be installed.");
                        }
                        this.addProductPkgStatus(theProductForThisPkg, thePkgToInstall.getName(), Operation.OPTYPE.INSTALL, theSuccess);
                        continue block20;
                    }
                    case REMOVE: {
                        Package thePkgToUninstall = theOp.getSystemPackage();
                        String theProductForThisPkg = theOp.getSystemProduct().getName();
                        LOGGER.log(Level.INFO, "OP_UNINSTALL", new String[]{"pkg=" + thePkgToUninstall.getName(), "prod=" + theProductForThisPkg});
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"UNINSTALLING", (Object[])new Object[]{thePkgToUninstall.getName()}), thePercentComplete, Msg.get((String)"UNINSTALLING", (Object[])new Object[]{theOp.getSystemProduct().getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        UninstallTask theUninstallTask = new UninstallTask(thePkgToUninstall);
                        boolean theSuccess = theUninstallTask.perform(ProgressListener.DUMMY_LISTENER);
                        LOGGER.log(Level.FINE, "CALCULATING SUBTOTAL");
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"UNINSTALLED_PACKAGE", (Object[])new Object[]{thePkgToUninstall.getName()}), thePercentComplete, Msg.get((String)"UNINSTALLING", (Object[])new Object[]{theOp.getSystemProduct().getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        if (this.gDryRun) {
                            LOGGER.log(Level.FINE, "Dry run mode - Nothing will be uninstalled");
                        }
                        this.addProductPkgStatus(theProductForThisPkg, thePkgToUninstall.getName(), Operation.OPTYPE.REMOVE, theSuccess);
                        continue block20;
                    }
                    case UPGRADE: {
                        throw new RuntimeException("not implemented");
                    }
                    case UNCONFIGURE: {
                        final SystemProduct theProduct = theOp.getSystemProduct();
                        LOGGER.log(Level.INFO, "OP_UNCONFIGURE", new String[]{"prod=" + theProduct.getName()});
                        UnconfigTask theUnconfigTask = new UnconfigTask(theProduct.getName());
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"RUNNING_UNCONFIGURATOR", (Object[])new Object[]{theProduct.getDescription()}), thePercentComplete, Msg.get((String)"UNCONFIGURING", (Object[])new Object[]{theProduct.getName()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        NotificationListener theUnconfigJMXListener = new NotificationListener(){

                            public void handleNotification(Notification aNotification, Object aHandback) {
                                String theMessageProgress = aNotification.getMessage();
                                int theIndex = theMessageProgress.indexOf(":");
                                String theProgress = theMessageProgress.substring(0, theIndex);
                                int theConfigProgress = Integer.parseInt(theProgress);
                                String theMessage = theMessageProgress.substring(theIndex + 1);
                                int theFractionalProgress = thePercentComplete + (int)((double)theConfigProgress / 100.0 * (double)(thePercentCompleteAfterThis - thePercentComplete));
                                try {
                                    ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, theFractionalProgress, Msg.get((String)"RUNNING_UNCONFIGURATOR", (Object[])new Object[]{theProduct.getDescription()}), theFractionalProgress, theMessage);
                                    TaskDriver.this.gResp.setResult((Object)theSubtotalProg, true, theFractionalProgress);
                                }
                                catch (EnhancedException theEx) {
                                    LOGGER.log(Level.FINE, "cannot update progress", theEx);
                                }
                            }
                        };
                        ControlBus.getInstance().publishRequest(new BusRequest("Request to add notification Listener", (Object)new ConfigControl(ConfigControl.ConfigCommand.ADD_CONFIG_PROGRESS_LISTENER, theUnconfigJMXListener)), "svc://general/conf");
                        theUnconfigTask.perform(ProgressListener.DUMMY_LISTENER);
                        ControlBus.getInstance().publishRequest(new BusRequest("Request to remove notification Listener", (Object)new ConfigControl(ConfigControl.ConfigCommand.REMOVE_CONFIG_PROGRESS_LISTENER, theUnconfigJMXListener)), "svc://general/conf");
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentCompleteAfterThis, Msg.get((String)"DONE", (Object[])new Object[0]), thePercentCompleteAfterThis, Msg.get((String)"UNCONFIGURED_PACKAGE", (Object[])new Object[]{theProduct.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentCompleteAfterThis);
                        ResultReport theUnconfigureRR = theUnconfigTask.getConfigReport();
                        Summary theUnconfigSum = new Summary();
                        theUnconfigSum.setOperation(Operation.OPTYPE.UNCONFIGURE);
                        theUnconfigSum.setProductName(theProduct.getShortDescription());
                        theUnconfigSum.setProductVersion(theProduct.getVersion().toString());
                        if (theUnconfigureRR == null) {
                            theUnconfigSum.setStatus(Boolean.FALSE.booleanValue());
                            theUnconfigSum.setStatusMsg(Msg.get((String)"NOT_UNCONFIGURED", (Object[])new Object[0]));
                            if (theUnconfigTask.getException() != null) {
                                theUnconfigSum.setPlatformError(theUnconfigTask.getException().getLocalizedMessage());
                            } else {
                                theUnconfigSum.setPlatformError(Msg.get((String)"NONE", (Object[])new Object[0]));
                            }
                            theUnconfigSum.setProductError(Msg.get((String)"NONE", (Object[])new Object[0]));
                            theUnconfigSum.setDocReference(Msg.get((String)"NONE", (Object[])new Object[0]));
                            theUnconfigSum.setNextSteps(Msg.get((String)"CHECK_INSTALL_LOG", (Object[])new Object[0]));
                        } else {
                            theUnconfigSum.setPlatformError(theUnconfigureRR.getPlatformError());
                            theUnconfigSum.setProductError(theUnconfigureRR.getProductError());
                            theUnconfigSum.setDocReference(theUnconfigureRR.getDocReference());
                            theUnconfigSum.setNextSteps(theUnconfigureRR.getNextSteps());
                            if (theUnconfigureRR.getConfigStatus() == ResultReport.ResultStatus.SUCCESS) {
                                theUnconfigSum.setStatus(Boolean.TRUE.booleanValue());
                                theUnconfigSum.setStatusMsg(Msg.get((String)"UNCONFIGURED", (Object[])new Object[0]));
                            } else {
                                theUnconfigSum.setStatus(Boolean.FALSE.booleanValue());
                                theUnconfigSum.setStatusMsg(Msg.get((String)"NOT_UNCONFIGURED", (Object[])new Object[0]));
                            }
                        }
                        this.gSummary.add(theUnconfigSum);
                        continue block20;
                    }
                    case CONFIGURE: {
                        final MediaProduct theComponent = theOp.getMediaProduct();
                        LOGGER.log(Level.INFO, "OP_CONFIGURE", new String[]{"prod=" + theComponent.getID()});
                        ConfigTask theConfigTask = new ConfigTask(theComponent.getID());
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"RUNNING_CONFIGURATOR", (Object[])new Object[]{theComponent.getDescription()}), thePercentComplete, Msg.get((String)"CONFIGURING", (Object[])new Object[]{theComponent.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        NotificationListener theConfigJMXListener = new NotificationListener(){

                            public void handleNotification(Notification aNotification, Object aHandback) {
                                String theMessageProgress = aNotification.getMessage();
                                int theIndex = theMessageProgress.indexOf(":");
                                String theProgress = theMessageProgress.substring(0, theIndex);
                                int theConfigProgress = Integer.parseInt(theProgress);
                                String theMessage = theMessageProgress.substring(theIndex + 1);
                                int theFractionalProgress = thePercentComplete + (int)((double)theConfigProgress / 100.0 * (double)(thePercentCompleteAfterThis - thePercentComplete));
                                try {
                                    ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, theFractionalProgress, Msg.get((String)"RUNNING_CONFIGURATOR", (Object[])new Object[]{theComponent.getDescription()}), theFractionalProgress, theMessage);
                                    TaskDriver.this.gResp.setResult((Object)theSubtotalProg, true, theFractionalProgress);
                                }
                                catch (EnhancedException theEx) {
                                    LOGGER.log(Level.FINE, "cannot update progress", theEx);
                                }
                            }
                        };
                        ControlBus.getInstance().publishRequest(new BusRequest("Request to add notification Listener", (Object)new ConfigControl(ConfigControl.ConfigCommand.ADD_CONFIG_PROGRESS_LISTENER, theConfigJMXListener)), "svc://general/conf");
                        theConfigTask.perform(ProgressListener.DUMMY_LISTENER);
                        ControlBus.getInstance().publishRequest(new BusRequest("Request to remove notification Listener", (Object)new ConfigControl(ConfigControl.ConfigCommand.REMOVE_CONFIG_PROGRESS_LISTENER, theConfigJMXListener)), "svc://general/conf");
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentCompleteAfterThis, Msg.get((String)"DONE", (Object[])new Object[0]), thePercentCompleteAfterThis, Msg.get((String)"CONFIGURED_PACKAGE", (Object[])new Object[]{theComponent.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentCompleteAfterThis);
                        ResultReport theRR = theConfigTask.getConfigReport();
                        Summary theConfigSum = new Summary();
                        theConfigSum.setOperation(Operation.OPTYPE.CONFIGURE);
                        theConfigSum.setProductName(theComponent.getName());
                        theConfigSum.setProductVersion(theComponent.getVersionStr());
                        if (theRR == null) {
                            theConfigSum.setStatus(Boolean.FALSE.booleanValue());
                            theConfigSum.setStatusMsg(Msg.get((String)"NOT_CONFIGURED", (Object[])new Object[0]));
                            if (theConfigTask.getException() != null) {
                                theConfigSum.setPlatformError(theConfigTask.getException().getLocalizedMessage());
                            } else {
                                theConfigSum.setPlatformError(Msg.get((String)"NONE", (Object[])new Object[0]));
                            }
                            theConfigSum.setProductError(Msg.get((String)"NONE", (Object[])new Object[0]));
                            theConfigSum.setDocReference(Msg.get((String)"NONE", (Object[])new Object[0]));
                            theConfigSum.setNextSteps(Msg.get((String)"CHECK_INSTALL_LOG", (Object[])new Object[0]));
                        } else {
                            theConfigSum.setPlatformError(theRR.getPlatformError());
                            theConfigSum.setProductError(theRR.getProductError());
                            theConfigSum.setDocReference(theRR.getDocReference());
                            theConfigSum.setNextSteps(theRR.getNextSteps());
                            if (theRR.getConfigStatus() == ResultReport.ResultStatus.SUCCESS) {
                                theConfigSum.setStatus(Boolean.TRUE.booleanValue());
                                theConfigSum.setStatusMsg(Msg.get((String)"CONFIGURED", (Object[])new Object[0]));
                            } else {
                                theConfigSum.setStatus(Boolean.FALSE.booleanValue());
                                theConfigSum.setStatusMsg(Msg.get((String)"NOT_CONFIGURED", (Object[])new Object[0]));
                            }
                        }
                        this.gSummary.add(theConfigSum);
                        continue block20;
                    }
                    case REPAIR: 
                    case REGISTER: {
                        String theStatusMsg;
                        Boolean theStatus;
                        String theSubDesc;
                        Package theHybridPkg = theOp.getMediaPackage();
                        MediaProduct theHybridProd = theOp.getMediaProduct();
                        RegisterTask theRegisterTask = new RegisterTask(theHybridPkg, theHybridProd, theOp.getMediaPlatform());
                        if (theHybridPkg != null) {
                            theSubDesc = Msg.get((String)"REGISTERING_PACKAGE", (Object[])new Object[]{theHybridPkg.getName()});
                            LOGGER.log(Level.INFO, "OP_REGISTER", "pkg=" + theHybridPkg.getName());
                        } else {
                            theSubDesc = Msg.get((String)"REGISTERING_PRODUCT", (Object[])new Object[]{theHybridProd.getName()});
                            LOGGER.log(Level.INFO, "OP_REGISTER", "prod=" + theHybridProd.getID());
                        }
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, theSubDesc, thePercentComplete, Msg.get((String)"REGISTERING_PRODUCT", (Object[])new Object[]{theHybridProd.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        theRegisterTask.perform(ProgressListener.DUMMY_LISTENER);
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"REGISTRATION_DONE", (Object[])new Object[0]), thePercentComplete, Msg.get((String)"REGISTERED", (Object[])new Object[]{theHybridProd.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        if (theOp.getMediaPackage() != null) continue block20;
                        LOGGER.log(Level.FINE, "Total Overall progress = [" + thePercentComplete + "]");
                        if (this.countPkgStatus(theHybridProd.getID()) == 0) {
                            theStatus = Boolean.TRUE;
                            theStatusMsg = theOPType == Operation.OPTYPE.REPAIR ? Msg.get((String)"REPAIRED", (Object[])new Object[0]) : Msg.get((String)"INSTALLED", (Object[])new Object[0]);
                        } else {
                            theStatus = Boolean.FALSE;
                            theStatusMsg = theOPType == Operation.OPTYPE.REPAIR ? Msg.get((String)"NOT_REPAIRED", (Object[])new Object[0]) : Msg.get((String)"NOT_INSTALLED", (Object[])new Object[0]);
                        }
                        Summary theSum = new Summary(theHybridProd.getName(), theHybridProd.getVersionStr(), theStatus.booleanValue(), theStatusMsg, null, null, null, null);
                        theSum.setOperation(theOPType == Operation.OPTYPE.REGISTER ? Operation.OPTYPE.INSTALL : theOPType);
                        Map<Operation.OPTYPE, Map<String, Boolean>> thePkgs = this.gPkgStatus.get(theHybridProd.getID());
                        if (thePkgs != null) {
                            for (Operation.OPTYPE thePkgOp : thePkgs.keySet()) {
                                Map<String, Boolean> thePkgResults = thePkgs.get((Object)thePkgOp);
                                for (String thePkgName : thePkgResults.keySet()) {
                                    String theMsg = thePkgResults.get(thePkgName) != false ? Msg.get((String)"PKG_STATUS_SUCCESS", (Object[])new Object[]{thePkgName, thePkgOp}) : Msg.get((String)"PKG_STATUS_FAIL", (Object[])new Object[]{thePkgName, thePkgOp});
                                    theSum.addOtherDetail(theMsg);
                                }
                            }
                        }
                        this.gSummary.add(theSum);
                        this.gPkgStatus.clear();
                        continue block20;
                    }
                    case UNREGISTER: {
                        String theStatusMsg;
                        Boolean theStatus;
                        String theDesc;
                        Package theSystemPkg = theOp.getSystemPackage();
                        SystemProduct theSystemProd = theOp.getSystemProduct();
                        if (theSystemPkg != null) {
                            theDesc = Msg.get((String)"UNREGISTERING_PACKAGE", (Object[])new Object[]{theSystemPkg.getName()});
                            LOGGER.log(Level.INFO, "OP_UNREGISTER", new String[]{"pkg=" + theSystemPkg.getName()});
                        } else {
                            theDesc = Msg.get((String)"UNREGISTERING", (Object[])new Object[]{theSystemProd.getDescription()});
                            LOGGER.log(Level.INFO, "OP_UNREGISTER", new String[]{"prod=" + theSystemProd.getName()});
                        }
                        UnregisterTask theUnregisterTask = new UnregisterTask(theSystemPkg, theSystemProd);
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, theDesc, thePercentComplete, Msg.get((String)"UNREGISTERING", (Object[])new Object[]{theSystemProd.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        theUnregisterTask.perform(ProgressListener.DUMMY_LISTENER);
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"UNREGISTRATION_DONE", (Object[])new Object[0]), thePercentComplete, Msg.get((String)"UNREGISTERED", (Object[])new Object[]{theSystemProd.getDescription()}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        if (theOp.getSystemPackage() != null) continue block20;
                        LOGGER.log(Level.FINE, "Total Overall progress = [" + thePercentComplete + "]");
                        if (this.countPkgStatus(theSystemProd.getName()) == 0) {
                            theStatus = Boolean.TRUE;
                            theStatusMsg = Msg.get((String)"UNINSTALLED", (Object[])new Object[0]);
                        } else {
                            theStatus = Boolean.FALSE;
                            theStatusMsg = Msg.get((String)"NOT_REMOVED", (Object[])new Object[0]);
                        }
                        Summary theSum = new Summary(theSystemProd.getShortDescription(), theSystemProd.getVersion().toString(), theStatus.booleanValue(), theStatusMsg, null, null, null, null);
                        theSum.setOperation(Operation.OPTYPE.REMOVE);
                        Map<Operation.OPTYPE, Map<String, Boolean>> thePkgs = this.gPkgStatus.get(theSystemProd.getName());
                        if (thePkgs != null) {
                            for (Operation.OPTYPE thePkgOp : thePkgs.keySet()) {
                                Map<String, Boolean> thePkgResults = thePkgs.get((Object)thePkgOp);
                                for (String thePkgName : thePkgResults.keySet()) {
                                    String theMsg = Msg.get((String)"PKG_STATUS", (Object[])new Object[]{thePkgName, thePkgOp, thePkgResults.get(thePkgName)});
                                    theSum.addOtherDetail(theMsg);
                                }
                            }
                        }
                        this.gSummary.add(theSum);
                        this.gPkgStatus.clear();
                        continue block20;
                    }
                    case REREGISTER: {
                        throw new RuntimeException("not implemented");
                    }
                    case INSTALL_IMAGE_CONFIGURE: {
                        MediaProduct theComp = theOp.getMediaProduct();
                        LOGGER.log(Level.INFO, "OP_INSTALL_IMAGE_CONFIGURE", new String[]{"prod=" + theComp.getID()});
                        InstallImageConfigTask theIIConfigTask = new InstallImageConfigTask(theComp.getID());
                        String theDescription = theComp.getDescription();
                        LOGGER.finest("INSTALL_IMAGE_CONFIGURE accepted for " + theDescription);
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"CREATING_SHORTCUTS_FOR", (Object[])new Object[]{theDescription}), thePercentComplete, Msg.get((String)"CONFIGURING_THE_INSTALL_IMAGE_FOR", (Object[])new Object[]{theDescription}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        theIIConfigTask.perform(ProgressListener.DUMMY_LISTENER);
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"DONE", (Object[])new Object[0]), thePercentComplete, Msg.get((String)"SHORTCUTS_CREATED_FOR", (Object[])new Object[]{theDescription}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        continue block20;
                    }
                    case INSTALL_IMAGE_RESET: {
                        LOGGER.finest("INSTALL_IMAGE_RESET accepted by TaskDriver");
                        MediaProduct theProd = theOp.getMediaProduct();
                        LOGGER.log(Level.INFO, "OP_INSTALL_IMAGE_RESET", new String[]{"prod=" + theProd.getID()});
                        InstallImageResetTask theIIResetTask = new InstallImageResetTask(theProd.getID());
                        String theProdDesc = theProd.getDescription();
                        LOGGER.finest("INSTALL_IMAGE_RESET accepted for " + theProdDesc);
                        ProgressReporter theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"REMOVING_SHORTCUTS_FOR", (Object[])new Object[]{theProdDesc}), thePercentComplete, Msg.get((String)"RESETTING_THE_INSTALL_IMAGE_FOR", (Object[])new Object[]{theProdDesc}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        theIIResetTask.perform(ProgressListener.DUMMY_LISTENER);
                        theSubtotalProg = new ProgressReporter(theSecsLeft, thePercentComplete, Msg.get((String)"DONE", (Object[])new Object[0]), thePercentComplete, Msg.get((String)"SHORTCUTS_REMOVED_FOR", (Object[])new Object[]{theProdDesc}));
                        this.gResp.setResult((Object)theSubtotalProg, true, thePercentComplete);
                        continue block20;
                    }
                    default: {
                        throw new EnhancedException("UNKNOWN_OPERATION", new String[]{"operation=" + (Object)((Object)theOPType)});
                    }
                }
            }
        } else {
            LOGGER.log(Level.WARNING, "NO_OPERATIONS_TO_EXECUTE");
        }
        if (this.gDryRun) {
            LOGGER.log(Level.FINE, "Writing answer properties");
            List<APOCTemplate> theUIConfig = TaskDriver.getUIConfig();
            try {
                TaskDriver.writeDryRunFile(theUIConfig);
            }
            catch (EnhancedException theEx) {
                LOGGER.log(Level.WARNING, "CANNOT_SAVE_DRYRUN_FILE", theEx);
            }
        }
        String theInstallHome = (String)ConfigHelper.getValue("InstallHome.directory.INSTALL_HOME");
        if (!this.gDryRun) {
            LOGGER.log(Level.FINE, "Writing .ConfigData");
            List<PropertySheet> theConfigSheets = TaskDriver.getConfigurationData();
            TaskDriver.persistConfigurationData(theConfigSheets);
        }
        try {
            File theCurrentLogFile;
            File theFinalLogLoc;
            if (this.gDryRun) {
                theFinalLogLoc = new File(System.getProperty("java.io.tmpdir"));
            } else {
                BusRequest theReq = new BusRequest("ModeRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.LOGS_LOCATION));
                BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
                if (theResp.getException() == null && theResp.getResult() != null) {
                    theFinalLogLoc = new File((String)theResp.getResult());
                } else {
                    File theHome = new File(theInstallHome);
                    File theHomeVar = new File(theHome, "var");
                    File theHomeInstall = new File(theHomeVar, "install");
                    theFinalLogLoc = new File(theHomeInstall, "logs");
                }
            }
            if (!theFinalLogLoc.exists()) {
                theFinalLogLoc.mkdirs();
            }
            String theModeDesc = Common.getProcessingMode().toLowerCase();
            LOGGER.log(Level.FINE, "Saving copy of localized log file");
            File theFinalLog = this.gLogFile = (theCurrentLogFile = (File)ControlBus.getInstance().publishRequest(new BusRequest("log file", (Object)new OrchestratorCommand(OrchestratorCommand.COMMAND.GET_TEMP_LOG_LOCATION, null)), "svc://general/orchestrator").getResult());
            if (theCurrentLogFile != null && !this.gDryRun) {
                try {
                    theFinalLog = this.gLogFile = this.saveLogFileWithDate(theCurrentLogFile, theFinalLogLoc, theModeDesc);
                }
                catch (IOException theEx) {
                    LogUtils.log((Logger)LOGGER, (Level)Level.WARNING, (String)"CANNOT_SAVE_LOG", (Throwable)theEx, (String[])new String[]{theFinalLogLoc.getAbsolutePath()});
                }
            }
            this.gSummaryFile = this.gDryRun ? File.createTempFile("summary", null) : new File(theFinalLogLoc, new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date()) + "-" + theModeDesc + "-summary.html");
            String theProdName = Common.getDefaultProductID();
            PrintWriter theWriter = new PrintWriter(this.gSummaryFile, "UTF-8");
            Summary.printHTMLSummary((String)theProdName, (String)theFinalLog.getName(), this.gSummary, (PrintWriter)theWriter);
            theWriter.close();
            LOGGER.log(Level.INFO, "SAVING_SUMMARY", "file=" + this.gSummaryFile.getAbsolutePath());
            LOGGER.log(Level.INFO, "SAVING_LOG", "file=" + this.gLogFile.getAbsolutePath());
        }
        catch (IOException theEx) {
            LogUtils.log((Logger)LOGGER, (Level)Level.WARNING, (String)"CANNOT_CREATE_SUMMARY", (Throwable)theEx, (String[])new String[]{"file=" + this.gSummaryFile.getAbsolutePath()});
        }
        try {
            ProgressReporter theProgRep = new ProgressReporter(0, 100, "Installed ", 100, "Installed ");
            this.gResp.setFinalResult((Object)theProgRep);
        }
        catch (EnhancedException theEEx) {
            LOGGER.fine("Unacceptable percent complete, ignoring.");
        }
    }

    private Map<String, String> resolveParameters(List<InstallableUnitParameter> aInstallableUnitParameters, String aID) throws EnhancedException {
        String result;
        HashMap<String, String> theResult = new HashMap<String, String>();
        BusRequest opsReq = new BusRequest("ConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.MERGE_CONFIG_DATA));
        BusResponse opsResp = ControlBus.getInstance().publishRequest(opsReq, "svc://general/EngineConfig");
        boolean mergeConfigData = true;
        if (opsResp != null && opsResp.getException() == null && (result = (String)opsResp.getResult()) != null && result.length() > 0) {
            mergeConfigData = new Boolean(result);
        }
        if (mergeConfigData && ConfigHelper.canConfigure(aID)) {
            List<OORProp> theProps = ConfigHelper.getProperties(aID);
            for (OORProp theProp : theProps) {
                theResult.put(theProp.getName(), ConfigHelper.freeze(theProp.getValue(), theProp.getType()));
            }
        }
        if (aInstallableUnitParameters != null) {
            for (InstallableUnitParameter theParam : aInstallableUnitParameters) {
                if (theParam.isMap()) {
                    if (!theResult.containsKey(theParam.getRealName())) continue;
                    theResult.put(theParam.getMappedName(), (String)theResult.remove(theParam.getRealName()));
                    continue;
                }
                theResult.put(theParam.getRealName(), SubstitutionEngine.resolve((String)theParam.getValue()));
            }
        }
        return theResult;
    }

    private int getWeightedTotal(List<Operation> aUniqueOperations) {
        int theTotal = 0;
        for (Operation theOp : aUniqueOperations) {
            Operation.OPTYPE theOpType = theOp.getOperation();
            if (gOpWeights.containsKey((Object)theOpType)) {
                theTotal += gOpWeights.get((Object)theOpType).intValue();
                continue;
            }
            ++theTotal;
        }
        return theTotal;
    }

    private File saveLogFileWithDate(File aCurrentLogFile, File aFinalLogLoc, String aModeString) throws IOException {
        String theName = new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date()) + "-" + aModeString + ".log";
        File theFinalFile = new File(aFinalLogLoc, theName);
        FileUtils.copyFile((File)aCurrentLogFile, (File)theFinalFile);
        return theFinalFile;
    }

    private int countPkgStatus(String aID) {
        if (this.gPkgStatus == null) {
            return 0;
        }
        Map<Operation.OPTYPE, Map<String, Boolean>> theProdMap = this.gPkgStatus.get(aID);
        if (theProdMap == null) {
            return 0;
        }
        for (Operation.OPTYPE theOp : theProdMap.keySet()) {
            int theFailedCount = 0;
            Map<String, Boolean> theOpMap = theProdMap.get((Object)theOp);
            if (theOpMap == null) continue;
            for (String thePkgName : theOpMap.keySet()) {
                if (theOpMap.get(thePkgName).booleanValue()) continue;
                ++theFailedCount;
            }
            return theFailedCount;
        }
        return 0;
    }

    private void addProductPkgStatus(String aProduct, String aName, Operation.OPTYPE aInstall, boolean aSuccess) {
        Map<String, Boolean> theOpMap;
        Map<Operation.OPTYPE, Map<String, Boolean>> theProdMap;
        if (this.gPkgStatus == null) {
            this.gPkgStatus = new HashMap<String, Map<Operation.OPTYPE, Map<String, Boolean>>>();
        }
        if ((theProdMap = this.gPkgStatus.get(aProduct)) == null) {
            theProdMap = new HashMap<Operation.OPTYPE, Map<String, Boolean>>();
            this.gPkgStatus.put(aProduct, theProdMap);
        }
        if ((theOpMap = theProdMap.get((Object)aInstall)) == null) {
            theOpMap = new HashMap<String, Boolean>();
            theProdMap.put(aInstall, theOpMap);
        }
        theOpMap.put(aName, aSuccess);
    }

    private static List<PropertySheet> getConfigurationData() throws EnhancedException {
        List<Object> theConfigSheets = new ArrayList<PropertySheet>();
        try {
            String theMode = Common.getProcessingMode();
            if (!theMode.equals(PROCESSING_MODE.REMOVE.name())) {
                BusRequest theReq = new BusRequest("ConfigSaveRequest", (Object)new ConfigControl(ConfigControl.ConfigCommand.GET_ALL_CONFIGURATION, null));
                BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/conf");
                Object theConfObj = theResp.getResult();
                if (theConfObj != null) {
                    theConfigSheets = (List)theConfObj;
                }
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_CONFIG_DATA", theNSMEx.getMessage());
        }
        return theConfigSheets;
    }

    private static void persistConfigurationData(List<PropertySheet> aConfigDataSheets) {
        try {
            BusRequest theReq = new BusRequest("ModeRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.CONFIG_STATE));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
            String theState = (String)theResp.getResult();
            File theConfigDataDir = new File(theState);
            if (!theConfigDataDir.exists()) {
                theConfigDataDir.mkdirs();
            }
            if (!aConfigDataSheets.isEmpty()) {
                for (PropertySheet theConfigSheet : aConfigDataSheets) {
                    FileOutputStream theFout = new FileOutputStream(new File(theConfigDataDir, theConfigSheet.getComponentName() + ".xcu"));
                    LOGGER.log(Level.FINER, "Persisting ConfigSheet=[" + theConfigSheet.getComponentName() + "]");
                    theConfigSheet.write((OutputStream)theFout);
                }
            }
        }
        catch (Exception theEx) {
            LOGGER.log(Level.SEVERE, "CANNOT_PERSIST_CONFIG_DATA", theEx);
        }
    }

    private static List<APOCTemplate> getUIConfig() {
        ArrayList theUIConfig = new ArrayList();
        try {
            BusRequest theReq = new BusRequest("ConfigSaveRequest", (Object)new ConfigControl(ConfigControl.ConfigCommand.GET_ALL_UI_CONFIG, null));
            BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/conf");
            Object theUIConfObj = theResp.getResult();
            if (theUIConfObj != null) {
                theUIConfig = (ArrayList)theUIConfObj;
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            theEIAEx.addContext("CANNOT_GET_ALL_UI_CONFIG_DATA", new String[0]);
            LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_ALL_UI_CONFIG_DATA", theNSMEx.getMessage());
        }
        return theUIConfig;
    }

    private static void writeDryRunFile(List<APOCTemplate> aUIConfig) throws EnhancedException {
        Object theResp = null;
        Properties theDryRunFileProps = new Properties();
        File theDryRunFile = TaskDriver.createDryRunFile();
        if (theDryRunFile == null) {
            LOGGER.log(Level.INFO, "DRYRUN_FILE_NOT_PROVIDED");
            return;
        }
        for (APOCTemplate theUITemplate : aUIConfig) {
            String theTemplateName = theUITemplate.getName();
            List<APOCSection> theSections = theUITemplate.getCategory().getPage().getSections();
            if (theSections.isEmpty()) continue;
            for (APOCSection theSection : theSections) {
                List<APOCProperty> theUIProperties = theSection.getProperties();
                if (theUIProperties.isEmpty()) continue;
                for (APOCProperty theUIProperty : theUIProperties) {
                    String theDataPath = theUIProperty.getDataPath();
                    if (!"".equals(theDataPath)) {
                        String thePropValue;
                        String theProductPlusDataPath = theTemplateName + "." + theDataPath;
                        LOGGER.log(Level.FINE, "Property = " + theProductPlusDataPath);
                        try {
                            thePropValue = ConfigHelper.freeze(ConfigHelper.getValue(theProductPlusDataPath), ConfigHelper.getType(theProductPlusDataPath));
                            LOGGER.log(Level.FINE, "[" + theProductPlusDataPath + "]=" + thePropValue);
                        }
                        catch (EnhancedException theEEx) {
                            LOGGER.log(Level.FINE, "Cannot get Config Property", theProductPlusDataPath);
                            continue;
                        }
                        if (null == theProductPlusDataPath || null == thePropValue) continue;
                        theDryRunFileProps.put(theProductPlusDataPath, thePropValue);
                        continue;
                    }
                    LOGGER.log(Level.FINEST, "Skipping Property with no data path");
                }
            }
        }
        try {
            FileOutputStream theDryRunFileOut = new FileOutputStream(theDryRunFile);
            theDryRunFileProps.store(theDryRunFileOut, Msg.get((String)"DRYRUN_COMMENT", (Object[])new Object[0]));
            theDryRunFileOut.close();
        }
        catch (IOException theIOEx) {
            throw new EnhancedException("CANNOT_SAVE_DRYRUN_FILE", (Throwable)theIOEx, new String[]{"file=" + theDryRunFile.getAbsolutePath()});
        }
    }

    private static File createDryRunFile() throws EnhancedException {
        BusRequest theReq = new BusRequest("DryRunFileRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.DRY_RUN_FILE));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/EngineConfig");
        String theDryRunPath = (String)theResp.getResult();
        if (theDryRunPath == null || "".equals(theDryRunPath)) {
            LOGGER.log(Level.WARNING, "DRYRUN_FILE_NOT_PROVIDED");
            return null;
        }
        File theDryRunFile = new File(theDryRunPath);
        if (theDryRunFile.exists()) {
            throw new EnhancedException("DRYRUN_FILE_EXISTS", new String[]{"file=" + theDryRunFile});
        }
        if (theDryRunFile.isDirectory()) {
            throw new EnhancedException("DRYRUN_FILE_IS_A_DIR", new String[]{"file=" + theDryRunFile});
        }
        try {
            if (!theDryRunFile.createNewFile()) {
                throw new EnhancedException("DRYRUN_FILE_NOT_WRITEABLE", new String[]{"file=" + theDryRunFile});
            }
        }
        catch (IOException theEx) {
            throw new EnhancedException("DRYRUN_FILE_NOT_WRITEABLE", new String[]{"file=" + theDryRunFile});
        }
        return theDryRunFile;
    }

    public List<Summary> getSummary() {
        return this.gSummary;
    }

    public File getSummaryFile() {
        return this.gSummaryFile;
    }

    public File getLogFile() {
        return this.gLogFile;
    }

    static {
        gOpWeights = new HashMap<Operation.OPTYPE, Integer>(){
            {
                this.put(Operation.OPTYPE.CONFIGURE, 40);
                this.put(Operation.OPTYPE.UNCONFIGURE, 40);
                this.put(Operation.OPTYPE.MIGRATE, 80);
                this.put(Operation.OPTYPE.INSTALL, 10);
                this.put(Operation.OPTYPE.REMOVE, 20);
                this.put(Operation.OPTYPE.UPGRADE, 20);
                this.put(Operation.OPTYPE.REGISTER, 1);
                this.put(Operation.OPTYPE.UNREGISTER, 1);
                this.put(Operation.OPTYPE.REREGISTER, 1);
                this.put(Operation.OPTYPE.REPAIR, 1);
            }
        };
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
    }
}

