/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.detection;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.JDKSelection.utils.SystemUtils;
import org.openinstaller.util.JDKSelection.utils.applications.JavaUtils;
import org.openinstaller.util.JDKSelection.utils.exceptions.NativeException;
import org.openinstaller.util.JDKSelection.utils.system.windows.WindowsRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLocator {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static List<File> javaLocations = new LinkedList<File>();
    public static List<String> javaLabels = new LinkedList<String>();
    public static List<String> javaVersions = new LinkedList<String>();
    public static List<Boolean> javaIsJDK = new LinkedList<Boolean>();
    public static List<Boolean> javaIsJRE = new LinkedList<Boolean>();
    public static File lastSelectedJava = null;
    public static final String[] JAVA_WINDOWS_REGISTRY_ENTRIES = new String[]{"SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JRockit\\Java Development Kit", "SOFTWARE\\IBM\\Java Development Kit", "SOFTWARE\\IBM\\Java2 Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\JRockit\\Java Runtime Environment", "SOFTWARE\\IBM\\Java Runtime Environment", "SOFTWARE\\IBM\\Java2 Runtime Environment"};
    public static final String[] JAVA_ENVIRONMENT_VARIABLES = new String[]{"JAVA_HOME", "JAVAHOME", "JAVA_PATH", "JDK_HOME", "JDKHOME", "ANT_JAVA", "JAVA", "JDK"};
    public static final String[] JAVA_FILESYSTEM_LOCATIONS = new String[]{"$S{java.home}", "$S{java.home}/..", "$N{install}", "$N{install}/Java", "$N{home}", "$N{home}/Java", "/usr", "/usr/jdk", "/usr/jdk/instances", "/usr/java", "/usr/local", "/usr/local/jdk", "/usr/local/jdk/instances", "/usr/local/java", "/export", "/export/jdk", "/export/jdk/instances", "/export/java", "/opt", "/opt/jdk", "/opt/jdk/instances", "/opt/java", "/Library/Java", "/System/Library/Frameworks/JavaVM.framework/Versions/1.5", "/System/Library/Frameworks/JavaVM.framework/Versions/1.5.0", "/System/Library/Frameworks/JavaVM.framework/Versions/1.6", "/System/Library/Frameworks/JavaVM.framework/Versions/1.6.0", "/System/Library/Frameworks/JavaVM.framework/Versions/1.7", "/System/Library/Frameworks/JavaVM.framework/Versions/1.7.0"};
    public static final String SEPARATOR = "\\*";
    public static final String[] JAVA_MEDIA_LOCATIONS = new String[]{"/usr/java", "/usr/jdk/instances", "/cdrom/*/usr/java", "/cdrom/*/usr/jdk/instances"};

    public static String getLabel(File javaHome) {
        JavaUtils.JavaInfo javaInfo = JavaUtils.getInfo(javaHome);
        return JDKLocator.getLabel(javaHome, javaInfo);
    }

    private static String getLabel(File javaHome, JavaUtils.JavaInfo javaInfo) {
        return "" + javaHome + " (v. " + javaInfo.getVersion().toJdkStyle() + " by " + javaInfo.getVendor() + ")";
    }

    public static String getVersion(File javaHome) {
        JavaUtils.JavaInfo javaInfo = JavaUtils.getInfo(javaHome);
        return JDKLocator.getVersion(javaInfo);
    }

    private static String getVersion(JavaUtils.JavaInfo javaInfo) {
        return "" + javaInfo.getVersion().toJdkStyle();
    }

    public void execute() {
        LinkedList<File> locations = new LinkedList<File>();
        if (SystemUtils.isWindows()) {
            this.fetchLocationsFromWindowsRegistry(locations);
        }
        this.fetchLocationsFromEnvironment(locations);
        this.fetchLocationsFromFilesystem(locations);
        for (File location : locations) {
            File javaHome = location.getAbsoluteFile();
            JavaUtils.JavaInfo javaInfo = JavaUtils.getInfo(javaHome);
            if (javaHome.getName().equals("jre") && JavaUtils.isJdk(javaHome.getParentFile()) || javaInfo == null || javaLocations.contains(javaHome)) continue;
            javaLocations.add(javaHome);
            javaLabels.add(JDKLocator.getLabel(javaHome));
            javaVersions.add(JDKLocator.getVersion(javaHome));
            javaIsJDK.add(JavaUtils.isJdk(javaHome));
            javaIsJRE.add(JavaUtils.isJre(javaHome));
        }
        for (int i = 0; i < javaLocations.size(); ++i) {
            for (int j = javaLocations.size() - 1; j > i; --j) {
                File file1 = javaLocations.get(j);
                File file2 = javaLocations.get(j - 1);
                String label1 = javaLabels.get(j);
                String label2 = javaLabels.get(j - 1);
                String version1 = javaVersions.get(j);
                String version2 = javaVersions.get(j - 1);
                Boolean isjdk1 = javaIsJDK.get(j);
                Boolean isjdk2 = javaIsJDK.get(j - 1);
                Boolean isjre1 = javaIsJRE.get(j);
                Boolean isjre2 = javaIsJRE.get(j - 1);
                JavaUtils.JavaInfo info1 = JavaUtils.getInfo(javaLocations.get(j));
                JavaUtils.JavaInfo info2 = JavaUtils.getInfo(javaLocations.get(j - 1));
                if (info1.getVersion().equals(info2.getVersion())) {
                    if (file1.getPath().compareTo(file2.getPath()) == 0) {
                        if (info1.getVendor().compareTo(info2.getVendor()) == 0 || info1.getVendor().compareTo(info2.getVendor()) >= 0) continue;
                        javaLocations.set(j, file2);
                        javaLocations.set(j - 1, file1);
                        javaLabels.set(j, label2);
                        javaLabels.set(j - 1, label1);
                        javaVersions.set(j, version2);
                        javaVersions.set(j - 1, version1);
                        javaIsJDK.set(j, isjdk2);
                        javaIsJDK.set(j - 1, isjdk1);
                        javaIsJRE.set(j, isjre2);
                        javaIsJRE.set(j - 1, isjre1);
                        continue;
                    }
                    if (file1.getPath().length() >= file2.getPath().length()) continue;
                    javaLocations.set(j, file2);
                    javaLocations.set(j - 1, file1);
                    javaLabels.set(j, label2);
                    javaLabels.set(j - 1, label1);
                    javaVersions.set(j, version2);
                    javaVersions.set(j - 1, version1);
                    javaIsJDK.set(j, isjdk2);
                    javaIsJDK.set(j - 1, isjdk1);
                    javaIsJRE.set(j, isjre2);
                    javaIsJRE.set(j - 1, isjre1);
                    continue;
                }
                if (!info1.getVersion().newerThan(info2.getVersion())) continue;
                javaLocations.set(j, file2);
                javaLocations.set(j - 1, file1);
                javaLabels.set(j, label2);
                javaLabels.set(j - 1, label1);
                javaVersions.set(j, version2);
                javaVersions.set(j - 1, version1);
                javaIsJDK.set(j, isjdk2);
                javaIsJDK.set(j - 1, isjdk1);
                javaIsJRE.set(j, isjre2);
                javaIsJRE.set(j - 1, isjre1);
            }
        }
        if (javaLocations.size() > 0) {
            lastSelectedJava = javaLocations.get(0);
        }
    }

    private void fetchLocationsFromFilesystem(List<File> locations) {
        for (String location : JAVA_FILESYSTEM_LOCATIONS) {
            File parent = SystemUtils.parsePath(location);
            if (!parent.exists() || !parent.isDirectory()) continue;
            locations.add(parent);
            if (parent.getParentFile() == null) continue;
            for (File child : parent.listFiles()) {
                if (!child.isDirectory()) continue;
                locations.add(child);
            }
        }
    }

    private void fetchLocationsFromEnvironment(List<File> locations) {
        for (String name : JAVA_ENVIRONMENT_VARIABLES) {
            File file;
            String value = System.getenv(name);
            if (value == null || locations.contains(file = new File(value).getAbsoluteFile())) continue;
            locations.add(file);
        }
    }

    private void fetchLocationsFromWindowsRegistry(List<File> locations) {
        WindowsRegistry registry = new WindowsRegistry();
        try {
            for (int section : new int[]{2, 1}) {
                for (String path : JAVA_WINDOWS_REGISTRY_ENTRIES) {
                    String[] keys;
                    if (!registry.keyExists(section, path)) continue;
                    for (String key : keys = registry.getSubKeyNames(section, path)) {
                        String javaHome;
                        File file;
                        if (!registry.valueExists(section, path + "\\" + key, "JavaHome") || !(file = new File(javaHome = registry.getStringValue(section, path + "\\" + key, "JavaHome", false))).exists() || !file.isDirectory() || locations.contains(file)) continue;
                        locations.add(file);
                    }
                }
            }
        }
        catch (NativeException e) {
            LOGGER.log(Level.FINE, "Failed to search in the windows registry", e);
        }
    }
}

