/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.util.vfolders.Folder;
import org.openinstaller.bindings.util.vfolders.Include;
import org.openinstaller.bindings.util.vfolders.VFolderInfo;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public class VFolderEditor {
    private File gVFolderFile;
    private VFolderInfo gVFolderInfo;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final String VFOLDER_SCHEMA_PACKAGE = "org.openinstaller.bindings.util.vfolders";

    public VFolderEditor(File aVFolderFile) {
        this.gVFolderFile = aVFolderFile;
    }

    private void unmarshalVFolderInfo() throws EnhancedException {
        try {
            JAXBContext theJAXBContext = JAXBContext.newInstance((String)VFOLDER_SCHEMA_PACKAGE);
            Unmarshaller theUnmarshaller = theJAXBContext.createUnmarshaller();
            Object theVFolderObject = theUnmarshaller.unmarshal(this.gVFolderFile);
            LOGGER.log(Level.FINE, "Unmarshalling done");
            if (theVFolderObject instanceof VFolderInfo) {
                this.gVFolderInfo = (VFolderInfo)theVFolderObject;
            }
        }
        catch (JAXBException theException) {
            throw new EnhancedException("Error initializing JAXB", (Throwable)theException, new String[0]);
        }
    }

    private void marshalVFolderInfo() throws EnhancedException {
        try {
            JAXBContext theJAXBContext = JAXBContext.newInstance((String)VFOLDER_SCHEMA_PACKAGE);
            Marshaller theMarshaller = theJAXBContext.createMarshaller();
            theMarshaller.marshal((Object)this.gVFolderInfo, (OutputStream)new FileOutputStream(this.gVFolderFile));
            LOGGER.log(Level.FINE, "Marshalling done");
        }
        catch (FileNotFoundException theEx) {
            LOGGER.log(Level.WARNING, "INVALID_FILE", "file=" + this.gVFolderFile.getAbsolutePath());
        }
        catch (JAXBException theException) {
            throw new EnhancedException("Error initializing JAXB", (Throwable)theException, new String[0]);
        }
    }

    public void addShortcutEntry(String aTopFolderName, String aFolderName, String aFileName) throws EnhancedException {
        this.unmarshalVFolderInfo();
        Folder theTopFolder = null;
        Folder theFolder = null;
        List theFolderList = this.gVFolderInfo.getFolder().getFolder();
        for (Folder theFolderElement : theFolderList) {
            if (!aTopFolderName.equalsIgnoreCase(theFolderElement.getName())) continue;
            theTopFolder = theFolderElement;
            break;
        }
        if (theTopFolder == null) {
            theTopFolder = new Folder();
            theTopFolder.setName(aTopFolderName);
            theFolderList.add(theTopFolder);
        }
        List theSubFolderList = theTopFolder.getFolder();
        for (Folder theSubFolderElement : theSubFolderList) {
            if (!aFolderName.equalsIgnoreCase(theSubFolderElement.getName())) continue;
            theFolder = theSubFolderElement;
            break;
        }
        if (theFolder == null) {
            theFolder = new Folder();
            theFolder.setName(aFolderName);
            theSubFolderList.add(theFolder);
        }
        Include theInclude = new Include();
        theInclude.setvalue(aFileName);
        boolean theValueAlreadyPresent = false;
        for (Include theIncludedItem : theFolder.getInclude()) {
            if (!aFileName.equalsIgnoreCase(theIncludedItem.getvalue())) continue;
            theValueAlreadyPresent = true;
        }
        if (!theValueAlreadyPresent) {
            theFolder.getInclude().add(theInclude);
        }
        this.marshalVFolderInfo();
    }

    public int removeShortcutEntry(String aTopFolderName, String aFolderName, String aFileName) throws EnhancedException {
        int theRetVal = 0;
        this.unmarshalVFolderInfo();
        Folder theTopFolder = null;
        Folder theFolder = null;
        List theFolderList = this.gVFolderInfo.getFolder().getFolder();
        for (Folder theFolderElement : theFolderList) {
            if (!aTopFolderName.equalsIgnoreCase(theFolderElement.getName())) continue;
            theTopFolder = theFolderElement;
            break;
        }
        List theSubFolderList = theTopFolder.getFolder();
        for (Folder theSubFolderElement : theSubFolderList) {
            if (!aFolderName.equalsIgnoreCase(theSubFolderElement.getName())) continue;
            theFolder = theSubFolderElement;
            break;
        }
        if (theFolder != null) {
            Include theIncludeToBeRemoved = null;
            for (Include theInclude : theFolder.getInclude()) {
                if (!aFileName.equalsIgnoreCase(theInclude.getvalue())) continue;
                theIncludeToBeRemoved = theInclude;
            }
            theFolder.getInclude().remove(theIncludeToBeRemoved);
            if (theFolder.getInclude().size() == 0) {
                theSubFolderList.remove(theFolder);
                if (theSubFolderList.size() == 0) {
                    theFolderList.remove(theTopFolder);
                    theRetVal = 2;
                } else {
                    theRetVal = 1;
                }
            }
        }
        this.marshalVFolderInfo();
        return theRetVal;
    }

    public void createNewVfolderInfoFile(String aUserHome) throws EnhancedException {
        this.gVFolderInfo = new VFolderInfo();
        this.gVFolderInfo.setWriteDir(aUserHome + "/.gnome2/vfolders/applications/");
        this.gVFolderInfo.setItemDir(aUserHome + "/.desktop/");
        Folder theFolder = new Folder();
        theFolder.setName("Root");
        theFolder.setParent("applications-all-users:///");
        this.gVFolderInfo.setFolder(theFolder);
        this.marshalVFolderInfo();
        LOGGER.log(Level.FINE, "File: applications.vfolder-info created.");
    }
}

