/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RepositoryCache {
    private final Map<String, Map<Version, Set<Package>>> gPkgMap = new Hashtable<String, Map<Version, Set<Package>>>();
    private final Map<String, Map<Version, Set<SystemProduct>>> gProdMap = new Hashtable<String, Map<Version, Set<SystemProduct>>>();
    private final Map<Package, Set<Package>> gDependentPkgMap = new Hashtable<Package, Set<Package>>();
    private final Map<SystemProduct, Set<SystemProduct>> gDependentProdMap = new Hashtable<SystemProduct, Set<SystemProduct>>();
    private final Map<Package, Set<SystemProduct>> gContainedPkgMap = new Hashtable<Package, Set<SystemProduct>>();
    private final Map<SystemProduct, Set<SystemProduct>> gContainedProdMap = new Hashtable<SystemProduct, Set<SystemProduct>>();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    protected RepositoryCache() {
    }

    protected Set<SystemProduct> getProductContainers(SystemProduct aContainedProduct) {
        return this.gContainedProdMap.get(aContainedProduct);
    }

    protected Set<SystemProduct> getPackageContainers(Package aContainedPackage) {
        return this.gContainedPkgMap.get(aContainedPackage);
    }

    public Set<SystemProduct> getDependentProducts(SystemProduct aProduct) {
        return this.gDependentProdMap.get(aProduct);
    }

    protected Set<Package> getDependentPackages(Package aRequiredPackage) {
        return this.gDependentPkgMap.get(aRequiredPackage);
    }

    protected void addPackageToCache(Package aNewPackage) {
        Set<Package> thePackageInstanceSet;
        Map<Version, Set<Package>> theInstanceMap = this.gPkgMap.get(aNewPackage.getName());
        if (theInstanceMap == null) {
            theInstanceMap = new TreeMap<Version, Set<Package>>();
            this.gPkgMap.put(aNewPackage.getName(), theInstanceMap);
        }
        if ((thePackageInstanceSet = theInstanceMap.get(aNewPackage.getVersion())) == null) {
            thePackageInstanceSet = new LinkedHashSet<Package>();
            theInstanceMap.put(aNewPackage.getVersion(), thePackageInstanceSet);
        }
        if (thePackageInstanceSet.contains(aNewPackage)) {
            thePackageInstanceSet.remove(aNewPackage);
        }
        thePackageInstanceSet.add(aNewPackage);
        Iterator<Package> theRequiredPkgs = aNewPackage.getRequiredPackages();
        while (theRequiredPkgs.hasNext()) {
            Package theRequiredPkg = theRequiredPkgs.next();
            Set<Package> thePackagesThatRequirePkg = this.gDependentPkgMap.get(theRequiredPkg);
            if (thePackagesThatRequirePkg == null) {
                thePackagesThatRequirePkg = new LinkedHashSet<Package>();
                this.gDependentPkgMap.put(theRequiredPkg, thePackagesThatRequirePkg);
            }
            if (thePackagesThatRequirePkg.contains(aNewPackage)) {
                thePackagesThatRequirePkg.remove(aNewPackage);
            }
            thePackagesThatRequirePkg.add(aNewPackage);
        }
    }

    protected void removePackageFromCache(Package aOldPackage) {
        Set<Package> thePackageInstancesSet;
        Map<Version, Set<Package>> theInstancesMap = this.gPkgMap.get(aOldPackage.getName());
        if (theInstancesMap != null && (thePackageInstancesSet = theInstancesMap.get(aOldPackage.getVersion())) != null) {
            thePackageInstancesSet.remove(aOldPackage);
        }
        Iterator<Package> theRequiredPkgs = aOldPackage.getRequiredPackages();
        while (theRequiredPkgs.hasNext()) {
            Package theRequiredPkg = theRequiredPkgs.next();
            Set<Package> thePackagesThatRequirePkg = this.gDependentPkgMap.get(theRequiredPkg);
            if (thePackagesThatRequirePkg == null || !thePackagesThatRequirePkg.contains(aOldPackage)) continue;
            thePackagesThatRequirePkg.remove(aOldPackage);
        }
    }

    protected void addProductToCache(SystemProduct aNewProduct) {
        Set<SystemProduct> theProductInstancesSet;
        LOGGER.finest(ClassUtils.getFQMethodName() + " " + aNewProduct.getID());
        Map<Version, Set<SystemProduct>> theInstancesMap = this.gProdMap.get(aNewProduct.getName());
        if (theInstancesMap == null) {
            theInstancesMap = new TreeMap<Version, Set<SystemProduct>>();
            this.gProdMap.put(aNewProduct.getName(), theInstancesMap);
        }
        if ((theProductInstancesSet = theInstancesMap.get(aNewProduct.getVersion())) == null) {
            theProductInstancesSet = new LinkedHashSet<SystemProduct>();
            theInstancesMap.put(aNewProduct.getVersion(), theProductInstancesSet);
        }
        theProductInstancesSet.add(aNewProduct);
        for (Package theContainedPkg : aNewProduct.getContainedPackages()) {
            Set<SystemProduct> theProductsThatContainPkg = this.gContainedPkgMap.get(theContainedPkg);
            if (theProductsThatContainPkg == null) {
                theProductsThatContainPkg = new LinkedHashSet<SystemProduct>();
                this.gContainedPkgMap.put(theContainedPkg, theProductsThatContainPkg);
            }
            theProductsThatContainPkg.add(aNewProduct);
        }
        for (SystemProduct theContainedProduct : aNewProduct.getContainedProducts()) {
            Set<SystemProduct> theProductsThatContainProduct = this.gContainedProdMap.get(theContainedProduct);
            if (theProductsThatContainProduct == null) {
                theProductsThatContainProduct = new LinkedHashSet<SystemProduct>();
                this.gContainedProdMap.put(theContainedProduct, theProductsThatContainProduct);
            }
            theProductsThatContainProduct.add(aNewProduct);
        }
        for (SystemProduct theRequiredProd : aNewProduct.getRequiredProducts()) {
            Set<SystemProduct> theProductsThatRequiredProd = this.gDependentProdMap.get(theRequiredProd);
            if (theProductsThatRequiredProd == null) {
                theProductsThatRequiredProd = new LinkedHashSet<SystemProduct>();
                this.gDependentProdMap.put(theRequiredProd, theProductsThatRequiredProd);
            }
            if (theProductsThatRequiredProd.contains(aNewProduct)) {
                theProductsThatRequiredProd.remove(aNewProduct);
            }
            theProductsThatRequiredProd.add(aNewProduct);
        }
    }

    protected void removeProductFromCache(SystemProduct aOldProduct) {
        Set<SystemProduct> theProductInstancesSet;
        Map<Version, Set<SystemProduct>> theInstancesMap = this.gProdMap.get(aOldProduct.getName());
        if (theInstancesMap != null && (theProductInstancesSet = theInstancesMap.get(aOldProduct.getVersion())) != null) {
            theProductInstancesSet.remove(aOldProduct);
        }
        for (Package theContainedPkg : aOldProduct.getContainedPackages()) {
            Set<SystemProduct> theProductsThatContainPkg = this.gContainedPkgMap.get(theContainedPkg);
            if (theProductsThatContainPkg == null) continue;
            theProductsThatContainPkg.remove(aOldProduct);
        }
        for (SystemProduct theContainedProduct : aOldProduct.getContainedProducts()) {
            Set<SystemProduct> theProductsThatContainProduct = this.gContainedProdMap.get(theContainedProduct);
            if (theProductsThatContainProduct == null) continue;
            theProductsThatContainProduct.remove(aOldProduct);
        }
    }

    protected void clear() {
        this.gPkgMap.clear();
        this.gProdMap.clear();
        this.gDependentPkgMap.clear();
        this.gContainedProdMap.clear();
        this.gContainedPkgMap.clear();
    }

    protected Set<SystemProduct> getAllProducts() throws InvalidArgumentException {
        HashSet<SystemProduct> theInstances = new HashSet<SystemProduct>();
        for (String theProductName : this.gProdMap.keySet()) {
            for (SystemProduct theProduct : this.getProductInstances(theProductName, null)) {
                theInstances.add(theProduct);
            }
        }
        return theInstances;
    }

    protected Set<Package> getAllPackages() throws InvalidArgumentException {
        HashSet<Package> theInstances = new HashSet<Package>();
        for (String thePkgName : this.gPkgMap.keySet()) {
            for (Package thePackage : this.getPackageInstances(thePkgName, null)) {
                theInstances.add(thePackage);
            }
        }
        return theInstances;
    }

    protected Set<SystemProduct> getProductInstances(String aProductName, Version aVersion) throws InvalidArgumentException {
        if (aProductName == null) {
            throw new InvalidArgumentException("PROD_NAME_CANNOT_BE_NULL", new String[0]);
        }
        Map<Version, Set<SystemProduct>> theInstanceMap = this.gProdMap.get(aProductName);
        if (theInstanceMap == null) {
            return null;
        }
        if (aVersion == null) {
            LOGGER.finest(" No version specified . Getting all versions ....");
            TreeSet<SystemProduct> theInstances = new TreeSet<SystemProduct>(new Comparator<SystemProduct>(){

                @Override
                public int compare(SystemProduct aProduct, SystemProduct aDifferentProduct) {
                    return aProduct.getName().compareTo(aDifferentProduct.getName());
                }
            });
            for (Set<SystemProduct> theProductInstances : theInstanceMap.values()) {
                theInstances.addAll(theProductInstances);
            }
            return theInstances;
        }
        return theInstanceMap.get(aVersion);
    }

    protected Set<Package> getPackageInstances(String aPackageName, Version aVersion) throws InvalidArgumentException {
        if (aPackageName == null) {
            throw new InvalidArgumentException("PKG_NAME_CANNOT_BE_NULL", new String[0]);
        }
        Map<Version, Set<Package>> theInstanceMap = this.gPkgMap.get(aPackageName);
        if (theInstanceMap == null) {
            return null;
        }
        if (aVersion == null) {
            TreeSet<Package> theInstances = new TreeSet<Package>(new Comparator<Package>(){

                @Override
                public int compare(Package aPackage, Package aDifferentPackage) {
                    return aPackage.getName().compareTo(aDifferentPackage.getName());
                }
            });
            for (Set<Package> theInstanceSet : theInstanceMap.values()) {
                theInstances.addAll(theInstanceSet);
            }
            return theInstances;
        }
        return theInstanceMap.get(aVersion);
    }
}

