/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CSurfaceData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.security.AccessController;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.security.action.LoadLibraryAction;

public class CImage
extends Image {
    private long fNSImage = 0L;
    private BufferedImage fConvertedBI = null;
    private SurfaceData fSurfaceData = null;
    private long fConvertedCGImageRef = 0L;

    public CImage(long l) {
        this.setNSImage(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CImage(Image image) {
        if (image != null) {
            BufferedImage bufferedImage = null;
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
            } else {
                Canvas canvas = new Canvas();
                MediaTracker mediaTracker = new MediaTracker(canvas);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("ImageTracker interrupted.");
                    Thread.dumpStack();
                    return;
                }
                int n = Math.max(image.getWidth(canvas), 1);
                int n2 = Math.max(image.getHeight(canvas), 1);
                bufferedImage = new BufferedImage(n, n2, 3);
                Graphics graphics = bufferedImage.getGraphics();
                try {
                    graphics.drawImage(image, 0, 0, n, n2, null);
                }
                finally {
                    graphics.dispose();
                }
            }
            this.setNSImage(bufferedImage);
        }
    }

    public CImage(String string) {
        long l = this.icon(string);
        this.setNSImage(l);
    }

    public CImage(int n) {
        long l = this.imageFromIconSelector(n);
        this.setNSImage(l);
    }

    private void setNSImage(BufferedImage bufferedImage) {
        long l = this.makeNSImage(bufferedImage);
        this.setNSImage(l);
    }

    private synchronized void setNSImage(long l) {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
        }
        this.fNSImage = l;
    }

    public synchronized void dispose() {
        if (this.fNSImage != 0L) {
            this._release(this.fNSImage);
            this.fNSImage = 0L;
        }
    }

    private native void _release(long var1);

    synchronized long getNSImage() {
        return this.fNSImage;
    }

    protected void finalize() {
        this.dispose();
    }

    private native int width(long var1);

    private native int height(long var1);

    private native void flip(long var1);

    private native long createCGImageRef(SurfaceData var1, int var2, int var3);

    private native long icon(String var1);

    private native long imageFromIconSelector(int var1);

    public synchronized int getWidth(ImageObserver imageObserver) {
        return this.width(this.fNSImage);
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        return this.height(this.fNSImage);
    }

    public ImageProducer getSource() {
        throw new IllegalAccessError("getSource() not valid for CImage");
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError("getGraphics() not valid for CImage");
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        return Image.UndefinedProperty;
    }

    public void flush() {
    }

    private long makeNSImage(BufferedImage bufferedImage) {
        BufImgSurfaceData bufImgSurfaceData = (BufImgSurfaceData)BufImgSurfaceData.createData(bufferedImage);
        return bufImgSurfaceData.makeNSImage();
    }

    synchronized boolean isConvertedToBI() {
        return this.fConvertedBI != null;
    }

    synchronized Image getConvertedBI() {
        return this.fConvertedBI;
    }

    synchronized void convertToBI() {
        if (this.fConvertedBI != null) {
            return;
        }
        int n = this.width(this.fNSImage);
        int n2 = this.height(this.fNSImage);
        this.fConvertedBI = new BufferedImage(n, n2, 3);
        SunGraphics2D sunGraphics2D = (SunGraphics2D)this.fConvertedBI.createGraphics();
        this.flip(this.fNSImage);
        CSurfaceData cfr_ignored_0 = (CSurfaceData)sunGraphics2D.surfaceData;
        ((CSurfaceData)sunGraphics2D.surfaceData).blitNSImage(CSurfaceData.fCRenderer, sunGraphics2D, this.fNSImage, 0, 0, n, n2, 0, 0, n, n2, Color.black);
        this.flip(this.fNSImage);
    }

    synchronized SurfaceData getConvertedSurfaceData() {
        if (this.fSurfaceData == null) {
            this.fSurfaceData = BufImgSurfaceData.createData(this.fConvertedBI);
        }
        return this.fSurfaceData;
    }

    synchronized long getConvertedCGImageRef() {
        if (this.fConvertedCGImageRef == 0L) {
            int n = this.width(this.fNSImage);
            int n2 = this.height(this.fNSImage);
            SunGraphics2D sunGraphics2D = (SunGraphics2D)this.fConvertedBI.createGraphics();
            this.fConvertedCGImageRef = this.createCGImageRef(sunGraphics2D.surfaceData, n, n2);
            sunGraphics2D.dispose();
        }
        return this.fConvertedCGImageRef;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

