/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.EventQueue;
import charva.awt.ItemSelectable;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.AWTEvent;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.ItemEvent;
import charva.awt.event.ItemListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charva.awt.event.MouseEvent;
import charvax.swing.JComponent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
KeyListener {
    private String _label;
    private String _actionCommand;
    private int _mnemonic = 0;
    boolean _selected = false;
    protected Vector _actionListeners = null;
    protected Vector _itemListeners = null;

    public void setLabel(String label_) {
        this.setText(label_);
    }

    public void setText(String label_) {
        this._label = label_;
    }

    public void setMnemonic(int mnemonic_) {
        this._mnemonic = mnemonic_;
        Window ancestor = super.getAncestorWindow();
        if (ancestor != null) {
            ancestor.addKeyListener(this);
        }
    }

    public String getLabel() {
        return this.getText();
    }

    public String getText() {
        return this._label;
    }

    public int getMnemonic() {
        return this._mnemonic;
    }

    public void setActionCommand(String text_) {
        this._actionCommand = text_;
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getButton() == 1 && e.getModifiers() == 102 && this.isFocusTraversable()) {
            this.doClick();
        }
    }

    public void doClick() {
        this.getParent().setFocus(this);
        Toolkit.getDefaultToolkit().fireKeystroke(343, this);
    }

    public void setSelected(boolean state_) {
        if (this._selected != state_) {
            int statechange = state_ ? 100 : 101;
            ItemEvent evt = new ItemEvent(this, this, statechange);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(evt);
        }
        this._selected = state_;
        if (this.isDisplayed()) {
            super.repaint();
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    protected void processEvent(AWTEvent evt_) {
        super.processEvent(evt_);
        if (evt_ instanceof KeyEvent) {
            KeyEvent key_event = (KeyEvent)evt_;
            if (!key_event.isConsumed() && key_event.getKeyCode() == 343 && super.isEnabled()) {
                EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                queue.postEvent(new ActionEvent(this, this.getActionCommand()));
                key_event.consume();
            }
        } else if (evt_ instanceof ActionEvent) {
            this.fireActionPerformed((ActionEvent)evt_);
        } else if (evt_ instanceof ItemEvent) {
            this.fireItemStateChanged((ItemEvent)evt_);
        }
    }

    public void addActionListener(ActionListener al_) {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        this._actionListeners.add(al_);
    }

    protected void fireActionPerformed(ActionEvent ae_) {
        if (this._actionListeners != null) {
            Enumeration e = this._actionListeners.elements();
            while (e.hasMoreElements()) {
                ActionListener al = (ActionListener)e.nextElement();
                al.actionPerformed(ae_);
            }
        }
    }

    public void addItemListener(ItemListener il_) {
        if (this._itemListeners == null) {
            this._itemListeners = new Vector();
        }
        this._itemListeners.add(il_);
    }

    public void removeItemListener(ItemListener listener_) {
        if (this._itemListeners == null) {
            return;
        }
        this._itemListeners.remove(listener_);
    }

    public void keyPressed(KeyEvent ke_) {
        if (ke_.getKeyCode() == this.getMnemonic()) {
            this.doClick();
            ke_.consume();
        }
    }

    public void keyTyped(KeyEvent ke_) {
        char mnemonicLower;
        char keyLower = Character.toLowerCase(ke_.getKeyChar());
        if (keyLower == (mnemonicLower = Character.toLowerCase((char)this.getMnemonic()))) {
            this.doClick();
            ke_.consume();
        }
    }

    public void keyReleased(KeyEvent ke_) {
    }

    protected void fireItemStateChanged(ItemEvent ie_) {
        if (this._itemListeners != null) {
            Enumeration e = this._itemListeners.elements();
            while (e.hasMoreElements()) {
                ItemListener il = (ItemListener)e.nextElement();
                il.itemStateChanged(ie_);
            }
        }
    }

    protected String getLabelString() {
        String label = this.getText();
        if (this._mnemonic == 0) {
            return label;
        }
        if (this._mnemonic >= 32 && this._mnemonic < 255 && label.indexOf((char)this._mnemonic) != -1) {
            return label;
        }
        StringBuffer buf = new StringBuffer(label);
        if (this._mnemonic < 32) {
            char c = (char)(this._mnemonic + 64);
            return buf.append(" (^").append(c).append(")").toString();
        }
        if (this._mnemonic >= 265 && this._mnemonic <= 284) {
            int offset = this._mnemonic - 265 + 1;
            return buf.append(" (F").append(offset).append(")").toString();
        }
        return label;
    }
}

