/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.DataModel;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.LocaleUtils;
import org.openinstaller.util.NetUtils;
import org.openinstaller.util.OpenInstallerTemplateLoader;
import org.openinstaller.util.logging.LogUtils;

public final class TemplateProcessor {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final Configuration gConfig;
    private final DataModel gDataModel;
    @Deprecated
    private static TemplateProcessor gSingletonInstance;

    public TemplateProcessor(DataModel aDataModel) {
        ClassLoader theClassLoader = this.getClass().getClassLoader();
        if (theClassLoader instanceof URLClassLoader) {
            LOGGER.finest("CLASSPATH : " + System.getProperty("java.class.path"));
            LOGGER.finest("URLs : " + Arrays.toString(((URLClassLoader)theClassLoader).getURLs()));
        }
        this.gConfig = new Configuration();
        this.gConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.gConfig.setTemplateLoader((TemplateLoader)new OpenInstallerTemplateLoader());
        this.gDataModel = aDataModel;
    }

    @Deprecated
    public static TemplateProcessor getInstance() {
        return gSingletonInstance;
    }

    public String processTemplate(String aTemplateName) throws EnhancedException {
        LOGGER.fine("About to process template: [" + aTemplateName + "]");
        StringWriter theStringWriter = new StringWriter();
        try {
            Template theTemplate = this.gConfig.getTemplate(aTemplateName, "UTF-8");
            theTemplate.process((Object)this.gDataModel, (Writer)theStringWriter);
            String theString = theStringWriter.toString();
            while (theString.contains("${")) {
                theTemplate = new Template(aTemplateName, (Reader)new StringReader(theString), this.gConfig);
                theStringWriter = new StringWriter();
                theTemplate.process((Object)this.gDataModel, (Writer)theStringWriter);
                theString = theStringWriter.toString();
            }
        }
        catch (IOException theException) {
            throw new EnhancedException("ERROR_READING_TEMPLATE", (Throwable)theException, new String[0]);
        }
        catch (TemplateException theException) {
            throw new EnhancedException("ERROR_PROCESSING_TEMPLATE", (Throwable)theException, new String[0]);
        }
        return theStringWriter.toString();
    }

    public Object getFromDataModel(String aKey) {
        return this.gDataModel.get(aKey);
    }

    public TemplateProcessor putIntoDataModel(String aKey, Object aValue) throws EnhancedException {
        this.gDataModel.put(aKey, aValue);
        return this;
    }

    public TemplateProcessor removeFromDataModel(String aKey) {
        this.gDataModel.delete(aKey);
        return this;
    }

    public TemplateProcessor replaceInDataModel(String aKey, Object aValue) throws EnhancedException {
        if (this.getFromDataModel(aKey) != null) {
            this.removeFromDataModel(aKey);
        }
        this.putIntoDataModel(aKey, aValue);
        return this;
    }

    public TemplateProcessor clearModel() {
        this.gDataModel.clear();
        return this;
    }

    public TemplateProcessor loadModelFromResource(String aResource) {
        try {
            DataModel theAdditionalDataModel = new DataModel();
            this.loadPrefs(aResource, new URL(System.getProperty("installer.resources.url")), theAdditionalDataModel);
            this.loadPrefs(aResource, new URL(System.getProperty("default.resources.url")), this.gDataModel);
            for (String theKey : theAdditionalDataModel.keys()) {
                this.gDataModel.update(theKey, theAdditionalDataModel.get(theKey));
            }
        }
        catch (Exception theEx) {
            LogUtils.log(LOGGER, Level.WARNING, "CANNOT_LOAD_MODEL", theEx, "name=" + aResource, "locale=" + Locale.getDefault());
        }
        return this;
    }

    private void loadPrefs(String aResource, URL aOverrideLocation, DataModel aDataModel) {
        for (String theCandidate : LocaleUtils.getCandidateResourceNames(aResource, Locale.getDefault())) {
            try {
                if (theCandidate.startsWith("/")) {
                    theCandidate = theCandidate.substring(1);
                }
                LOGGER.finest("Looking for " + theCandidate);
                URL theURL = new URL(aOverrideLocation, theCandidate);
                if (NetUtils.existsURL(theURL)) {
                    LOGGER.finest("Found " + theURL + " for " + theCandidate);
                    try {
                        aDataModel.load(theURL);
                    }
                    catch (Exception theEx) {
                        LogUtils.log(LOGGER, Level.WARNING, "CANNOT_LOAD_MODEL", theEx, "name=" + aResource, "locale=" + Locale.getDefault());
                    }
                    break;
                }
                LOGGER.finest("Not found");
            }
            catch (MalformedURLException e) {
                LOGGER.finest(e.getMessage());
            }
        }
    }

    @Deprecated
    public void setSingletonInstance() throws RuntimeException {
        gSingletonInstance = this;
    }
}

