/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.util.menus.Directory;
import org.openinstaller.bindings.util.menus.Filename;
import org.openinstaller.bindings.util.menus.Include;
import org.openinstaller.bindings.util.menus.Menu;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

public class MenuEditor {
    private final File gMenuFile;
    private Menu gMenu;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final String MENU_SCHEMA_PACKAGE = "org.openinstaller.bindings.util.menus";

    public MenuEditor(File aMenuFile) {
        this.gMenuFile = aMenuFile;
    }

    private void unmarshalMenu() throws EnhancedException {
        try {
            JAXBContext theJAXBContext = JAXBContext.newInstance((String)MENU_SCHEMA_PACKAGE);
            Unmarshaller theUnmarshaller = theJAXBContext.createUnmarshaller();
            Object theMenuObject = theUnmarshaller.unmarshal(this.gMenuFile);
            LOGGER.log(Level.FINE, "Unmarshalling done");
            if (theMenuObject instanceof Menu) {
                this.gMenu = (Menu)theMenuObject;
            }
        }
        catch (JAXBException theException) {
            throw new EnhancedException("Error initializing JAXB", (Throwable)theException, new String[0]);
        }
    }

    private void marshalMenu() throws EnhancedException {
        try {
            JAXBContext theJAXBContext = JAXBContext.newInstance((String)MENU_SCHEMA_PACKAGE);
            Marshaller theMarshaller = theJAXBContext.createMarshaller();
            theMarshaller.marshal((Object)this.gMenu, (OutputStream)new FileOutputStream(this.gMenuFile));
            LOGGER.log(Level.FINE, "Marshalling done");
        }
        catch (FileNotFoundException theEx) {
            LOGGER.log(Level.WARNING, "INVALID_FILE", "file=" + this.gMenuFile.getAbsolutePath());
        }
        catch (JAXBException theException) {
            throw new EnhancedException("Error initializing JAXB", (Throwable)theException, new String[0]);
        }
    }

    public void addShortcutEntry(String[] aMenuNames, String[] aPaths, String aFileName) throws EnhancedException {
        this.unmarshalMenu();
        Menu theTopMenu = this.gMenu;
        for (int theIndex = 0; theIndex < aMenuNames.length; ++theIndex) {
            Menu theMenu = this.getSubMenuFromMenu(theTopMenu, aMenuNames[theIndex]);
            if (theMenu == null) {
                theMenu = new Menu();
                theMenu.setName(aMenuNames[theIndex]);
                Directory theDir = new Directory();
                theDir.setvalue(aPaths[theIndex]);
                theMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().add(theDir);
                theTopMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().add(theMenu);
                theTopMenu = theMenu;
                continue;
            }
            theTopMenu = theMenu;
        }
        Include theInclude = this.getIncludeFromMenu(theTopMenu, aFileName);
        if (theInclude == null) {
            theInclude = new Include();
            Filename theFilename = new Filename();
            theFilename.setvalue(aFileName);
            theInclude.getCategoryOrFilenameOrAndOrOrOrNotOrAll().add(theFilename);
            theTopMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().add(theInclude);
        }
        this.marshalMenu();
    }

    public void removeShortcutEntry(String aTopMenuName, String aSubMenuName, String aFileName) throws EnhancedException {
        this.unmarshalMenu();
        Menu theTopMenu = this.getSubMenuFromMenu(this.gMenu, aTopMenuName);
        Menu theSubMenu = this.getSubMenuFromMenu(theTopMenu, aSubMenuName);
        Include theInclude = this.getIncludeFromMenu(theSubMenu, aFileName);
        if (theInclude != null) {
            theSubMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().remove(theInclude);
        }
        boolean theSubMenuEmpty = true;
        for (Object theObj : theSubMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout()) {
            if (!(theObj instanceof Include)) continue;
            theSubMenuEmpty = false;
        }
        if (theSubMenuEmpty) {
            theTopMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().remove(theSubMenu);
        }
        boolean theTopMenuEmpty = true;
        for (Object theObj : theTopMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout()) {
            if (!(theObj instanceof Menu)) continue;
            theTopMenuEmpty = false;
        }
        if (theTopMenuEmpty) {
            this.gMenuFile.delete();
        } else {
            this.marshalMenu();
        }
    }

    public void createNewMenuFile(String[] aMenuNames, String[] aPaths) throws EnhancedException {
        int theIndex;
        this.gMenu = new Menu();
        this.gMenu.setName("Applications");
        int theCount = aMenuNames.length;
        Menu[] theMenus = new Menu[theCount];
        for (theIndex = 0; theIndex < theCount; ++theIndex) {
            theMenus[theIndex] = new Menu();
            Directory theMenuDir = new Directory();
            theMenus[theIndex].setName(aMenuNames[theIndex]);
            theMenuDir.setvalue(aPaths[theIndex]);
            theMenus[theIndex].getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().add(theMenuDir);
        }
        for (theIndex = 0; theIndex < theCount - 1; ++theIndex) {
            theMenus[theIndex].getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().add(theMenus[theIndex + 1]);
        }
        this.gMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout().add(theMenus[0]);
        this.marshalMenu();
        LOGGER.log(Level.FINEST, "New menu file created.");
    }

    private Menu getSubMenuFromMenu(Menu aMenu, String aSubMenuName) {
        Menu theReturnMenu = null;
        for (Object theObj : aMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout()) {
            Menu theTempMenu;
            if (!(theObj instanceof Menu) || !aSubMenuName.equalsIgnoreCase((theTempMenu = (Menu)theObj).getName())) continue;
            theReturnMenu = theTempMenu;
            break;
        }
        return theReturnMenu;
    }

    private Include getIncludeFromMenu(Menu aMenu, String aFilename) {
        Include theRetInclude = null;
        for (Object theObj : aMenu.getDirectoryOrDefaultAppDirsOrAppDirOrDefaultDirectoryDirsOrDirectoryDirOrLegacyDirOrKDELegacyDirsOrMergeFileOrDefaultMergeDirsOrMergeDirOrOnlyUnallocatedOrNotOnlyUnallocatedOrDeletedOrNotDeletedOrIncludeOrExcludeOrMoveOrMenuOrLayoutOrDefaultLayout()) {
            if (!(theObj instanceof Include)) continue;
            Include theTempInclude = (Include)theObj;
            for (Object theInnerObj : theTempInclude.getCategoryOrFilenameOrAndOrOrOrNotOrAll()) {
                Filename theTempFilename;
                if (!(theInnerObj instanceof Filename) || !aFilename.equalsIgnoreCase((theTempFilename = (Filename)theInnerObj).getvalue())) continue;
                theRetInclude = theTempInclude;
            }
        }
        return theRetInclude;
    }
}

