/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf.apoc;

import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.openinstaller.provider.conf.apoc.APOCConstraints;
import org.openinstaller.provider.conf.apoc.APOCPropValue;
import org.openinstaller.provider.conf.apoc.APOCScope;
import org.openinstaller.provider.conf.apoc.APOCScriptHandler;
import org.openinstaller.provider.conf.apoc.APOCType;
import org.openinstaller.provider.conf.apoc.APOCVisual;
import org.openinstaller.provider.conf.apoc.APOCVisualMediaType;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APOCProperty {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private final String gName;
    private String gScope;
    private final String gLabel;
    private String gInlineHelp;
    private final String gDataPath;
    private final APOCType gApocType;
    private String gStoreDefault;
    private Object gXmlHandler;
    private final List<APOCConstraints> gConstraints;
    private List<APOCPropValue> gPropValues;
    private final APOCVisual gVisual;
    private APOCVisualMediaType gVisualMediaType;
    private APOCScriptHandler gScriptHandler;

    public APOCProperty(String aName, String aLabel, String aDataPath, APOCType aApocType, APOCVisual aVisual) {
        this.gName = aName;
        this.gLabel = aLabel;
        this.gDataPath = aDataPath;
        this.gApocType = aApocType;
        this.gVisual = aVisual;
        this.gConstraints = new Vector<APOCConstraints>();
        this.gPropValues = new Vector<APOCPropValue>();
    }

    public String getName() {
        return this.gName;
    }

    public String getScope() {
        return this.gScope;
    }

    public APOCProperty setScope(String aScope) throws EnhancedException {
        APOCScope theAPOCScope = APOCScope.getScopeForString(aScope);
        this.gScope = theAPOCScope != null ? theAPOCScope.getScopeSpecifier() : null;
        return this;
    }

    public String getLabel() {
        return this.gLabel;
    }

    public String getInlineHelp() {
        return this.gInlineHelp;
    }

    public APOCProperty setInlineHelp(String aInlineHelp) {
        this.gInlineHelp = aInlineHelp;
        return this;
    }

    public String getDataPath() {
        return this.gDataPath;
    }

    public APOCType getApocType() {
        return this.gApocType;
    }

    public String getStoreDefault() {
        return this.gStoreDefault;
    }

    public APOCProperty setStoreDefault(String aStoreDefault) {
        this.gStoreDefault = aStoreDefault;
        return this;
    }

    public List<APOCPropValue> getPropValues() {
        return this.gPropValues;
    }

    public APOCConstraints setPropValue(APOCPropValue aValue) {
        if (aValue.getSeparator() == null) {
            for (APOCConstraints theConstraint : this.getConstraints()) {
                if (theConstraint.isValid(aValue.getValue())) continue;
                return theConstraint;
            }
        } else if (aValue.getSeparator() != null) {
            String theTempValue = aValue.getValue();
            String theTempSep = aValue.getSeparator();
            StringTokenizer st = new StringTokenizer(theTempValue, theTempSep);
            while (st.hasMoreElements()) {
                Object tempElement = st.nextElement();
                for (APOCConstraints theConstraint : this.getConstraints()) {
                    if (theConstraint.isValid(tempElement)) continue;
                    return theConstraint;
                }
            }
        }
        this.gPropValues.add(aValue);
        return null;
    }

    public Object getXmlHandler() {
        return this.gXmlHandler;
    }

    public APOCProperty setXmlHandler(Object aXmlHandler) {
        this.gXmlHandler = aXmlHandler;
        return this;
    }

    public List<APOCConstraints> getConstraints() {
        return this.gConstraints;
    }

    public APOCProperty addConstraint(APOCConstraints aConstraints) {
        this.gConstraints.add(aConstraints);
        return this;
    }

    public APOCVisual getVisual() {
        return this.gVisual;
    }

    public APOCProperty setVisualMediaType(APOCVisualMediaType aVisualMediaType) {
        this.gVisualMediaType = aVisualMediaType;
        return this;
    }

    public APOCVisualMediaType getVisualMediaType() {
        return this.gVisualMediaType;
    }

    public APOCScriptHandler getScriptHandler() {
        return this.gScriptHandler;
    }

    public APOCProperty setScriptHandler(APOCScriptHandler aScriptHandler) {
        this.gScriptHandler = aScriptHandler;
        return this;
    }

    public String toString() {
        return "org.openinstaller.provider.conf.apoc.APOCProperty{gName='" + this.gName + '\'' + ", gScope='" + this.gScope + '\'' + ", gLabel='" + this.gLabel + '\'' + ", gInlineHelp='" + this.gInlineHelp + '\'' + ", gDataPath='" + this.gDataPath + '\'' + ", gApocType=" + (Object)((Object)this.gApocType) + ", gStoreDefault='" + this.gStoreDefault + '\'' + ", gXmlHandler=" + this.gXmlHandler + ", gConstraints=" + this.gConstraints + ", gPropValues=" + this.gPropValues + ", gVisual=" + this.gVisual + ", gVisualMediaType=" + this.gVisualMediaType + ", gScriptHandler=" + this.gScriptHandler + '}';
    }
}

