/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.provider.conf.ConfigControl;
import org.openinstaller.provider.conf.ResultReport;
import org.openinstaller.provider.task.Task;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.InvalidArgumentException;

public class ConfigTask
extends Task {
    private String gComponentName;
    private ResultReport gResultReport;
    private Throwable gException;
    private static Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    boolean perform(ProgressListener aListener) {
        ConfigControl theConfigCtrl = new ConfigControl(ConfigControl.ConfigCommand.CONFIGURE_COMPONENT, this.gComponentName);
        try {
            BusResponse theConfigResp = ControlBus.getInstance().publishRequest(new BusRequest("Configure Product request", (Object)theConfigCtrl), "svc://general/conf");
            this.setConfigReport((ResultReport)theConfigResp.getResult());
            this.gException = theConfigResp.getException();
        }
        catch (InvalidArgumentException theEIAEx) {
            LOGGER.log(Level.SEVERE, "BUS_REQUEST_FAILED", theEIAEx);
            this.gException = theEIAEx;
            return false;
        }
        catch (NoSuchMemberException theNSMEx) {
            LOGGER.log(Level.SEVERE, "CANNOT_PERFORM_CONFIGURE_TASK", theNSMEx);
            this.gException = theNSMEx;
            return false;
        }
        return true;
    }

    public void setConfigReport(ResultReport aResultReport) {
        this.gResultReport = aResultReport;
    }

    public ResultReport getConfigReport() {
        return this.gResultReport;
    }

    public ConfigTask(String aComponentName) {
        this.gComponentName = aComponentName;
    }

    public Throwable getException() {
        return this.gException;
    }
}

