/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.GetClusterHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ClusterUtil;
import com.sun.messaging.jms.management.server.BrokerNotification;
import com.sun.messaging.jms.management.server.BrokerState;
import com.sun.messaging.jms.management.server.ClusterNotification;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class ClusterMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getBrokerInfoByAddrSignature;
    private static MBeanParameterInfo[] getBrokerInfoByIdSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] clsNotificationTypes;
    private static String[] brokerNotificationTypes;
    private static MBeanNotificationInfo[] notifs;
    private static final String[] brokerInfoItemNames;
    private static final String[] brokerInfoItemDesc;
    private static final OpenType[] itemTypes;
    private CompositeType compType = null;

    public String getConfigFileURL() {
        Properties properties = Globals.getConfig().toProperties();
        return properties.getProperty("imq.cluster.url");
    }

    public String getClusterID() {
        return Globals.getClusterID();
    }

    public Boolean isHighlyAvailable() {
        return this.getHighlyAvailable();
    }

    public Boolean getHighlyAvailable() {
        return Globals.getHAEnabled();
    }

    public CompositeData getLocalBrokerInfo() throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        MQAddress mQAddress = clusterManager.getMQAddress();
        String string = null;
        try {
            string = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(mQAddress.toString()));
        }
        catch (Exception exception) {
            this.handleGetterException("LocalBrokerInfo", exception);
        }
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = this.getCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleGetterException("LocalBrokerInfo", exception);
        }
        return compositeData;
    }

    public String getMasterBroker() {
        Properties properties = Globals.getConfig().toProperties();
        return properties.getProperty("imq.cluster.masterbroker");
    }

    public CompositeData getMasterBrokerInfo() throws MBeanException {
        if (Globals.getHAEnabled()) {
            return null;
        }
        String string = this.getMasterBroker();
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(string));
        }
        catch (Exception exception) {
            this.handleGetterException("MasterBrokerInfo", exception);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string2);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = this.getCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleGetterException("MasterBrokerInfo", exception);
        }
        return compositeData;
    }

    public String[] getBrokerAddresses() {
        return this.getBrokerIDsOrAddresses(false);
    }

    public String[] getBrokerIDs() {
        if (!Globals.getHAEnabled()) {
            return null;
        }
        return this.getBrokerIDsOrAddresses(true);
    }

    private String[] getBrokerIDsOrAddresses(boolean bl) {
        ClusterManager clusterManager = Globals.getClusterManager();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        if (clusterManager == null) {
            return null;
        }
        Iterator iterator = clusterManager.getKnownBrokers(true);
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
            Hashtable hashtable = GetClusterHandler.getBrokerClusterInfo(clusteredBroker, this.logger);
            if (hashtable == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            String string = bl ? (String)hashtable.get("ID") : (String)hashtable.get("Address");
            if (string == null) {
                this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while constructing list of broker IDs or addresses, continuing...");
                continue;
            }
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public CompositeData[] getBrokerInfo() throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData[] compositeDataArray = null;
        ArrayList<CompositeData> arrayList = new ArrayList<CompositeData>();
        if (clusterManager == null) {
            return null;
        }
        Iterator iterator = clusterManager.getKnownBrokers(true);
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ClusteredBroker clusteredBroker = (ClusteredBroker)iterator.next();
            try {
                CompositeData compositeData = this.getCompositeData(clusteredBroker);
                arrayList.add(compositeData);
            }
            catch (Exception exception) {
                this.handleOperationException("getBrokerInfo", exception);
            }
        }
        compositeDataArray = new CompositeData[arrayList.size()];
        compositeDataArray = arrayList.toArray(compositeDataArray);
        return compositeDataArray;
    }

    public CompositeData getBrokerInfoByAddress(String string) throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (clusterManager == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = clusterManager.lookupBrokerID(BrokerMQAddress.createAddress(string));
        }
        catch (Exception exception) {
            this.handleOperationException("getBrokerInfoByAddress", exception);
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        try {
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string2);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = this.getCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleOperationException("getBrokerInfoByAddress", exception);
        }
        return compositeData;
    }

    public CompositeData getBrokerInfoByID(String string) throws MBeanException {
        ClusterManager clusterManager = Globals.getClusterManager();
        CompositeData compositeData = null;
        if (!Globals.getHAEnabled()) {
            return null;
        }
        try {
            if (clusterManager == null) {
                return null;
            }
            ClusteredBroker clusteredBroker = clusterManager.getBroker(string);
            if (clusteredBroker == null) {
                return null;
            }
            compositeData = this.getCompositeData(clusteredBroker);
        }
        catch (Exception exception) {
            this.handleOperationException("getBrokerInfoByID", exception);
        }
        return compositeData;
    }

    private CompositeData getCompositeData(ClusteredBroker clusteredBroker) throws OpenDataException {
        CompositeDataSupport compositeDataSupport = null;
        Hashtable hashtable = GetClusterHandler.getBrokerClusterInfo(clusteredBroker, this.logger);
        String string = null;
        if (Globals.getHAEnabled()) {
            string = (String)hashtable.get("ID");
        }
        Object[] objectArray = new Object[]{hashtable.get("Address"), string, hashtable.get("State"), BrokerState.toString((Integer)hashtable.get("State")), hashtable.get("NumMsgs"), hashtable.get("TakeoverBrokerID"), hashtable.get("StatusTimestamp")};
        if (this.compType == null) {
            this.compType = new CompositeType("BrokerClusterInfo", "BrokerClusterInfo", brokerInfoItemNames, brokerInfoItemDesc, itemTypes);
        }
        compositeDataSupport = new CompositeDataSupport(this.compType, brokerInfoItemNames, objectArray);
        return compositeDataSupport;
    }

    public String getMBeanName() {
        return "ClusterMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1020");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyTakeoverStart(String string) {
        BrokerNotification brokerNotification = new BrokerNotification("mq.broker.takeover.start", this, this.sequenceNumber++);
        brokerNotification.setFailedBrokerID(string);
        try {
            CompositeData compositeData = this.getLocalBrokerInfo();
            brokerNotification.setBrokerAddress((String)compositeData.get("Address"));
            brokerNotification.setBrokerID((String)compositeData.get("ID"));
        }
        catch (MBeanException mBeanException) {
            this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while sending notification " + "mq.broker.takeover.start");
        }
        this.sendNotification(brokerNotification);
    }

    public void notifyTakeoverComplete(String string) {
        BrokerNotification brokerNotification = new BrokerNotification("mq.broker.takeover.complete", this, this.sequenceNumber++);
        brokerNotification.setFailedBrokerID(string);
        try {
            CompositeData compositeData = this.getLocalBrokerInfo();
            brokerNotification.setBrokerAddress((String)compositeData.get("Address"));
            brokerNotification.setBrokerID((String)compositeData.get("ID"));
        }
        catch (MBeanException mBeanException) {
            this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while sending notification " + "mq.broker.takeover.complete");
        }
        this.sendNotification(brokerNotification);
    }

    public void notifyTakeoverFail(String string) {
        BrokerNotification brokerNotification = new BrokerNotification("mq.broker.takeover.fail", this, this.sequenceNumber++);
        brokerNotification.setFailedBrokerID(string);
        try {
            CompositeData compositeData = this.getLocalBrokerInfo();
            brokerNotification.setBrokerAddress((String)compositeData.get("Address"));
            brokerNotification.setBrokerID((String)compositeData.get("ID"));
        }
        catch (MBeanException mBeanException) {
            this.logger.log(16, "MBean: " + this.getMBeanName() + "Problem encountered while sending notification " + "mq.broker.takeover.fail");
        }
        this.sendNotification(brokerNotification);
    }

    public void notifyClusterBrokerDown(String string) {
        ClusterNotification clusterNotification = new ClusterNotification("mq.cluster.broker.down", this, this.sequenceNumber++);
        clusterNotification.setBrokerAddress(ClusterUtil.getShortBrokerAddress(string));
        clusterNotification.setHighlyAvailable(Globals.getHAEnabled());
        if (clusterNotification.isHighlyAvailable()) {
            clusterNotification.setClusterID(Globals.getClusterID());
            clusterNotification.setBrokerID(string);
        } else {
            clusterNotification.setMasterBroker(ClusterUtil.isMasterBroker(clusterNotification.getBrokerAddress()));
        }
        this.sendNotification(clusterNotification);
    }

    public void notifyClusterBrokerJoin(String string) {
        ClusterNotification clusterNotification = new ClusterNotification("mq.cluster.broker.join", this, this.sequenceNumber++);
        clusterNotification.setBrokerAddress(ClusterUtil.getShortBrokerAddress(string));
        clusterNotification.setHighlyAvailable(Globals.getHAEnabled());
        if (clusterNotification.isHighlyAvailable()) {
            clusterNotification.setClusterID(Globals.getClusterID());
            clusterNotification.setBrokerID(string);
        } else {
            clusterNotification.setMasterBroker(ClusterUtil.isMasterBroker(clusterNotification.getBrokerAddress()));
        }
        this.sendNotification(clusterNotification);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ConfigFileURL", String.class.getName(), mbr.getString("MB1002"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("ClusterID", String.class.getName(), mbr.getString("MB1003"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("HighlyAvailable", Boolean.class.getName(), mbr.getString("MB1004"), true, false, true);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("LocalBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1005"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("MasterBrokerInfo", CompositeData.class.getName(), mbr.getString("MB1006"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("BrokerAddress", String.class.getName(), mbr.getString("MB1011"));
        getBrokerInfoByAddrSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("BrokerID", String.class.getName(), mbr.getString("MB1013"));
        getBrokerInfoByIdSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getBrokerAddresses", mbr.getString("MB1021"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBrokerIDs", mbr.getString("MB1022"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getBrokerInfo", mbr.getString("MB1023"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getBrokerInfoByAddress", mbr.getString("MB1010"), getBrokerInfoByAddrSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getBrokerInfoByID", mbr.getString("MB1012"), getBrokerInfoByIdSignature, CompositeData.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        clsNotificationTypes = new String[]{"mq.cluster.broker.down", "mq.cluster.broker.join"};
        brokerNotificationTypes = new String[]{"mq.broker.takeover.complete", "mq.broker.takeover.fail", "mq.broker.takeover.start"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[2];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(brokerNotificationTypes, BrokerNotification.class.getName(), mbr.getString("MB1026"));
        mBeanNotificationInfoArray[1] = new MBeanNotificationInfo(clsNotificationTypes, ClusterNotification.class.getName(), mbr.getString("MB1024"));
        notifs = mBeanNotificationInfoArray;
        brokerInfoItemNames = new String[]{"Address", "ID", "State", "StateLabel", "NumMsgs", "TakeoverBrokerID", "StatusTimestamp"};
        brokerInfoItemDesc = brokerInfoItemNames;
        itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.LONG};
    }
}

