/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MessageInfo {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private Packet msg;
    private SysMessageID mid;
    private int packetSize;
    private DstMsgStore parent = null;
    private HashMap iidMap = null;
    private int[] statearray = null;

    MessageInfo(DstMsgStore dstMsgStore, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        this.parent = dstMsgStore;
        this.mid = (SysMessageID)packet.getSysMessageID().clone();
        this.packetSize = packet.getPacketSize();
        int n = consumerUIDArray.length;
        this.iidMap = new HashMap();
        this.statearray = new int[consumerUIDArray.length];
        this.storeStates(consumerUIDArray, nArray);
    }

    synchronized Packet getMessage() throws IOException {
        return this.msg;
    }

    int getSize() {
        return this.packetSize;
    }

    SysMessageID getID() {
        return this.mid;
    }

    synchronized void storeStates(ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        if (this.iidMap.size() != 0) {
            this.logger.log(16, "B3084", this.mid.toString());
            throw new BrokerException(this.br.getString("B3084", this.mid.toString()));
        }
        int n = consumerUIDArray.length;
        this.iidMap = new HashMap(n);
        this.statearray = new int[n];
        for (int i = 0; i < n; ++i) {
            this.iidMap.put(consumerUIDArray[i], new Integer(i));
            this.statearray[i] = nArray[i];
        }
    }

    synchronized void updateState(ConsumerUID consumerUID, int n) throws IOException, BrokerException {
        Integer n2 = null;
        if (this.iidMap == null || (n2 = (Integer)this.iidMap.get(consumerUID)) == null) {
            this.logger.log(32, "B3014", (Object)consumerUID.toString(), this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", consumerUID.toString(), this.mid.toString()));
        }
        int n3 = n2;
        if (this.statearray[n3] != n) {
            this.statearray[n3] = n;
        }
    }

    synchronized int getInterestState(ConsumerUID consumerUID) throws BrokerException {
        Integer n = null;
        if (this.iidMap == null || (n = (Integer)this.iidMap.get(consumerUID)) == null) {
            this.logger.log(32, "B3014", (Object)consumerUID.toString(), this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", consumerUID.toString(), this.mid.toString()));
        }
        return this.statearray[n];
    }

    synchronized HashMap getInterestStates() {
        HashMap hashMap = new HashMap();
        if (this.iidMap != null) {
            Set set = this.iidMap.entrySet();
            for (Map.Entry entry : set) {
                int n = (Integer)entry.getValue();
                hashMap.put(entry.getKey(), this.statearray[n]);
            }
        }
        return hashMap;
    }

    synchronized ConsumerUID[] getConsumerUIDs() {
        ConsumerUID[] consumerUIDArray = new ConsumerUID[]{};
        if (this.iidMap != null) {
            ArrayList arrayList = new ArrayList();
            Set set = this.iidMap.entrySet();
            for (Map.Entry entry : set) {
                Integer n = (Integer)entry.getValue();
                if (this.statearray[n] == 2) continue;
                arrayList.add(entry.getKey());
            }
            consumerUIDArray = arrayList.toArray(consumerUIDArray);
        }
        return consumerUIDArray;
    }

    synchronized boolean hasMessageBeenAck() {
        if (this.statearray != null && this.statearray.length > 0) {
            int n = this.statearray.length;
            for (int i = 0; i < n; ++i) {
                if (this.statearray[i] == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

