/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.tools.ant;

import com.sun.pkg.tools.ant.PythonEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Makepkgs
extends Task {
    private FileSet gFileSet = null;
    private List<String> gPrototype = new ArrayList<String>();
    private List<String> gArguments = new ArrayList<String>();
    private String gRepourl;
    private String gManifestFile = null;
    private OsTarget gOsTarget = null;
    private Env gEnv = null;

    public void setPrototype(String aPrototype) {
        this.gPrototype.add(aPrototype);
    }

    public void setRepourl(String aRepourl) {
        this.gRepourl = aRepourl;
        this.gArguments.add("-s");
        this.gArguments.add(aRepourl);
    }

    public void setDestfile(String aDestfile) {
        this.gArguments.add("-t");
        this.gArguments.add(aDestfile);
    }

    public void setBasedir(String aBasedir) {
        this.gArguments.add("-b");
        this.gArguments.add(aBasedir);
    }

    public void setManifestbase(String aManifestbase) {
        this.gArguments.add("--manifest-base");
        this.gArguments.add(aManifestbase);
    }

    public void setManifestfile(String aManifestFile) {
        this.gManifestFile = aManifestFile;
        this.gArguments.add("--manifest-file");
        this.gArguments.add(aManifestFile);
    }

    public void setManifestfmri(String aFmri) {
        this.gArguments.add("--manifest-fmri");
        this.gArguments.add(aFmri);
    }

    public void setVersion(String aVersion) {
        this.gArguments.add("-v");
        this.gArguments.add(aVersion);
    }

    public void addFileset(FileSet aFileSet) {
        if (this.gPrototype.size() != 0) {
            throw new BuildException("Use either prototype or fileset to specify the prototype files.");
        }
        if (this.gFileSet != null) {
            throw new BuildException("Only one fileset element is allowed.");
        }
        this.gFileSet = aFileSet;
    }

    public OsTarget createOsTarget() {
        if (this.gOsTarget != null) {
            throw new BuildException("Only one ostarget element is allowed.");
        }
        this.gOsTarget = new OsTarget();
        return this.gOsTarget;
    }

    public Env createEnv() {
        if (this.gEnv != null) {
            throw new BuildException("Only one env element is allowed.");
        }
        this.gEnv = new Env();
        return this.gEnv;
    }

    public void execute() throws BuildException {
        Project theCurrentAntProject = this.getProject();
        if (this.gOsTarget != null) {
            for (String theOs : this.gOsTarget.getOs()) {
                this.gArguments.add("-o");
                this.gArguments.add(theOs);
            }
        }
        if (this.gEnv != null) {
            for (String theVar : this.gEnv.getEnv()) {
                this.gArguments.add("-D");
                this.gArguments.add(theVar);
            }
        }
        if (this.gFileSet != null) {
            String[] theIncludedFiles;
            DirectoryScanner theDS = this.gFileSet.getDirectoryScanner(theCurrentAntProject);
            for (String theIncludedFile : theIncludedFiles = theDS.getIncludedFiles()) {
                String theFilename = theIncludedFile.replace('\\', '/');
                theFilename = theFilename.substring(theFilename.lastIndexOf("/") + 1);
                File theFoundFile = new File(theDS.getBasedir(), theIncludedFile);
                this.gPrototype.add(theFoundFile.getAbsolutePath());
            }
        }
        this.gArguments.addAll(this.gPrototype);
        if (this.gFileSet == null && this.gManifestFile == null) {
            throw new BuildException("Either one of prototype file or manifest file must be specified.");
        }
        String theOutput = null;
        try {
            String thePythonHome = theCurrentAntProject.getProperty("pkg.python.home");
            String thePkgBasedir = theCurrentAntProject.getProperty("pkg.basedir");
            String thePythonCmd = PythonEnvironment.PYTHONCMD.getValue(thePythonHome, thePkgBasedir);
            this.gArguments.add(0, thePkgBasedir + "/../bin/makepkgs.py");
            this.gArguments.add(0, thePythonCmd);
            ProcessBuilder theProcBuilder = new ProcessBuilder(new String[0]);
            theProcBuilder.command(this.gArguments);
            Map<String, String> theEnv = theProcBuilder.environment();
            theEnv.remove("PYTHONPATH");
            theEnv.put("LD_LIBRARY_PATH", PythonEnvironment.LD_LIBRARY_PATH.getValue(thePythonHome, thePkgBasedir));
            theEnv.put("DYLD_LIBRARY_PATH", PythonEnvironment.DYLD_LIBRARY_PATH.getValue(thePythonHome, thePkgBasedir));
            theProcBuilder.redirectErrorStream(true);
            Process theProcess = theProcBuilder.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
            while ((theOutput = stdInput.readLine()) != null) {
                System.out.println(theOutput);
            }
            theProcess.waitFor();
            SearchFileFilter theFilter = new SearchFileFilter();
            File theRepoFile = new File(this.gRepourl.replace("file://", ""));
            if (theRepoFile.isDirectory()) {
                for (File theFile : theRepoFile.listFiles(theFilter)) {
                    if (!theFile.isFile()) continue;
                    theFile.delete();
                }
            }
            if (theProcess.exitValue() != 0) {
                throw new BuildException("makepkgs.py failed, error code = " + theProcess.exitValue());
            }
        }
        catch (IOException theIOE) {
            theIOE.printStackTrace();
            throw new BuildException("makepkgs failed", (Throwable)theIOE);
        }
        catch (Exception theEx) {
            theEx.printStackTrace();
            throw new BuildException("makepkgs failed", (Throwable)theEx);
        }
    }

    class SearchFileFilter
    implements FilenameFilter {
        SearchFileFilter() {
        }

        public boolean accept(File aDir, String aName) {
            return aName.startsWith("search");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Env {
        private List<Var> gEnv = new ArrayList<Var>();

        public Var createVar() {
            Var theVarObject = new Var();
            this.gEnv.add(theVarObject);
            return theVarObject;
        }

        public List<String> getEnv() {
            ArrayList<String> theVarList = new ArrayList<String>();
            for (Var theVar : this.gEnv) {
                theVarList.add(theVar.getName() + "=" + theVar.getValue());
            }
            return theVarList;
        }

        public class Var {
            private String gName;
            private String gValue;

            public void setName(String aName) {
                this.gName = aName;
            }

            public String getName() {
                return this.gName;
            }

            public void setValue(String aValue) {
                this.gValue = aValue;
            }

            public String getValue() {
                return this.gValue;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OsTarget {
        private List<Os> gOs = new ArrayList<Os>();

        public Os createOs() {
            Os theOsObject = new Os();
            this.gOs.add(theOsObject);
            return theOsObject;
        }

        public List<String> getOs() {
            ArrayList<String> theOsList = new ArrayList<String>();
            for (Os theOs : this.gOs) {
                theOsList.add(theOs.getName());
            }
            return theOsList;
        }

        public class Os {
            private String gName;

            public void setName(String aName) {
                this.gName = aName;
            }

            public String getName() {
                return this.gName;
            }
        }
    }
}

