/*
 * Decompiled with CFR 0.152.
 */
package org.chaxml;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Frame;
import charva.awt.Window;
import charva.awt.event.ActionListener;
import charva.awt.event.WindowAdapter;
import charva.awt.event.WindowEvent;
import charva.awt.event.WindowListener;
import charvax.swing.AbstractButton;
import charvax.swing.JDialog;
import charvax.swing.JFrame;
import charvax.swing.JMenu;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.chaxml.Localizer;
import org.chaxml.Parser;
import org.chaxml.SwingTagLibrary;
import org.chaxml.TagLibrary;
import org.jdom.Document;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXParseException;

public class SwingEngine {
    public static final String MAC_OSX_OS_NAME = "mac os x";
    public static final String MAC_OSX_LOCALE_VARIANT = "mac";
    public static final boolean DEBUG_MODE = false;
    private static final String XML_ERROR_MSG = "Invalid SwiXML Descriptor.";
    private static final String IO_ERROR_MSG = "Resource could not be found ";
    private static final String MAPPING_ERROR_MSG = " could not be mapped to any Object and remained un-initialized.";
    private static Frame appFrame;
    private static String default_resource_bundle_name;
    private static Locale default_locale;
    private static boolean MAC_OSX;
    private static boolean MAC_OSX_SUPPORTED;
    private Parser parser = new Parser(this);
    private Object client;
    private Container root;
    private Map idmap = new HashMap();
    private Collection components = null;
    private Localizer localizer = new Localizer();
    private final TagLibrary taglib = SwingTagLibrary.getInstance();
    protected ClassLoader cl = this.getClass().getClassLoader();

    public SwingEngine() {
        this.client = this;
        this.setLocale(default_locale);
        this.getLocalizer().setResourceBundle(default_resource_bundle_name);
        try {
            if (SwingEngine.isMacOSXSupported() && SwingEngine.isMacOSX()) {
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.showGrowBox", "true");
                System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public SwingEngine(Object client) {
        this();
        this.client = client;
    }

    public SwingEngine(String resource) {
        this(SwingEngine.class.getClassLoader(), resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingEngine(ClassLoader cl, String resource) {
        this();
        this.setClassLoader(cl);
        Reader reader = null;
        try {
            InputStream in = cl.getResourceAsStream(resource);
            if (in == null) {
                throw new IOException(IO_ERROR_MSG + resource);
            }
            reader = new InputStreamReader(in);
            this.render(reader);
        }
        catch (Exception e) {
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container render(URL url) throws Exception {
        Reader reader = null;
        Container obj = null;
        try {
            InputStream in = url.openStream();
            if (in == null) {
                throw new IOException(IO_ERROR_MSG + url.toString());
            }
            reader = new InputStreamReader(in);
            obj = this.render(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {}
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container render(String resource) throws Exception {
        Reader reader = null;
        Container obj = null;
        try {
            InputStream in = this.cl.getResourceAsStream(resource);
            if (in == null) {
                throw new IOException(IO_ERROR_MSG + resource);
            }
            reader = new InputStreamReader(in);
            obj = this.render(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {}
        }
        return obj;
    }

    public Container render(File xml_file) throws Exception {
        if (xml_file == null) {
            throw new IOException();
        }
        return this.render(new FileReader(xml_file));
    }

    public Container render(Reader xml_reader) throws Exception {
        if (xml_reader == null) {
            throw new IOException();
        }
        try {
            return this.render(new SAXBuilder().build(xml_reader));
        }
        catch (SAXParseException e) {
            System.err.println(e);
        }
        catch (JDOMParseException e) {
            System.err.println((Object)e);
        }
        throw new Exception(XML_ERROR_MSG);
    }

    public Container render(Document jdoc) throws Exception {
        this.idmap.clear();
        this.root = (Container)this.parser.parse(jdoc);
        this.components = null;
        this.mapMembers(this.client);
        if (Frame.class.isAssignableFrom(this.root.getClass())) {
            SwingEngine.setAppFrame((Frame)this.root);
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(URL url, Container container) throws Exception {
        Reader reader = null;
        try {
            InputStream in = url.openStream();
            if (in == null) {
                throw new IOException(IO_ERROR_MSG + url.toString());
            }
            reader = new InputStreamReader(in);
            this.insert(reader, container);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {}
        }
    }

    public void insert(Reader reader, Container container) throws Exception {
        if (reader == null) {
            throw new IOException();
        }
        this.insert(new SAXBuilder().build(reader), container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String resource, Container container) throws Exception {
        Reader reader = null;
        try {
            InputStream in = this.cl.getResourceAsStream(resource);
            if (in == null) {
                throw new IOException(IO_ERROR_MSG + resource);
            }
            reader = new InputStreamReader(in);
            this.insert(reader, container);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception ex) {}
        }
    }

    public void insert(Document jdoc, Container container) throws Exception {
        this.root = container;
        this.parser.parse(jdoc, container);
        this.components = null;
        this.mapMembers(this.client);
    }

    public static void setResourceBundleName(String bundlename) {
        default_resource_bundle_name = bundlename;
    }

    public static void setDefaultLocale(Locale locale) {
        default_locale = locale;
    }

    public static void setAppFrame(Frame frame) {
        if (frame != null && appFrame == null) {
            appFrame = frame;
        }
    }

    public static Frame getAppFrame() {
        return appFrame;
    }

    public Object getClient() {
        return this.client;
    }

    public Container getRootComponent() {
        return this.root;
    }

    public Iterator getAllComponentItertor() {
        if (this.components == null) {
            this.components = new ArrayList();
            SwingEngine.traverse((Component)this.root, this.components);
        }
        return this.components.iterator();
    }

    public Iterator getIdComponentItertor() {
        return this.idmap.values().iterator();
    }

    public Map getIdMap() {
        return this.idmap;
    }

    public int cleanup() {
        ArrayList zombies = new ArrayList();
        Iterator it = this.idmap.keySet().iterator();
        while (it != null && it.hasNext()) {
            Object key = it.next();
            Object obj = this.idmap.get(key);
            if (!(obj instanceof Component) || ((Component)obj).isDisplayed()) continue;
            zombies.add(key);
        }
        for (int i = 0; i < zombies.size(); ++i) {
            this.idmap.remove(zombies.get(i));
        }
        this.components = null;
        return zombies.size();
    }

    public void forget(String id) {
        this.idmap.remove(id);
    }

    public Component find(String id) {
        return (Component)this.idmap.get(id);
    }

    public void setLocale(Locale l) {
        if (SwingEngine.isMacOSXSupported() && SwingEngine.isMacOSX()) {
            l = new Locale(l.getLanguage(), l.getCountry(), MAC_OSX_LOCALE_VARIANT);
        }
        this.localizer.setLocale(l);
    }

    public void setResourceBundle(String bundlename) {
        this.localizer.setResourceBundle(bundlename);
    }

    public Localizer getLocalizer() {
        return this.localizer;
    }

    public TagLibrary getTaglib() {
        return this.taglib;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
        this.localizer.setClassLoader(cl);
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public boolean setActionListener(Component c, ActionListener al) {
        boolean b = false;
        if (c != null) {
            if (Container.class.isAssignableFrom(c.getClass())) {
                Component[] s = ((Container)c).getComponents();
                for (int i = 0; i < s.length; ++i) {
                    b |= this.setActionListener(s[i], al);
                }
            }
            if (!b) {
                if (JMenu.class.isAssignableFrom(c.getClass())) {
                    JMenu m = (JMenu)c;
                    int k = m.getItemCount();
                    for (int i = 0; i < k; ++i) {
                        b |= this.setActionListener((Component)m.getItem(i), al);
                    }
                } else if (AbstractButton.class.isAssignableFrom(c.getClass())) {
                    ((AbstractButton)c).addActionListener(al);
                    b = true;
                }
            }
        }
        return b;
    }

    public Iterator getDescendants(Component c) {
        ArrayList list = new ArrayList(12);
        SwingEngine.traverse(c, list);
        return list.iterator();
    }

    protected void mapMembers(Object obj) {
        Field[] flds = obj.getClass().getFields();
        int n = flds.length;
        for (int i = 0; i < n; ++i) {
            Object uiobj = this.idmap.get(flds[i].getName());
            if (uiobj != null && flds[i].getType().isAssignableFrom(uiobj.getClass())) {
                try {
                    flds[i].set(obj, uiobj);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (flds[i] == null) {
                try {
                    flds[i].set(obj, flds[i].getType().newInstance());
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            if (flds[i] != null) continue;
        }
    }

    protected static void traverse(Component c, Collection collection) {
        block2: {
            block3: {
                if (c == null) break block2;
                collection.add(c);
                if (!(c instanceof JMenu)) break block3;
                JMenu m = (JMenu)c;
                int k = m.getItemCount();
                for (int i = 0; i < k; ++i) {
                    SwingEngine.traverse((Component)m.getItem(i), collection);
                }
                break block2;
            }
            if (!(c instanceof Container)) break block2;
            Component[] s = ((Container)c).getComponents();
            for (int i = 0; i < s.length; ++i) {
                SwingEngine.traverse(s[i], collection);
            }
        }
    }

    public static void setMacOSXSuport(boolean osx) {
        MAC_OSX_SUPPORTED = osx;
    }

    public static boolean isMacOSXSupported() {
        return MAC_OSX_SUPPORTED;
    }

    public static boolean isMacOSX() {
        return MAC_OSX;
    }

    public void test() {
        WindowAdapter wl = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                System.exit(0);
            }
        };
        if (this.root != null) {
            if (JFrame.class.isAssignableFrom(this.root.getClass()) || JDialog.class.isAssignableFrom(this.root.getClass())) {
                ((Window)this.root).addWindowListener((WindowListener)wl);
                this.root.setVisible(true);
            } else {
                JFrame jf = new JFrame("SwiXml Test");
                jf.getContentPane().add((Component)this.root);
                jf.addWindowListener((WindowListener)wl);
                jf.setVisible(true);
            }
        }
    }

    static {
        default_resource_bundle_name = null;
        default_locale = Locale.getDefault();
        MAC_OSX = false;
        MAC_OSX_SUPPORTED = true;
        try {
            MAC_OSX = System.getProperty("os.name").toLowerCase().startsWith(MAC_OSX_OS_NAME);
        }
        catch (Exception e) {
            MAC_OSX = false;
        }
    }
}

