/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.JDKSelection.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;

public class StreamUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public static void transferData(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferFile(File file, OutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            StreamUtils.transferData(in, out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, "" + e);
                }
            }
        }
    }

    public static CharSequence readStream(InputStream input) throws IOException {
        return StreamUtils.readStream(input, Charset.forName("utf-8"));
    }

    public static CharSequence readStream(InputStream input, Charset charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));
        return StreamUtils.readReader(reader);
    }

    public static CharSequence readReader(Reader reader) throws IOException {
        int readLength;
        char[] buffer = new char[4096];
        StringBuilder stringBuilder = new StringBuilder();
        while ((readLength = reader.read(buffer)) != -1) {
            stringBuilder.append(buffer, 0, readLength);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharSequence readFile(File file, Charset charset) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            CharSequence charSequence = StreamUtils.readReader(new InputStreamReader((InputStream)in, charset));
            return charSequence;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException ignord) {}
        }
    }

    public static void writeChars(OutputStream out, CharSequence chars, Charset charset) throws IOException {
        out.write(((Object)chars).toString().getBytes(charset.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChars(File file, CharSequence chars, Charset charset) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            StreamUtils.writeChars(out, chars, charset);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignord) {}
        }
    }
}

