/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.desktopintegration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.provider.conf.oor.OORAddRemoveEntry;
import org.openinstaller.provider.conf.oor.OORShortcut;
import org.openinstaller.provider.task.TaskControl;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.ExecuteCommand;
import org.openinstaller.util.Platform;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.desktopintegration.BaseDesktopIntegrator;
import org.openinstaller.util.desktopintegration.DesktopIntegrator;

public class WindowsDesktopIntegrator
extends BaseDesktopIntegrator {
    private static final Logger LOGGER;
    private static DesktopIntegrator gInstance;

    private WindowsDesktopIntegrator() {
    }

    public static DesktopIntegrator getInstance() {
        return gInstance;
    }

    @Override
    public void createAddRemoveEntry(OORAddRemoveEntry aOORAddRemoveEntry) throws EnhancedException {
        File theWindows;
        File theSys32;
        File theReg;
        if (new Platform(Platform.OSType.WINDOWS, Platform.OSName.WIN95, Platform.Arch.UNDEFINED).isCompatible() || new Platform(Platform.OSType.WINDOWS, Platform.OSName.WIN98, Platform.Arch.UNDEFINED).isCompatible()) {
            LOGGER.finest("No reg.exe, so not adding ARP entries");
            return;
        }
        if (new Platform(Platform.OSType.WINDOWS, Platform.OSName.WIN2000, Platform.Arch.UNDEFINED).isCompatible() && !(theReg = new File(theSys32 = new File(theWindows = new File(System.getenv("SystemRoot")), "system32"), "reg.exe")).exists()) {
            LOGGER.finest("No reg.exe, so not adding ARP entries");
            return;
        }
        BusRequest theReq = new BusRequest("Install-homerequest", new TaskControl(TaskControl.TaskCommand.GET_INSTALL_HOME, null));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/task");
        Object theInstallHomeObj = theResp.getResult();
        String theInstallHome = theInstallHomeObj.toString();
        String theFolderName = "";
        try {
            theFolderName = this.getEncodedKey(theInstallHome);
        }
        catch (EnhancedException theException) {
            throw new EnhancedException("CANNOT_CREATE_ENTRY", (Throwable)theException, theException.getMessage());
        }
        String theKey = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + theFolderName + aOORAddRemoveEntry.getDisplayName();
        String[] theCmd = new String[]{"reg", "add", theKey, "/f"};
        ExecuteCommand theExec = new ExecuteCommand(theCmd);
        theExec.execute();
        if (theExec.getResult() != 0) {
            Exception theException = new Exception("CANNOT CREATE ARP ENTRY");
            throw new EnhancedException("CANNOT_CREATE_ENTRY", (Throwable)theException, theKey);
        }
        String theOutput = theExec.getAllOutput();
        LOGGER.log(Level.FINER, "Script Execution Output: " + theOutput);
        theCmd = new String[]{"reg", "add", theKey, "/v", "DisplayName", "/t", "REG_SZ", "/d", aOORAddRemoveEntry.getDisplayName(), "/f"};
        theExec.setCommand(theCmd);
        theExec.execute();
        theOutput = theExec.getAllOutput();
        LOGGER.log(Level.FINER, "Script Execution Output: " + theOutput);
        if (aOORAddRemoveEntry.getDisplayIcon() != null) {
            theCmd = new String[]{"reg", "add", theKey, "/v", "DisplayIcon", "/t", "REG_SZ", "/d", theInstallHome + "\\" + aOORAddRemoveEntry.getDisplayIcon(), "/f"};
            theExec.setCommand(theCmd);
            theExec.execute();
            theOutput = theExec.getAllOutput();
            LOGGER.log(Level.FINER, "Script Execution Output: " + theOutput);
            if (theExec.getResult() != 0) {
                LOGGER.finest("Unable to Create Icon key in registry");
            }
        }
        theCmd = new String[]{"reg", "add", theKey, "/v", "UninstallString", "/t", "REG_SZ", "/d", theInstallHome + "\\" + aOORAddRemoveEntry.getUninstallString(), "/f"};
        ExecuteCommand theExecCmd = new ExecuteCommand(theCmd);
        theExecCmd.setCommand(theCmd);
        theExecCmd.execute();
        theOutput = theExecCmd.getAllOutput();
        LOGGER.log(Level.FINER, "Script Execution Output: " + theOutput);
        if (theExec.getResult() != 0) {
            Exception theException = new Exception("CANNOT CREATE ARP ENTRY");
            throw new EnhancedException("CANNOT_CREATE_ENTRY", (Throwable)theException, "UninstallString in " + theKey);
        }
    }

    @Override
    public void createShortcut(OORShortcut aShortcut) throws EnhancedException {
    }

    @Override
    public void removeShortcut(OORShortcut aShortcut) throws EnhancedException {
    }

    @Override
    public void removeAddRemoveEntry(OORAddRemoveEntry aAddRemoveEntry) throws EnhancedException {
        File theWindows;
        File theSys32;
        File theReg;
        if (new Platform(Platform.OSType.WINDOWS, Platform.OSName.WIN95, Platform.Arch.UNDEFINED).isCompatible() || new Platform(Platform.OSType.WINDOWS, Platform.OSName.WIN98, Platform.Arch.UNDEFINED).isCompatible()) {
            LOGGER.finest("No reg.exe, so not removing ARP entries");
            return;
        }
        if (new Platform(Platform.OSType.WINDOWS, Platform.OSName.WIN2000, Platform.Arch.UNDEFINED).isCompatible() && !(theReg = new File(theSys32 = new File(theWindows = new File(System.getenv("SystemRoot")), "system32"), "reg.exe")).exists()) {
            LOGGER.finest("No reg.exe, so not removing ARP entries");
            return;
        }
        BusRequest theReq = new BusRequest("Install-homerequest", new TaskControl(TaskControl.TaskCommand.GET_INSTALL_HOME, null));
        BusResponse theResp = ControlBus.getInstance().publishRequest(theReq, "svc://general/task");
        Object theInstallHomeObj = theResp.getResult();
        String theInstallHome = theInstallHomeObj.toString();
        String theFolderName = "";
        try {
            theFolderName = this.getEncodedKey(theInstallHome);
        }
        catch (EnhancedException theException) {
            throw new EnhancedException("CANNOT_CREATE_ENTRY", (Throwable)theException, theException.getMessage());
        }
        String theKey = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + theFolderName + aAddRemoveEntry.getDisplayName();
        String[] theCmd = new String[]{"reg", "delete", theKey, "/f"};
        ExecuteCommand theExec = new ExecuteCommand(theCmd);
        theExec.execute();
        String theOutput = theExec.getAllOutput();
        LOGGER.log(Level.FINER, "Script Execution Output: " + theOutput);
        if (theExec.getResult() != 0) {
            Exception theException = new Exception("CANNOT DELETE ARP ENTRY");
            throw new EnhancedException("CANNOT_DELETE_ENTRY", (Throwable)theException, theKey);
        }
    }

    @Override
    public String getDesktopFolder() throws EnhancedException {
        return WindowsDesktopIntegrator.getShellFolder("Desktop");
    }

    @Override
    public String getAllUsersDesktopFolder() throws EnhancedException {
        return WindowsDesktopIntegrator.getShellFolder("AllUsersDesktop");
    }

    @Override
    public String getStartMenuFolder() throws EnhancedException {
        return WindowsDesktopIntegrator.getShellFolder("StartMenu");
    }

    @Override
    public String getAllUsersStartMenuFolder() throws EnhancedException {
        return WindowsDesktopIntegrator.getShellFolder("AllUsersStartMenu");
    }

    @Override
    public String getProgramMenuFolder() throws EnhancedException {
        return WindowsDesktopIntegrator.getShellFolder("Programs");
    }

    @Override
    public String getAllUsersProgramMenuFolder() throws EnhancedException {
        return WindowsDesktopIntegrator.getShellFolder("AllUsersPrograms");
    }

    private static String getShellFolder(String aFolderName) throws EnhancedException {
        StringBuilder theStringBuilder = new StringBuilder();
        theStringBuilder.append("Set WshShell = WScript.CreateObject(\"WScript.Shell\")\n");
        theStringBuilder.append("StrUserDesktop = WshShell.SpecialFolders(\"" + aFolderName + "\")\n");
        theStringBuilder.append("WScript.Echo StrUserDesktop\n");
        String theResult = WindowsDesktopIntegrator.runWSHScript(theStringBuilder.toString()).trim();
        LOGGER.fine("getShellFolder(" + aFolderName + ") = " + theResult);
        return theResult;
    }

    private static String runWSHScript(String aScriptCode) throws EnhancedException {
        LOGGER.log(Level.FINER, "SCRIPT CODE: \n" + aScriptCode);
        FileWriter theWriter = null;
        String theOutput = "";
        try {
            File theTempFile = File.createTempFile("wshscript", ".vbs");
            theWriter = new FileWriter(theTempFile);
            theWriter.write(aScriptCode);
            theWriter.close();
            String[] theCmd = new String[]{"cscript", "\"" + theTempFile.getAbsolutePath() + "\"", "//NOLOGO"};
            ExecuteCommand theExec = new ExecuteCommand(theCmd);
            theExec.execute();
            theOutput = theExec.getAllOutput();
            LOGGER.log(Level.FINER, "Script Execution Output: " + theOutput);
        }
        catch (IOException theIOE) {
            throw new EnhancedException(theIOE);
        }
        return theOutput;
    }

    private String getEncodedKey(String aInput) throws EnhancedException {
        String theOutput = "";
        try {
            MessageDigest theDigester = MessageDigest.getInstance("MD5");
            theDigester.update(aInput.getBytes());
            byte[] theDigest = theDigester.digest();
            theOutput = StringUtils.encodeData(theDigest);
        }
        catch (NoSuchAlgorithmException theException) {
            throw new EnhancedException(theException);
        }
        return theOutput;
    }

    static {
        gInstance = new WindowsDesktopIntegrator();
        LOGGER = Logger.getLogger(ClassUtils.getClassName());
    }
}

