/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.substitution;

import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.substitution.Token;

public class ShorthandToken
implements Token {
    private StringBuilder gTokenVariable = new StringBuilder();
    private static final char PATH_SEPARATOR = ':';
    private static final char FILE_SEPARATOR = '/';

    @Override
    public boolean validate() {
        return this.gTokenVariable.length() == 1 || this.gTokenVariable.charAt(0) == ':' && this.gTokenVariable.charAt(0) == '/';
    }

    @Override
    public String resolve() throws EnhancedException {
        String theReturnValue = null;
        if (this.validate()) {
            switch (this.gTokenVariable.charAt(0)) {
                case '/': {
                    theReturnValue = System.getProperty("file.separator");
                    break;
                }
                case ':': {
                    theReturnValue = System.getProperty("path.separator");
                    break;
                }
                default: {
                    throw new EnhancedException("CANNOT_DETERMINE_SHORTHAND_TOKEN", "value=" + this.gTokenVariable.toString());
                }
            }
        }
        return theReturnValue;
    }

    @Override
    public String get() {
        return this.gTokenVariable.toString();
    }

    @Override
    public void set(StringBuilder aInput) {
        this.gTokenVariable = aInput;
    }
}

