/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.substitution;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.DataModel;

public final class SimpleInputSource {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static SimpleInputSource gSource = null;
    private DataModel gDataModel = null;

    private SimpleInputSource() {
        this.initializeSource();
    }

    public static SimpleInputSource getInstance() {
        SimpleInputSource theSource = gSource == null ? new SimpleInputSource() : gSource;
        return theSource;
    }

    private void initializeSource() {
        URL theURL = this.getClass().getResource("/templates/oor.properties");
        try {
            if (null == this.gDataModel) {
                this.gDataModel = new DataModel(theURL);
            } else {
                this.gDataModel.load(theURL);
            }
        }
        catch (Exception theEx) {
            LOGGER.log(Level.WARNING, "COULD_NOT_LOAD_RESOURCE", theEx);
        }
    }

    public String resolveToken(String aToken) {
        return (String)this.gDataModel.get(aToken);
    }
}

