/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.util.Encoders;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.StringUtils;
import org.openinstaller.util.Version;
import org.openinstaller.util.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Package {
    private String gName;
    private transient String gId;
    private Version gVersion;
    private String gDescription;
    private String gLocation;
    private final String gInstance;
    private final Set<VersionRange> gCompatibleVersions = new LinkedHashSet<VersionRange>();
    private Object gAppData;
    private boolean gCritical = false;
    private boolean gOverwriteAllowed = false;
    private Backend.EntityState gState;
    private final Set<Package> gRequiredPackages = new LinkedHashSet<Package>();

    public boolean isCompatible(Package aPkg) {
        for (VersionRange theRange : this.gCompatibleVersions) {
            if (!theRange.includesVersion(aPkg.getVersion())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object aPkg) {
        if (null == aPkg) {
            return false;
        }
        if (aPkg.getClass() != Package.class) {
            return false;
        }
        Package thePkg = (Package)aPkg;
        return SystemProduct.theSame(this.gVersion, thePkg.gVersion) && SystemProduct.theSame(this.gInstance, thePkg.gInstance) && SystemProduct.theSame(this.gName, thePkg.gName);
    }

    public int hashCode() {
        return this.gName.hashCode() + this.gVersion.hashCode() + this.gInstance.hashCode();
    }

    public String toString() {
        return "Package:[" + this.gName + "," + Version.encode((Version)this.gVersion) + "," + this.gInstance + "]";
    }

    public static String encode(Package aPkg) {
        StringBuilder theEnc = new StringBuilder();
        if (aPkg.getID() != null) {
            theEnc.append(StringUtils.escape((String)aPkg.getID(), (char)'&'));
        } else {
            theEnc.append(StringUtils.escape((String)aPkg.getName(), (char)'&'));
        }
        theEnc.append('&');
        theEnc.append(StringUtils.escape((String)Version.encode((Version)aPkg.getVersion()), (char)'&'));
        theEnc.append('&');
        theEnc.append(StringUtils.escape((String)aPkg.getInstance(), (char)'&'));
        theEnc.append('&');
        if (aPkg.getID() != null) {
            theEnc.append(StringUtils.escape((String)aPkg.getID(), (char)'&'));
        }
        theEnc.append('&');
        if (aPkg.getLocation() != null) {
            theEnc.append(StringUtils.escape((String)aPkg.getLocation(), (char)'&'));
        }
        theEnc.append('&');
        if (aPkg.getDescription() != null) {
            theEnc.append(StringUtils.escape((String)aPkg.getDescription(), (char)'&'));
        }
        theEnc.append('&');
        Iterator<VersionRange> theCompat = aPkg.getCompatibleVersions();
        while (theCompat.hasNext()) {
            theEnc.append(StringUtils.escape((String)StringUtils.escape((String)VersionRange.encode((VersionRange)theCompat.next()), (char)'&'), (char)'%'));
            if (!theCompat.hasNext()) continue;
            theEnc.append('%');
        }
        theEnc.append('&');
        if (aPkg.getRequiredPackageCount() > 0) {
            Iterator<Package> theReqd = aPkg.getRequiredPackages();
            while (theReqd.hasNext()) {
                theEnc.append(StringUtils.escape((String)StringUtils.escape((String)Package.encode(theReqd.next()), (char)'&'), (char)'%'));
                if (!theReqd.hasNext()) continue;
                theEnc.append('%');
            }
        }
        return theEnc.toString();
    }

    public Package(String aSpec) throws SIMSException {
        String[] theSpecElements = Encoders.split(aSpec, '&');
        if (theSpecElements.length != 8) {
            throw new SIMSException("CORRUPT_PKG_SPEC", "spec=" + aSpec);
        }
        this.gName = StringUtils.unescape((String)theSpecElements[0], (char)'&');
        this.gVersion = new Version(StringUtils.unescape((String)theSpecElements[1], (char)'&'));
        this.gInstance = StringUtils.unescape((String)theSpecElements[2], (char)'&');
        this.setID(StringUtils.unescape((String)theSpecElements[3], (char)'&'));
        this.setLocation(StringUtils.unescape((String)theSpecElements[4], (char)'&'));
        this.setDescription(StringUtils.unescape((String)theSpecElements[5], (char)'&'));
        if (theSpecElements[6].length() > 0) {
            String[] theCompats;
            for (String theCompat : theCompats = Encoders.split(StringUtils.unescape((String)theSpecElements[6], (char)'&'), '%')) {
                try {
                    this.addCompatibleVersion(new VersionRange(StringUtils.unescape((String)theCompat, (char)'%')));
                }
                catch (EnhancedException theEx) {
                    throw new SIMSException(theEx, "CORRUPT_PKG_SPEC", "spec=" + theCompat);
                }
            }
        }
        if (theSpecElements[7].length() > 0) {
            String[] theReqds;
            for (String theReqd : theReqds = Encoders.split(StringUtils.unescape((String)theSpecElements[7], (char)'&'), '%')) {
                try {
                    this.addRequiredPackage(new Package(StringUtils.unescape((String)theReqd, (char)'%')));
                }
                catch (InvalidArgumentException theEx) {
                    throw new SIMSException(theEx, "CORRUPT_PKG_SPEC", "spec=" + theReqd);
                }
            }
        }
        this.gState = Backend.EntityState.NOT_INSTALLED;
    }

    public Package(String aName, Version aVersion, String aInstance) throws InvalidArgumentException {
        if (aName == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"name=(null)"});
        }
        if (aVersion == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"version=(null)"});
        }
        if (aInstance == null) {
            throw new InvalidArgumentException("VAR_CANNOT_BE_NULL", new String[]{"instance=(null)"});
        }
        this.gName = aName;
        this.gVersion = aVersion;
        this.gInstance = aInstance;
        this.gState = Backend.EntityState.NOT_INSTALLED;
    }

    public Iterator<Package> getRequiredPackages() {
        return this.gRequiredPackages.iterator();
    }

    public int getRequiredPackageCount() {
        return this.gRequiredPackages.size();
    }

    public void addRequiredPackage(Package aPackage) throws InvalidArgumentException {
        if (this.equals(aPackage)) {
            throw new InvalidArgumentException("ERROR_PKG_SELF_DEPENDENCE", new String[]{"package=" + this.toString()});
        }
        if (this.gRequiredPackages.contains(aPackage)) {
            this.gRequiredPackages.remove(aPackage);
        }
        this.gRequiredPackages.add(aPackage);
    }

    public String getName() {
        return this.gName;
    }

    public void setName(String aPackageName) {
        this.gName = aPackageName;
    }

    public void setID(String aId) {
        this.gId = aId;
    }

    public String getID() {
        return this.gId;
    }

    public void setVersion(Version aVersion) {
        this.gVersion = aVersion;
    }

    public Version getVersion() {
        return this.gVersion;
    }

    public String getDescription() {
        return this.gDescription;
    }

    public void setDescription(String aDescription) {
        this.gDescription = aDescription;
    }

    public String getLocation() {
        return this.gLocation;
    }

    public void setLocation(String aLocation) {
        this.gLocation = aLocation;
    }

    public String getInstance() {
        return this.gInstance;
    }

    public Iterator<VersionRange> getCompatibleVersions() {
        return this.gCompatibleVersions.iterator();
    }

    public void addCompatibleVersion(VersionRange aCompatibleVersion) {
        this.gCompatibleVersions.add(aCompatibleVersion);
    }

    public Object getAppdata() {
        return this.gAppData;
    }

    public void setAppdata(Object aAppdata) {
        this.gAppData = aAppdata;
    }

    public Backend.EntityState getState() {
        return this.gState;
    }

    public void setState(Backend.EntityState aState) {
        this.gState = aState;
    }

    public void setOverwriteAllowed(boolean aOverwriteAllowed) {
        this.gOverwriteAllowed = aOverwriteAllowed;
    }

    public boolean isOverwriteAllowed() {
        return this.gOverwriteAllowed;
    }

    public boolean isCritical() {
        return this.gCritical;
    }

    public void setCritical(boolean aCritical) {
        this.gCritical = aCritical;
    }
}

