/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.task;

import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.NoSuchMemberException;
import org.openinstaller.provider.conf.ConfigHelper;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.PlatformInstUnit;
import org.openinstaller.provider.sims.SIMSControl;
import org.openinstaller.provider.task.Task;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.ProgressListener;
import org.openinstaller.sims.SIMSException;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;

public class RegisterTask
extends Task {
    private static Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private Package gPackage;
    private MediaProduct gProduct;
    private Platform gPlatform;

    boolean perform(ProgressListener aListener) {
        block9: {
            if (this.gPackage != null) {
                try {
                    LOGGER.log(Level.FINE, "REGISTER_PKG", this.gPackage.getName());
                    BusRequest theSIMSPkgReq = new BusRequest("SIMSRequest", (Object)new SIMSControl(SIMSControl.SIMSCommand.REGISTER_PACKAGE, this.gPackage));
                    BusResponse theSIMSPkgResp = ControlBus.getInstance().publishRequest(theSIMSPkgReq, "svc://general/sims");
                    if (theSIMSPkgResp.getException() != null) {
                        LOGGER.log(Level.SEVERE, "CANNOT_REGISTER_PACKAGE", theSIMSPkgResp.getException());
                        return false;
                    }
                    break block9;
                }
                catch (InvalidArgumentException theEIAEx) {
                    theEIAEx.addContext("CANNOT_REGISTER_PACKAGE", new String[]{"package=" + this.gPackage.getName()});
                    LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
                    return false;
                }
                catch (NoSuchMemberException theNSEx) {
                    theNSEx.addContext("CANNOT_REGISTER_PACKAGE", new String[]{"package=" + this.gPackage.getName()});
                    LOGGER.log(Level.SEVERE, "CANNOT_REGISTER_PACKAGE", theNSEx);
                    return false;
                }
            }
            if (this.gProduct != null) {
                try {
                    SystemProduct theProdToRegister = this.createProduct(this.gProduct);
                    BusRequest theSIMSProdReq = new BusRequest("SIMSRequest", (Object)new SIMSControl(SIMSControl.SIMSCommand.REGISTER_PRODUCT, theProdToRegister));
                    BusResponse theSIMProdResp = ControlBus.getInstance().publishRequest(theSIMSProdReq, "svc://general/sims");
                    if (theSIMProdResp.getException() != null) {
                        LOGGER.log(Level.SEVERE, "CANNOT_REGISTER_PRODUCT", theSIMProdResp.getException());
                        return false;
                    }
                    break block9;
                }
                catch (EnhancedException theSIMSEx) {
                    theSIMSEx.addContext("CANT_GET_PRODUCT_FROM_SIMS", new String[]{"product=" + this.gProduct.getID()});
                    LOGGER.log(Level.SEVERE, "CANT_GET_PRODUCT_FROM_SIMS", theSIMSEx);
                    return false;
                }
            }
            LOGGER.log(Level.WARNING, "NO_PKG_OR_PROD_TO_REGISTER");
        }
        return true;
    }

    private SystemProduct createProduct(MediaProduct aProduct) throws EnhancedException {
        Boolean theCriticalFlag = null;
        Platform theCurrentPlatform = Platform.getCurrentPlatform();
        SystemProduct theProd = new SystemProduct(aProduct.getID(), aProduct.getVersion(), "instance0", aProduct.getName());
        theProd.setDescription(aProduct.getDescriptions());
        LOGGER.log(Level.FINE, "Product to register: " + theProd);
        LOGGER.fine("Dependencies: " + aProduct.getDependencies());
        for (MediaProduct theDep : aProduct.getDependencies()) {
            if (theDep == null) continue;
            SystemProduct theSIMSDep = this.getSIMSProduct(theDep.getID(), theDep.getVersionStr(), "instance0");
            LOGGER.fine("Discovered dependency product: " + theSIMSDep);
            if (theSIMSDep == null) continue;
            theProd.addRequiredProduct(theSIMSDep);
            LOGGER.fine("Added discovered product.  New set: " + theProd.getRequiredProducts());
        }
        LOGGER.fine("Features:" + aProduct.getFeatures());
        for (MediaProduct theFeat : aProduct.getFeatures()) {
            if (theFeat == null) continue;
            SystemProduct theSIMSFeat = this.getSIMSProduct(theFeat.getID(), theFeat.getVersionStr(), "instance0");
            LOGGER.fine("Discovered feature: " + theSIMSFeat);
            if (theSIMSFeat != null) {
                theProd.addContainedProduct(theSIMSFeat);
                LOGGER.fine("Added discovered feature as contained prod. new set: " + theProd.getContainedProducts());
                continue;
            }
            SystemProduct theRef = new SystemProduct(theFeat.getID(), theFeat.getVersion(), "instance0", theFeat.getName());
            theRef.setDescription(theFeat.getDescription(), Locale.getDefault());
            theProd.addContainedProduct(theRef);
            LOGGER.fine("Added a feature reference as contained prod: " + theProd.getContainedProducts());
        }
        String theRelease = aProduct.getRelease(theCurrentPlatform);
        if (null != theRelease) {
            theProd.setRelease(new Version(theRelease));
        }
        ArrayList<PlatformInstUnit> thePlatformPkgs = new ArrayList<PlatformInstUnit>();
        thePlatformPkgs.addAll(aProduct.getCoreInstallableUnits(theCurrentPlatform));
        if (ConfigHelper.getBooleanValue("L10nSelection.directory.INSTALL_L10N")) {
            thePlatformPkgs.addAll(aProduct.getLocalizedInstallableUnits(theCurrentPlatform));
        }
        LOGGER.fine("Pkgs: " + thePlatformPkgs);
        for (PlatformInstUnit thePlatPkg : thePlatformPkgs) {
            if (thePlatPkg == null) continue;
            String thePkgVer = thePlatPkg.getIU().getVersion();
            if (null == thePkgVer || "".equals(thePkgVer)) {
                thePkgVer = aProduct.getVersionStr();
            }
            Package thePkg = this.getSIMSPackage(thePlatPkg.getIU().getCoreInstallableUnitName(), thePkgVer);
            LOGGER.fine("Discovered package: " + thePkg);
            if (thePkg == null) continue;
            thePkg.setOverwriteAllowed(thePlatPkg.getIU().getOverwrite());
            if (thePlatPkg.getIU().isCritical()) {
                LOGGER.finest("@ Set Critical flag for " + theProd.getID());
                theCriticalFlag = true;
            }
            theProd.addContainedPackage(thePkg);
            LOGGER.fine("Added discovered pkg as contained pkg: new set: " + theProd.getContainedPackages());
        }
        if (theCriticalFlag != null) {
            theProd.setCritical(true);
        }
        return theProd;
    }

    private Package getSIMSPackage(String aPkgName, String aVersion) throws SIMSException {
        try {
            Package theTmpPkg = new Package(aPkgName, new Version(aVersion), "instance0");
            BusResponse theResp = ControlBus.getInstance().publishRequest(new BusRequest("pkg retrieval", (Object)new SIMSControl(SIMSControl.SIMSCommand.GET_PACKAGE, theTmpPkg)), "svc://general/sims");
            if (theResp.getException() != null) {
                throw new SIMSException((Throwable)theResp.getException(), "CANNOT_RETRIEVE_PKG", new String[]{"package=" + aPkgName});
            }
            return (Package)theResp.getResult();
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new SIMSException((Throwable)theEIAEx, "CANNOT_RETRIEVE_PKG", new String[]{"package=" + aPkgName});
        }
        catch (BusException theBe) {
            throw new SIMSException((Throwable)theBe, "CANNOT_RETRIEVE_PKG", new String[]{"package=" + aPkgName});
        }
    }

    private SystemProduct getSIMSProduct(String aID, String aVersion, String aInstance) throws SIMSException {
        try {
            SystemProduct theTmpProd = new SystemProduct(aID, new Version(aVersion), aInstance, "");
            BusResponse theResp = ControlBus.getInstance().publishRequest(new BusRequest("pkg retrieval", (Object)new SIMSControl(SIMSControl.SIMSCommand.GET_PRODUCT_BY_INSTANCE, theTmpProd)), "svc://general/sims");
            if (theResp.getException() != null) {
                throw new SIMSException((Throwable)theResp.getException(), "CANNOT_RETRIEVE_PRODUCT", new String[]{"product=" + theTmpProd});
            }
            return (SystemProduct)theResp.getResult();
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new SIMSException((Throwable)theEIAEx, "CANNOT_RETRIEVE_PRODUCT", new String[]{"product=" + aID});
        }
        catch (BusException theBe) {
            throw new SIMSException((Throwable)theBe, "CANNOT_RETRIEVE_PRODUCT", new String[]{"product=" + aID});
        }
    }

    public RegisterTask(Package aPackage, MediaProduct aProduct, Platform aPlatform) {
        this.gPackage = aPackage;
        this.gProduct = aProduct;
        this.gPlatform = aPlatform;
    }
}

