/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.sims.legacy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.sims.Backend;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.sims.backends.rpm.RPMUtils;
import org.openinstaller.sims.backends.svr4.SolarisPackageUtils;
import org.openinstaller.sims.backends.zip.WindowsUtils;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyDetector {
    private Map<String, String> gKeyReq;
    private List<String> gKeyFiles;
    SystemProduct gLegacyProduct;
    private String gInstallHome;
    private Backend.EntityState gState;
    private List<Package> gListOfPackages = new ArrayList<Package>();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public LegacyDetector(SystemProduct aLegacyProduct, List<String> aKeyFiles, Map<String, String> aKeyReq, String aInstallHome) {
        this.gLegacyProduct = aLegacyProduct;
        this.gKeyReq = aKeyReq;
        this.gKeyFiles = aKeyFiles;
        this.gInstallHome = aInstallHome;
    }

    public SystemProduct getDetectionResult() throws EnhancedException {
        boolean theFilesExists = false;
        boolean thePackagesExists = false;
        boolean theKeyRegEntriesExists = false;
        Version theFinalProductVersion = null;
        if (this.gLegacyProduct == null) {
            LOGGER.fine("No legacy product exists for detection.");
            return null;
        }
        LOGGER.finer("~ Detecting product " + this.gLegacyProduct.getName() + " Ver = " + this.gLegacyProduct.getVersion().toString() + " St = " + this.gLegacyProduct.getState().toString());
        if (Platform.getCurrentOsType() == Platform.OSType.WINDOWS) {
            boolean theFileExists = false;
            int theTotalKeyFile = 0;
            for (String theFile : this.gKeyFiles) {
                theFileExists = LegacyDetector.exists(theFile, this.gInstallHome);
                if (!theFileExists) continue;
                ++theTotalKeyFile;
            }
            Set<String> theKeySet = this.gKeyReq.keySet();
            boolean theKeyExists = false;
            int theTotalRegistryKey = 0;
            for (String theKey : theKeySet) {
                theKeyExists = WindowsUtils.found(theKey, this.gKeyReq.get(theKey));
                if (!theKeyExists) continue;
                ++theTotalRegistryKey;
            }
            if (this.gKeyFiles.size() == 0 && theKeySet.size() == 0) {
                this.gState = Backend.EntityState.NOT_INSTALLED;
            } else if ((theTotalKeyFile != 0 || theTotalRegistryKey != 0) && theTotalKeyFile == this.gKeyFiles.size() && theTotalRegistryKey == theKeySet.size()) {
                this.gState = Backend.EntityState.INSTALLED;
            } else if ((theTotalKeyFile != 0 || theTotalRegistryKey != 0) && theTotalKeyFile < this.gKeyFiles.size() || theTotalRegistryKey < theKeySet.size()) {
                this.gState = Backend.EntityState.DAMAGED;
            } else if (theTotalKeyFile == 0 && theTotalRegistryKey == 0) {
                this.gState = Backend.EntityState.NOT_INSTALLED;
            }
        } else if (Platform.getCurrentOsName() == Platform.OSName.SOLARIS) {
            Backend.EntityState thePkgState = Backend.EntityState.NOT_INSTALLED;
            int thePackageCount = this.countPackage(this.gLegacyProduct);
            boolean thePackageExists = false;
            int theCountPackageFound = 0;
            for (Package thePackage : this.gListOfPackages) {
                LOGGER.fine("@ Package to detect = " + thePackage.getName() + " at IH = " + this.gInstallHome);
                try {
                    thePackageExists = SolarisPackageUtils.isSVR4Installed(thePackage.getName(), this.gInstallHome);
                }
                catch (EnhancedException theEx) {
                    LOGGER.log(Level.FINE, "Could not detect the package. No big deal", theEx);
                    continue;
                }
                Version theFoundPkgVers = null;
                if (!thePackageExists) continue;
                LOGGER.finer("@ Legacy Package found = " + thePackage.getName());
                String theProdVersString = SolarisPackageUtils.getPkgParam(thePackage.getName(), this.gInstallHome, SolarisPackageUtils.PkgInfoEntry.SUNW_PRODVERS);
                theFinalProductVersion = SolarisPackageUtils.getPkgVersion(thePackage.getName(), this.gInstallHome);
                theFoundPkgVers = null != theProdVersString ? new Version(theProdVersString.trim()) : theFinalProductVersion;
                this.updatePackageVersion(theFoundPkgVers, thePackage);
                thePackage.setState(Backend.EntityState.INSTALLED);
                ++theCountPackageFound;
            }
            LOGGER.finer("% Pkgs Found = " + theCountPackageFound);
            if (theCountPackageFound == 0) {
                thePkgState = Backend.EntityState.NOT_INSTALLED;
            } else if (theCountPackageFound == thePackageCount) {
                thePkgState = Backend.EntityState.INSTALLED;
            } else if (theCountPackageFound != 0 && theCountPackageFound < thePackageCount) {
                thePkgState = Backend.EntityState.DAMAGED;
            }
            LOGGER.finer(" Pkg state = " + thePkgState.toString());
            this.setEntityState(thePkgState);
            LOGGER.finer("&  Package state = " + (Object)((Object)this.gState));
        } else if (Platform.getCurrentOsName() == Platform.OSName.LINUX) {
            Backend.EntityState thePkgState = Backend.EntityState.NOT_INSTALLED;
            int thePackageCount = this.countPackage(this.gLegacyProduct);
            boolean thePackageExists = false;
            int theCountPackageFound = 0;
            for (Package thePackage : this.gListOfPackages) {
                LOGGER.finer("@ Package to detect = " + thePackage.getName() + " at IH = " + this.gInstallHome);
                try {
                    thePackageExists = RPMUtils.isRPMInstalled(thePackage.getName(), this.gInstallHome);
                }
                catch (EnhancedException theEx) {
                    LOGGER.log(Level.FINE, "Could not detect the rpm. No big deal", theEx);
                    continue;
                }
                Version theRPMVersion = null;
                if (!thePackageExists) continue;
                LOGGER.finer("@Legacy Package found = " + thePackage.toString());
                theRPMVersion = RPMUtils.getRPMVersionRelease(thePackage.getName(), this.gInstallHome);
                thePackage.setName(RPMUtils.formRPMName(thePackage.getName(), theRPMVersion.toString()));
                this.updatePackageVersion(theRPMVersion, thePackage);
                theFinalProductVersion = theRPMVersion;
                thePackage.setState(Backend.EntityState.INSTALLED);
                ++theCountPackageFound;
            }
            if (theCountPackageFound == 0) {
                thePkgState = Backend.EntityState.NOT_INSTALLED;
            } else if (theCountPackageFound == thePackageCount) {
                thePkgState = Backend.EntityState.INSTALLED;
            } else if (theCountPackageFound != 0 && theCountPackageFound < thePackageCount) {
                thePkgState = Backend.EntityState.DAMAGED;
            }
            this.setEntityState(thePkgState);
        }
        this.gLegacyProduct.setState(this.gState);
        LOGGER.finer("@ Legacy Product state after detection = " + this.gLegacyProduct.getState().toString());
        if (this.gLegacyProduct.getState() != Backend.EntityState.NOT_INSTALLED) {
            this.updateProductRelease(theFinalProductVersion);
        }
        return this.gLegacyProduct;
    }

    public void setEntityState(Backend.EntityState aPkgState) {
        Backend.EntityState theFilesState = this.checkFileExists();
        LOGGER.finer("@ KeyFiles status = " + theFilesState.toString() + " Pkg status = " + aPkgState.toString());
        this.gState = aPkgState == Backend.EntityState.NOT_INSTALLED && theFilesState == Backend.EntityState.NOT_INSTALLED ? Backend.EntityState.NOT_INSTALLED : (aPkgState == Backend.EntityState.NOT_INSTALLED ? theFilesState : aPkgState);
        LOGGER.finer("@ KeyFiles status = " + theFilesState.toString() + " Pkg status = " + aPkgState.toString());
    }

    public Backend.EntityState checkFileExists() {
        Backend.EntityState theState = Backend.EntityState.NOT_INSTALLED;
        int theTotalKeyFile = 0;
        if (this.gKeyFiles != null && !this.gKeyFiles.isEmpty()) {
            boolean theFileExists = false;
            for (String theFile : this.gKeyFiles) {
                theFileExists = LegacyDetector.exists(theFile, this.gInstallHome);
                if (!theFileExists) continue;
                ++theTotalKeyFile;
            }
            if (theTotalKeyFile == 0) {
                theState = Backend.EntityState.NOT_INSTALLED;
            } else if (theTotalKeyFile == this.gKeyFiles.size()) {
                theState = Backend.EntityState.INSTALLED;
            } else if (theTotalKeyFile != 0 && theTotalKeyFile < this.gKeyFiles.size()) {
                theState = Backend.EntityState.DAMAGED;
            }
        }
        return theState;
    }

    public static boolean exists(String aFilePath, String aInstallHome) {
        return new File(new File(aInstallHome), aFilePath).isFile();
    }

    private void listPackage(SystemProduct aProduct) {
        LOGGER.finest("@Generating package list for " + aProduct.getName());
        for (SystemProduct theContainedProduct : aProduct.getContainedProducts()) {
            this.listPackage(theContainedProduct);
        }
        for (SystemProduct theRequiredProduct : aProduct.getContainedProducts()) {
            this.listPackage(theRequiredProduct);
        }
        for (Package thePkg : aProduct.getContainedPackages()) {
            LOGGER.finer("@ Adding package = " + thePkg);
            this.gListOfPackages.add(thePkg);
        }
    }

    private int countPackage(SystemProduct aProduct) {
        this.listPackage(aProduct);
        int theTotalPackageCount = this.gListOfPackages.size();
        return theTotalPackageCount;
    }

    private void updatePackageVersion(Version aFoundVersion, Package aPackage) {
        if (null != aFoundVersion) {
            LOGGER.finest("@ Compare -> Installed ver = " + aFoundVersion.toString() + " Legacy ver = " + aPackage.getVersion().toString());
            if (aFoundVersion.compareTo(aPackage.getVersion()) != 0) {
                LOGGER.finest(" @ Setting package version to " + aFoundVersion.toString() + " for Package name = " + aPackage.getName());
                aPackage.setVersion(aFoundVersion);
            }
        }
    }

    private void updateProductRelease(Version aFinalProductVersion) {
        Version theStoredRel = null;
        Version theCurrentRel = null;
        for (Package thePkg : this.gLegacyProduct.getContainedPackages()) {
            LOGGER.finer("^ " + thePkg.toString() + " 's state = " + thePkg.getState().toString());
            if (thePkg.getState() == Backend.EntityState.NOT_INSTALLED) continue;
            theCurrentRel = thePkg.getVersion();
            if (theStoredRel == null) {
                theStoredRel = theCurrentRel;
                continue;
            }
            if (theCurrentRel.compareTo(theStoredRel) <= 0) continue;
            theStoredRel = theCurrentRel;
        }
        if (theStoredRel != null) {
            LOGGER.finer("@ Stored rel = " + theStoredRel.toString());
            this.gLegacyProduct.setRelease(theStoredRel);
            if (theStoredRel.compareTo(aFinalProductVersion) > 0) {
                this.gLegacyProduct.setVersion(theStoredRel);
            } else {
                this.gLegacyProduct.setVersion(aFinalProductVersion);
            }
        } else if (aFinalProductVersion != null) {
            this.gLegacyProduct.setVersion(aFinalProductVersion);
            this.gLegacyProduct.setRelease(aFinalProductVersion);
        }
        LOGGER.finest("@ Detected legacy product ID=" + this.gLegacyProduct.getID() + " description=" + this.gLegacyProduct.getDescription() + " release = " + this.gLegacyProduct.getRelease() + " version = " + this.gLegacyProduct.getVersion());
    }
}

