/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.conf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openinstaller.bindings.config.ResultReportType;
import org.openinstaller.provider.conf.ResultReport;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.FileUtils;
import org.openinstaller.util.LogThread;
import org.openinstaller.util.Msg;

public class ResultReportReaderThread
implements Runnable {
    private final InputStream gLogStream;
    private final InputStream gResultStream;
    private ResultReport gResult;
    private Throwable gException;
    private String gOutput;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    public ResultReportReaderThread(InputStream aInput, InputStream aError) {
        this.gLogStream = aInput;
        this.gResultStream = aError;
    }

    public ResultReport getResult() {
        return this.gResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllOutput() {
        ResultReportReaderThread resultReportReaderThread = this;
        synchronized (resultReportReaderThread) {
            return this.gOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAllOutput(String aOut) {
        ResultReportReaderThread resultReportReaderThread = this;
        synchronized (resultReportReaderThread) {
            this.gOutput = aOut;
        }
    }

    public Throwable getException() {
        return this.gException;
    }

    public void run() {
        ByteArrayOutputStream theLogData = new ByteArrayOutputStream();
        LogThread theLogThread = new LogThread(this.gLogStream, (OutputStream)theLogData);
        theLogThread.start();
        ByteArrayOutputStream theResultRawData = new ByteArrayOutputStream();
        try {
            FileUtils.copyStream((InputStream)this.gResultStream, (OutputStream)theResultRawData);
            LOGGER.log(Level.INFO, "RAW_DATA", new String[]{"id=" + Thread.currentThread().getName(), "data=[" + theResultRawData.toString() + "]"});
            JAXBContext theContext = JAXBContext.newInstance((String)"org.openinstaller.bindings.config");
            Unmarshaller theUnMarshaller = theContext.createUnmarshaller();
            InputStreamReader theResultRawReader = new InputStreamReader(new ByteArrayInputStream(theResultRawData.toByteArray()));
            Object theResult = ((JAXBElement)theUnMarshaller.unmarshal((Reader)theResultRawReader)).getValue();
            this.gResult = this.createResult((ResultReportType)theResult);
        }
        catch (JAXBException theEx) {
            this.gException = theEx;
        }
        catch (IOException theEx) {
            this.gException = theEx;
        }
        this.setAllOutput(theLogData.toString());
        if (this.gException != null) {
            LOGGER.log(Level.FINE, "Exception thrown during result reading", this.gException);
            this.gResult = new ResultReport(ResultReport.ResultStatus.FAIL, theResultRawData.toString(), Msg.get((String)"INVALID_RESULT_REPORT", (Object[])new Object[0]), this.gException.getLocalizedMessage(), theLogData.toString());
        }
        try {
            theLogThread.join();
        }
        catch (InterruptedException theEx) {
            LOGGER.log(Level.FINE, "Exception thrown while waiting for configurator to finish", this.gException);
        }
        this.setAllOutput(theLogData.toString());
    }

    private ResultReport createResult(ResultReportType aResult) {
        return new ResultReport(ResultReport.ResultStatus.valueOf(aResult.getConfigStatus().value()), aResult.getDocReference(), aResult.getNextSteps(), aResult.getPlatformError(), aResult.getProductError());
    }
}

