/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.operation;

import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.Platform;

public final class Operation {
    private final OPTYPE gOperation;
    private final Package gSystemPackage;
    private final SystemProduct gSystemProduct;
    private final Package gMediaPackage;
    private final MediaProduct gMediaProduct;
    private final Platform gMediaPlatform;
    private Object gOperationData;

    public Package getSystemPackage() {
        return this.gSystemPackage;
    }

    public SystemProduct getSystemProduct() {
        return this.gSystemProduct;
    }

    public Package getMediaPackage() {
        return this.gMediaPackage;
    }

    public MediaProduct getMediaProduct() {
        return this.gMediaProduct;
    }

    public OPTYPE getOperation() {
        return this.gOperation;
    }

    public Platform getMediaPlatform() {
        return this.gMediaPlatform;
    }

    public Object getData() {
        return this.gOperationData;
    }

    public void setData(Object aOperationData) {
        this.gOperationData = aOperationData;
    }

    public Operation(OPTYPE aOperation, Package aSystemPackage, SystemProduct aSystemProduct, Package aMediaPackage, MediaProduct aMediaProduct) {
        this(aOperation, aSystemPackage, aSystemProduct, aMediaPackage, aMediaProduct, Platform.getCurrentPlatform());
    }

    public Operation(OPTYPE aOperation, Package aSystemPackage, SystemProduct aSystemProduct, Package aMediaPackage, MediaProduct aMediaProduct, Platform aMediaPlatform) {
        this.gOperation = aOperation;
        this.gSystemPackage = aSystemPackage;
        this.gSystemProduct = aSystemProduct;
        this.gMediaPackage = aMediaPackage;
        this.gMediaProduct = aMediaProduct;
        this.gMediaPlatform = aMediaPlatform;
    }

    public boolean compareTo(Operation aOp) {
        if (aOp == null) {
            return false;
        }
        if (this == aOp) {
            return true;
        }
        if (this.gOperation != aOp.getOperation()) {
            return false;
        }
        if (!this.theSamePackage(this.gMediaPackage, aOp.getMediaPackage())) {
            return false;
        }
        if (!this.theSamePackage(this.gSystemPackage, aOp.getSystemPackage())) {
            return false;
        }
        if (!this.theSameMediaProduct(this.gMediaProduct, aOp.getMediaProduct())) {
            return false;
        }
        return this.theSameSystemProduct(this.gSystemProduct, aOp.getSystemProduct());
    }

    private boolean theSameMediaProduct(MediaProduct aProd, MediaProduct aNotherProd) {
        if (aProd == null && aNotherProd == null) {
            return true;
        }
        if (aProd != null && aNotherProd == null) {
            return false;
        }
        if (aProd == null && aNotherProd != null) {
            return false;
        }
        return aProd.getID().equals(aNotherProd.getID()) && aProd.getVersion().compareTo(aNotherProd.getVersion()) == 0;
    }

    private boolean theSamePackage(Package aPkg, Package aNotherPkg) {
        if (aPkg == null && aNotherPkg == null) {
            return true;
        }
        return aPkg != null && aNotherPkg != null && aPkg.getName().equals(aNotherPkg.getName()) && aPkg.getVersion().compareTo(aNotherPkg.getVersion()) == 0;
    }

    private boolean theSameSystemProduct(SystemProduct aProd, SystemProduct aNotherProd) {
        if (aProd == null && aNotherProd == null) {
            return true;
        }
        if (aProd != null && aNotherProd == null) {
            return false;
        }
        if (aProd == null && aNotherProd != null) {
            return false;
        }
        return aProd.getName().equals(aNotherProd.getName()) && aProd.getVersion().compareTo(aNotherProd.getVersion()) == 0;
    }

    public boolean equals(Object aOperation) {
        if (aOperation == null) {
            return false;
        }
        if (Operation.class != aOperation.getClass()) {
            return false;
        }
        return this.compareTo((Operation)aOperation);
    }

    public int hashCode() {
        int theCode = 18;
        theCode += this.gOperation.hashCode();
        if (this.gMediaPackage != null) {
            theCode += this.gMediaPackage.hashCode();
        } else if (this.gSystemPackage != null) {
            theCode += this.gSystemPackage.hashCode();
        } else if (this.gMediaProduct != null) {
            theCode += this.gMediaProduct.hashCode();
        } else if (this.gSystemProduct != null) {
            theCode += this.gSystemProduct.hashCode();
        }
        return theCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OPTYPE {
        INSTALL,
        UPGRADE,
        REPAIR,
        REMOVE,
        REGISTER,
        UNREGISTER,
        REREGISTER,
        CONFIGURE,
        UNCONFIGURE,
        MIGRATE,
        INSTALL_IMAGE_CONFIGURE,
        INSTALL_IMAGE_RESET;

    }
}

