/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusException;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.core.OrchestratorCommand;
import org.openinstaller.provider.platform.NativeSupportAttachException;
import org.openinstaller.provider.platform.PlatformCommand;
import org.openinstaller.provider.platform.PlatformToolkit;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemInterface
extends PlatformToolkit
implements ServiceProvider {
    public static final int BUF_SIZE = 5120;
    private PlatformToolkit gPlatformToolkit = null;
    private Properties gProperties = null;
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static final String BACKEND_PKGNAME = "org.openinstaller.provider.platform.backends";
    private boolean gNativeFilesExtracted = false;

    public void shutdown() {
    }

    public void receiveEvent(ControlBus aBus, BusEvent aEvent) {
    }

    public void receiveRequest(ControlBus aBus, BusRequest aReq, BusResponse aResp) {
        Object theResponseData = null;
        EnhancedException theEe = null;
        if (!this.gNativeFilesExtracted) {
            try {
                this.attach();
            }
            catch (NativeSupportAttachException theEx) {
                aResp.setException((Exception)((Object)theEx));
                return;
            }
        }
        if (!PlatformCommand.class.isInstance(aReq.getData())) {
            theEe = new EnhancedException("NOT_A_PLATFORM_CMD", new String[]{"request=" + aReq.toString()});
            aResp.setException((Exception)((Object)theEe));
            return;
        }
        PlatformCommand theCommand = (PlatformCommand)aReq.getData();
        try {
            switch (theCommand.getCommand()) {
                case GET_USABLE_SPACE: {
                    Object theData = theCommand.getData();
                    if (String.class.isInstance(theData)) {
                        String theDir = (String)theData;
                        try {
                            theResponseData = this.getUsableDiskSpace(theDir);
                            break;
                        }
                        catch (EnhancedException theException) {
                            aResp.setException((Exception)((Object)theException));
                            return;
                        }
                    }
                    aResp.setException((Exception)((Object)new EnhancedException("INVALID_REQUEST", new String[]{"request=" + aReq})));
                    break;
                }
                case GET_PHYSMEM: {
                    theResponseData = this.getPhysicalMemory();
                    break;
                }
                case GET_OS_PATCH_LEVEL: {
                    theResponseData = this.getOSPatchLevel();
                    break;
                }
                case GET_PATCHLIST: {
                    theResponseData = this.createPatchPresentList();
                    break;
                }
                case GET_PROCESSOR: {
                    theResponseData = this.getProcessorInfo();
                    break;
                }
                case GET_SWAP_SPACE: {
                    theResponseData = this.getSwapSpace();
                    break;
                }
                default: {
                    theEe = new EnhancedException("INVALID_CMD", new String[]{"request=" + theCommand.toString()});
                }
            }
        }
        catch (EnhancedException theEEx) {
            theEe = theEEx;
        }
        if (theEe == null) {
            aResp.setFinalResult(theResponseData);
        } else {
            aResp.setException((Exception)((Object)theEe));
        }
    }

    public String getName() {
        return "svc://platform/systeminterface";
    }

    public PlatformToolkit getPlatformToolkit() {
        return this.gPlatformToolkit;
    }

    public void attach() throws NativeSupportAttachException {
        byte[] theBuf = new byte[5120];
        String theNativeFileSpec = this.gProperties.getProperty("Native-Files");
        LOGGER.log(Level.FINE, "Native-Files property:" + theNativeFileSpec);
        File theLibDir = new File(this.findNativeFileDir());
        LOGGER.log(Level.FINE, "Native-Files lib dir:" + theLibDir);
        if (theNativeFileSpec != null && theNativeFileSpec.trim().length() > 0) {
            for (String theFile : theNativeFileSpec.split(",")) {
                File theFileFile = File.separatorChar != '/' ? new File(theFile.trim().replace('/', File.separatorChar)) : new File(theFile.trim());
                File theOutDir = new File(theLibDir.getAbsolutePath());
                if (theFileFile.getParent() != null) {
                    theOutDir = new File(theOutDir, theFileFile.getParent());
                }
                File theTargetFile = new File(theOutDir, theFileFile.getName());
                if (!theOutDir.exists() && !theOutDir.mkdirs()) {
                    throw new NativeSupportAttachException("CANT_CREATE_DIRECTORY", "dir=" + theOutDir.getAbsolutePath());
                }
                try {
                    String theResource = File.separatorChar != '/' ? "/" + theFileFile.getPath().replace(File.separatorChar, '/') : "/" + theFileFile.getPath();
                    InputStream theFileContent = this.gPlatformToolkit.getClass().getResourceAsStream(theResource);
                    if (theFileContent == null) {
                        LOGGER.log(Level.SEVERE, "CANT_READ_FILE_CONTENT", "file=" + theFileFile.getPath());
                        continue;
                    }
                    FileOutputStream theOutFileStream = new FileOutputStream(theTargetFile);
                    int theSize = theFileContent.read(theBuf);
                    while (theSize != -1) {
                        ((OutputStream)theOutFileStream).write(theBuf, 0, theSize);
                        theSize = theFileContent.read(theBuf);
                    }
                    theFileContent.close();
                    ((OutputStream)theOutFileStream).close();
                }
                catch (IOException theIoe) {
                    throw new NativeSupportAttachException("CANT_WRITE_NATIVE_FILE", theIoe, "file=" + theTargetFile.getAbsolutePath());
                }
            }
            theLibDir.deleteOnExit();
            this.markDelete(theLibDir);
        }
        this.gNativeFilesExtracted = true;
        if (this.gPlatformToolkit != null) {
            this.setNativeFileDir(theLibDir.getAbsolutePath());
        }
    }

    @Override
    public void setNativeFileDir(String aDirName) {
        this.gPlatformToolkit.setNativeFileDir(aDirName);
    }

    private void markDelete(File aDirToDelete) {
        for (File theFile : aDirToDelete.listFiles()) {
            if (theFile.isDirectory()) {
                theFile.deleteOnExit();
                this.markDelete(theFile);
                continue;
            }
            theFile.deleteOnExit();
        }
    }

    private URL[] findPlatformURLs(String aSearchPath) {
        ArrayList<URL> thePlatformURLs = new ArrayList<URL>();
        StringTokenizer thePathTokenizer = new StringTokenizer(aSearchPath, File.pathSeparator);
        while (thePathTokenizer.hasMoreTokens()) {
            String[] theDiscoveredJars;
            String theNextToken = thePathTokenizer.nextToken();
            File theNextTokenDir = new File(theNextToken);
            if (!theNextTokenDir.exists() || !theNextTokenDir.isDirectory()) {
                LOGGER.log(Level.FINE, "DOESNT_EXIST", theNextTokenDir);
                continue;
            }
            for (String thePotentialProviderPath : theDiscoveredJars = theNextTokenDir.list(new FilenameFilter(){

                public boolean accept(File aDir, String aName) {
                    return aName.endsWith(".jar");
                }
            })) {
                String theProviderAttributeValue;
                Attributes theMainAttributes;
                Manifest theManifest;
                File theJar = new File(theNextTokenDir, thePotentialProviderPath);
                if (!theJar.exists() || !theJar.isFile()) {
                    LOGGER.log(Level.INFO, "CANT_READ", theJar);
                    continue;
                }
                try {
                    JarFile theJarFile = new JarFile(theJar);
                    theManifest = theJarFile.getManifest();
                }
                catch (IOException theIoe) {
                    LOGGER.log(Level.WARNING, "CANT_READ_FILE", theJar + theIoe.getMessage());
                    continue;
                }
                if (theManifest == null || (theMainAttributes = theManifest.getMainAttributes()) == null || (theProviderAttributeValue = theMainAttributes.getValue("Platform-Providers")) == null) continue;
                try {
                    thePlatformURLs.add(theJar.toURI().toURL());
                }
                catch (MalformedURLException theMue) {
                    LOGGER.log(Level.WARNING, "CANT_CONVERT_TO_URL", theJar.getName() + theMue.getMessage());
                }
            }
        }
        return thePlatformURLs.toArray(new URL[0]);
    }

    private String findNativeFileDir() {
        File theTempDir = new File(System.getProperty("java.io.tmpdir"));
        File theRandomDir = new File(theTempDir, "." + Math.random());
        while (theRandomDir.exists()) {
            theRandomDir = new File(theTempDir, "." + Math.random());
        }
        return theRandomDir.getAbsolutePath();
    }

    public void init(ControlBus aBus) throws BusException {
        try {
            BusRequest theRequest = new BusRequest("EngineConfigRequest", (Object)new EngineConfigCommand(EngineConfigCommand.COMMAND.GET_CONFIG, (Object)EngineConfigItem.PLATFORM_PLUGIN_PATH));
            BusResponse theResponse = aBus.publishRequest(theRequest, "svc://general/EngineConfig");
            String thePath = (String)theResponse.getResult();
            if (thePath != null) {
                URL[] thePlatURLs;
                for (URL thePlatformJarURL : thePlatURLs = this.findPlatformURLs(thePath)) {
                    BusRequest theURLReq = new BusRequest("EngineConfigRequest", (Object)new OrchestratorCommand(OrchestratorCommand.COMMAND.ADD_CLASS_URL, (Object)thePlatformJarURL));
                    aBus.publishRequest(theURLReq, "svc://general/orchestrator");
                }
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            theEIAEx.addContext("CANNOT_INITIALIZE_SYS_INTERFACE", new String[0]);
            LOGGER.log(Level.WARNING, "BUS_REQUEST_FAILED", theEIAEx);
        }
        String theOsName = System.getProperty("os.name");
        theOsName = Platform.getOSNameForString((String)theOsName).getValue();
        String thePlatformName = theOsName.substring(0, 1).toUpperCase() + theOsName.substring(1, theOsName.length()).toLowerCase();
        thePlatformName = thePlatformName.replace(' ', '_');
        String theToolkitClassName = "org.openinstaller.provider.platform.backends." + thePlatformName + "PlatformToolkit";
        Class<?> theToolkitClass = null;
        try {
            theToolkitClass = Class.forName(theToolkitClassName);
        }
        catch (ClassNotFoundException theCnfe) {
            LOGGER.log(Level.FINE, "Cannot load toolkit", theCnfe);
        }
        if (theToolkitClass == null) {
            LOGGER.log(Level.FINE, "DOES_NOT_EXIST", theToolkitClassName);
            if (new Platform(Platform.OSType.UNIX, Platform.OSName.UNDEFINED, Platform.Arch.UNDEFINED).isCompatible()) {
                theToolkitClassName = "org.openinstaller.provider.platform.backends.UnixPlatformToolkit";
            } else if (new Platform(Platform.OSType.WINDOWS, Platform.OSName.UNDEFINED, Platform.Arch.UNDEFINED).isCompatible()) {
                theToolkitClassName = "org.openinstaller.provider.platform.backends.WindowsPlatformToolkit";
            }
        }
        try {
            theToolkitClass = Class.forName(theToolkitClassName);
        }
        catch (ClassNotFoundException theCnfe) {
            LOGGER.log(Level.FINE, "CANT_INSTANTIATE", theToolkitClassName + theCnfe.getMessage());
        }
        if (theToolkitClass == null) {
            theToolkitClassName = "org.openinstaller.provider.platform.backends.JavaPlatformToolkit";
        }
        LOGGER.log(Level.FINE, "INSTANTIATING" + theToolkitClassName);
        try {
            theToolkitClass = Class.forName(theToolkitClassName);
        }
        catch (ClassNotFoundException theCnfe) {
            LOGGER.log(Level.SEVERE, "CANT_LOAD_CLASS", theToolkitClassName + theCnfe.getMessage());
        }
        if (theToolkitClass == null) {
            throw new BusException("CANNOT_INIT_PLATFORM", new String[]{"class=" + theToolkitClassName});
        }
        try {
            Class[] theClass = new Class[]{};
            Constructor<?> theConstructor = theToolkitClass.getConstructor(theClass);
            this.gPlatformToolkit = (PlatformToolkit)theConstructor.newInstance(new Object[0]);
        }
        catch (Error theEx) {
            throw new BusException("CANNOT_INIT_PLATFORM", (Throwable)theEx, new String[]{"class=" + theToolkitClassName});
        }
        catch (Exception theEx) {
            throw new BusException("CANNOT_INIT_PLATFORM", (Throwable)theEx, new String[]{"class=" + theToolkitClassName});
        }
        this.gProperties = new Properties();
        String thePropName = "/" + theToolkitClassName.replace('.', '/') + ".properties";
        InputStream thePropStream = theToolkitClass.getResourceAsStream(thePropName);
        if (thePropStream == null) {
            LOGGER.log(Level.INFO, "NATIVE_PROPERTY_NOT_READ", thePropName);
        } else {
            try {
                this.gProperties.load(thePropStream);
                thePropStream.close();
            }
            catch (IOException theIoe) {
                LOGGER.log(Level.WARNING, "CANT_LOAD_PROPERTIES", theToolkitClassName + theIoe.getMessage());
            }
        }
        LOGGER.log(Level.FINE, "Read Properties: " + this.gProperties);
        try {
            this.attach();
        }
        catch (Exception theEx) {
            throw new BusException("CANNOT_INIT_PLATFORM", (Throwable)theEx, new String[]{"class=" + theToolkitClassName});
        }
    }

    @Override
    public String getOSPatchLevel() throws EnhancedException {
        if (this.gPlatformToolkit != null) {
            return this.gPlatformToolkit.getOSPatchLevel();
        }
        return "";
    }

    @Override
    public ArrayList<String> createPatchPresentList() {
        try {
            if (this.gPlatformToolkit != null) {
                return this.gPlatformToolkit.createPatchPresentList();
            }
            return null;
        }
        catch (Exception theException) {
            LOGGER.log(Level.SEVERE, "CANT_CREATEPATCH", this.getClass() + theException.toString());
            return null;
        }
    }

    @Override
    public String checkPatchInstalled(String aId) {
        try {
            if (this.gPlatformToolkit != null) {
                return this.gPlatformToolkit.checkPatchInstalled(aId);
            }
        }
        catch (Exception theException) {
            LOGGER.log(Level.SEVERE, "CANT_CHECKPATCH", this.getClass() + theException.toString());
        }
        return "";
    }

    @Override
    public String[] getProcessorInfo() throws EnhancedException {
        if (this.gPlatformToolkit != null) {
            return this.gPlatformToolkit.getProcessorInfo();
        }
        return new String[0];
    }

    @Override
    public long getSwapSpace() throws EnhancedException {
        if (this.gPlatformToolkit != null) {
            return this.gPlatformToolkit.getSwapSpace();
        }
        return 0L;
    }

    @Override
    public long getPhysicalMemory() throws EnhancedException {
        if (this.gPlatformToolkit != null) {
            return this.gPlatformToolkit.getPhysicalMemory();
        }
        return 0L;
    }

    @Override
    public long getUsableDiskSpace(String aPath) throws EnhancedException {
        if (this.gPlatformToolkit != null) {
            return this.gPlatformToolkit.getUsableDiskSpace(aPath);
        }
        return 0L;
    }
}

