/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.bus.BusEvent;
import org.openinstaller.bus.BusRequest;
import org.openinstaller.bus.BusResponse;
import org.openinstaller.bus.ControlBus;
import org.openinstaller.bus.ServiceProvider;
import org.openinstaller.core.EngineConfigCommand;
import org.openinstaller.core.EngineConfigItem;
import org.openinstaller.core.EngineConfigSetting;
import org.openinstaller.core.IllegalConfigException;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;
import org.openinstaller.util.Msg;
import org.openinstaller.util.Platform;
import org.openinstaller.util.substitution.SubstitutionEngine;

public final class EngineConfigManager
implements ServiceProvider {
    public static final Map<EngineConfigItem, String> gDefaults = new HashMap<EngineConfigItem, String>(){
        {
            this.put(EngineConfigItem.PROVIDER_PATH, "");
            this.put(EngineConfigItem.DISPLAY_MODE, "GUI");
            this.put(EngineConfigItem.LOG_LEVEL, "INFO");
            this.put(EngineConfigItem.LOGS_LOCATION, ":[component:InstallHome:directory:INSTALL_HOME]/var/install/logs/:[engine:Default-Product-ID]");
            this.put(EngineConfigItem.CONFIG_STATE, ":[component:InstallHome:directory:INSTALL_HOME]/var/install/config/:[engine:Default-Product-ID]");
            this.put(EngineConfigItem.MEDIA_LOCATION, "file:/var/install/contents/:[engine:Default-Product-ID]/");
            this.put(EngineConfigItem.PKG_FORMAT, Platform.getDefaultPackageFormat());
        }
    };
    private final Hashtable<EngineConfigItem, String> gConfig = new Hashtable();
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());

    @Override
    public void init(ControlBus aBus) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void receiveEvent(ControlBus aBus, BusEvent aEvt) {
    }

    @Override
    public void receiveRequest(ControlBus aBus, BusRequest aRequest, BusResponse aResp) {
        if (!EngineConfigCommand.class.isInstance(aRequest.getData())) {
            String theException = Msg.get(this.getClass(), "NOT_CONFIG_CMD", new Object[0]);
            aResp.setException(new InvalidArgumentException(aRequest + theException, new String[0]));
            return;
        }
        EngineConfigCommand theCommand = (EngineConfigCommand)aRequest.getData();
        switch (theCommand.getCommand()) {
            case GET_CONFIG: {
                if (!EngineConfigItem.class.isInstance(theCommand.getData())) {
                    String theException = Msg.get(this.getClass(), "NOT_CONFIG_ITEM", new Object[0]);
                    aResp.setException(new InvalidArgumentException(aRequest + theException, new String[0]));
                    return;
                }
                try {
                    String theResult = this.getConfig((EngineConfigItem)((Object)theCommand.getData()));
                    aResp.setFinalResult(theResult);
                    break;
                }
                catch (EnhancedException theEx) {
                    aResp.setException(theEx);
                    return;
                }
            }
            case SET_CONFIG: {
                if (!EngineConfigSetting.class.isInstance(theCommand.getData())) {
                    aResp.setException(new InvalidArgumentException(theCommand.getData() + Msg.get(this.getClass(), "NOT_CONFIG_SET", new Object[0]), new String[0]));
                    return;
                }
                EngineConfigItem theItemToSet = ((EngineConfigSetting)theCommand.getData()).getConfigItem();
                String theSetting = ((EngineConfigSetting)theCommand.getData()).getSetting();
                try {
                    this.setConfig(theItemToSet, theSetting);
                }
                catch (InvalidArgumentException theEx) {
                    aResp.setException(theEx);
                }
                break;
            }
            default: {
                aResp.setException(new InvalidArgumentException(theCommand + Msg.get(this.getClass(), "NOT_CONFIG_SET", new Object[0]), new String[0]));
            }
        }
    }

    @Override
    public String getName() {
        return "svc://general/EngineConfig";
    }

    public void setConfig(EngineConfigItem aKey, String aVal) throws InvalidArgumentException {
        if (aVal == null) {
            throw new InvalidArgumentException(Msg.get(this.getClass(), "NOT_CONFIG_CMD", new Object[0]), new String[0]);
        }
        this.gConfig.put(aKey, aVal);
    }

    public String getConfig(EngineConfigItem aKey) throws EnhancedException {
        String theVal = this.gConfig.get((Object)aKey);
        if (theVal == null) {
            return null;
        }
        try {
            return SubstitutionEngine.resolve(theVal);
        }
        catch (Throwable theEx) {
            return theVal;
        }
    }

    public void loadDefaultConfig() throws EnhancedException {
        for (Map.Entry<EngineConfigItem, String> theEntry : gDefaults.entrySet()) {
            this.setConfig(theEntry.getKey(), theEntry.getValue());
        }
        String theHomeDir = System.getProperty("user.home");
        try {
            this.setConfig(EngineConfigItem.PROVIDER_PATH, "");
            if (theHomeDir != null) {
                this.setConfig(EngineConfigItem.PROVIDER_PATH, theHomeDir);
            }
        }
        catch (InvalidArgumentException theEIAEx) {
            throw new EnhancedException("CANNOT_SET_PROVIDER_PATH", (Throwable)theEIAEx, new String[0]);
        }
        StringBuffer theClassPath = new StringBuffer(System.getProperty("java.class.path"));
        theClassPath.append(File.pathSeparator).append(theHomeDir);
        StringTokenizer theClassPathTokenizer = new StringTokenizer(theClassPath.toString(), File.pathSeparator);
        while (theClassPathTokenizer.hasMoreTokens()) {
            File theConfigFile;
            File theBaseClassPathFile = new File(theClassPathTokenizer.nextToken());
            if (!theBaseClassPathFile.isDirectory() || !(theConfigFile = new File(theBaseClassPathFile, "install-config.properties")).isFile()) continue;
            try {
                this.mergeConfig(new URL("file:" + theConfigFile));
            }
            catch (EnhancedException theEe) {
                LOGGER.log(Level.WARNING, "CANT_READ", new String[]{theConfigFile.getName(), theEe.getMessage()});
            }
            catch (MalformedURLException theMue) {
                LOGGER.log(Level.WARNING, "CANT_READ", theMue.getMessage());
            }
        }
    }

    public void mergeConfig(URL aURLToMerge) throws EnhancedException {
        try {
            InputStream theURLStream = aURLToMerge.openStream();
            Properties theTempProperties = new Properties();
            theTempProperties.load(theURLStream);
            for (Map.Entry<Object, Object> theEntry : theTempProperties.entrySet()) {
                String theTempKey = (String)theEntry.getKey();
                EngineConfigItem theTempConfigItem = EngineConfigItem.getConfigItem(theTempKey);
                this.setConfig(theTempConfigItem, theTempProperties.getProperty(theTempKey));
            }
        }
        catch (IOException theIoe) {
            throw new EnhancedException("CANT_OPEN_OR_LOAD_STREAM", (Throwable)theIoe, new String[0]);
        }
        catch (IllegalConfigException theEx) {
            theEx.addContext("ERROR_MERGING_SETTINGS", new String[0]);
            throw theEx;
        }
    }
}

