/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Version
implements Comparable<Version> {
    private final List<String> gElements = new ArrayList<String>();
    private final String gOrigString;
    public static final Version INFINITY = new Version(null);
    private final boolean gInfinity;

    public Version(String aVersion) {
        String[] theSubStrings;
        this.gOrigString = aVersion;
        if (aVersion == null) {
            this.gInfinity = true;
            return;
        }
        this.gInfinity = false;
        for (String theSubString : theSubStrings = aVersion.split("[\\s\\p{Punct}]")) {
            String[] theSubElements;
            for (String theSubElement : theSubElements = this.splitNumbers(theSubString)) {
                this.gElements.add(theSubElement);
            }
        }
        if (this.gElements.isEmpty()) {
            throw new NumberFormatException("\"" + aVersion + "\" contains no aVersion elements");
        }
    }

    private String[] splitNumbers(String aVersionSpec) {
        ArrayList<String> theElements = new ArrayList<String>();
        StringBuilder theNonNumSubString = new StringBuilder();
        StringBuilder theNumberSubString = new StringBuilder();
        Character thePreviousChar = null;
        for (int theIndex = 0; theIndex < aVersionSpec.length(); ++theIndex) {
            Character theNextChar = Character.valueOf(aVersionSpec.charAt(theIndex));
            if (thePreviousChar == null) {
                if (Character.isDigit(theNextChar.charValue())) {
                    theNumberSubString.append(theNextChar);
                } else {
                    theNonNumSubString.append(theNextChar);
                }
            } else if (Character.isDigit(theNextChar.charValue()) && Character.isDigit(thePreviousChar.charValue())) {
                theNumberSubString.append(theNextChar);
            } else if (Character.isDigit(theNextChar.charValue()) && !Character.isDigit(thePreviousChar.charValue())) {
                theElements.add(theNonNumSubString.toString());
                theNonNumSubString = new StringBuilder();
                theNumberSubString.append(theNextChar);
            } else if (!Character.isDigit(theNextChar.charValue()) && Character.isDigit(thePreviousChar.charValue())) {
                theElements.add(theNumberSubString.toString());
                theNumberSubString = new StringBuilder();
                theNonNumSubString.append(theNextChar);
            } else {
                theNonNumSubString.append(theNextChar);
            }
            thePreviousChar = theNextChar;
        }
        if (!theNonNumSubString.toString().equals("")) {
            theElements.add(theNonNumSubString.toString());
        }
        if (!theNumberSubString.toString().equals("")) {
            theElements.add(theNumberSubString.toString());
        }
        return theElements.toArray(new String[0]);
    }

    @Override
    public int compareTo(Version aVersion) {
        if (aVersion == null) {
            return 1;
        }
        if (aVersion.gInfinity && this.gInfinity) {
            return 0;
        }
        if (aVersion.gInfinity && !this.gInfinity) {
            return -1;
        }
        if (!aVersion.gInfinity && this.gInfinity) {
            return 1;
        }
        return this.compareElements(this.gElements, aVersion.gElements);
    }

    private int compareElements(List<String> aElementSet, List<String> aDifferentElementSet) {
        Iterator<String> theElements = aElementSet.iterator();
        Iterator<String> theOtherElements = aDifferentElementSet.iterator();
        while (theElements.hasNext() && theOtherElements.hasNext()) {
            int theDiff;
            String theElement = theElements.next();
            String theOtherElement = theOtherElements.next();
            if (!(this.isNumber(theElement) && this.isNumber(theOtherElement) ? (theDiff = Integer.parseInt(theElement) - Integer.parseInt(theOtherElement)) != 0 : (theDiff = theElement.compareTo(theOtherElement)) != 0)) continue;
            return theDiff;
        }
        if (theOtherElements.hasNext()) {
            return -1;
        }
        if (theElements.hasNext()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object aVersion) {
        if (aVersion == null) {
            return false;
        }
        if (aVersion.getClass() != Version.class) {
            return false;
        }
        return this.compareTo((Version)aVersion) == 0;
    }

    public int hashCode() {
        int theCode = 0;
        for (String theElement : this.gElements) {
            theCode += theElement.hashCode();
        }
        return theCode;
    }

    private boolean isNumber(String aPossibleNumber) {
        try {
            Integer.parseInt(aPossibleNumber);
            return true;
        }
        catch (NumberFormatException theEx) {
            return false;
        }
    }

    public String toString() {
        if (this.gInfinity) {
            return "INFINITY";
        }
        return this.gOrigString;
    }

    public static String encode(Version aVersion) {
        if (aVersion.gInfinity) {
            return "INFINITY";
        }
        return aVersion.gOrigString;
    }
}

