/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.WebStartUtils;

public class BgImagePanel
extends JPanel {
    private transient Image gImage;
    private static final Logger LOGGER = Logger.getLogger(BgImagePanel.class.getName());

    public BgImagePanel() {
        LOGGER.finest("BGImagePanel() called by " + ClassUtils.getCallingClassName() + "?" + ClassUtils.getCallingMethodName());
        this.setDoubleBuffered(true);
    }

    public BgImagePanel(String aPathOfImage) {
        this();
        LOGGER.finest("BGImagePanel(String " + aPathOfImage + ") called by " + ClassUtils.getCallingClassName() + "?" + ClassUtils.getCallingMethodName());
        this.setBgImage(aPathOfImage);
    }

    public BgImagePanel(Image aImage) {
        this();
        LOGGER.finest("BGImagePanel(Image " + aImage + ") called by " + ClassUtils.getCallingClassName() + "?" + ClassUtils.getCallingMethodName());
        this.setBgImage(aImage);
    }

    public final void setBgImage(String aPathOfImage) {
        try {
            LOGGER.finest("BGImagePanel.setBgImage(String " + aPathOfImage + ") called by " + ClassUtils.getCallingClassName() + "?" + ClassUtils.getCallingMethodName());
            URL theURL = WebStartUtils.IS_WEBSTART ? WebStartUtils.getURL(aPathOfImage) : this.getClass().getResource(aPathOfImage);
            this.gImage = ImageIO.read(theURL);
            this.setMinimumSize(new Dimension(this.getImageWidth(), this.getImageHeight()));
            this.setPreferredSize(new Dimension(this.getImageWidth(), this.getImageHeight()));
        }
        catch (Exception theEx) {
            LOGGER.log(Level.SEVERE, "Not able to create the image", theEx);
        }
    }

    public final void setBgImage(Image aImage) {
        LOGGER.finest("BGImagePanel.setBgImage(Image " + aImage + ") called by " + ClassUtils.getCallingClassName() + "?" + ClassUtils.getCallingMethodName());
        this.gImage = aImage;
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (this.gImage != null) {
            g.drawImage(this.gImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    public final int getImageWidth() {
        return this.gImage.getWidth(null);
    }

    public final int getImageHeight() {
        return this.gImage.getHeight(null);
    }
}

