/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.openinstaller.util.ui.BgImagePanel;
import org.openinstaller.util.ui.ProgressBar;

public final class StandaloneSplash
extends JWindow
implements Runnable {
    private BgImagePanel gPanel = new BgImagePanel();
    private JLabel gDynText = new JLabel();
    private ProgressBar gProgBar = new ProgressBar();
    private File gTextFile;
    private static Logger gLogger;

    private StandaloneSplash() {
        gLogger = Logger.getLogger(StandaloneSplash.class.getName());
    }

    public StandaloneSplash(File aTextFile, Image aImage) {
        gLogger = Logger.getLogger(StandaloneSplash.class.getName());
        this.gTextFile = aTextFile;
        Image theImage = null;
        try {
            theImage = aImage;
            this.gPanel.setBgImage(theImage);
            this.splash();
            if (this.gTextFile != null) {
                new Thread(this).start();
            }
        }
        catch (Exception ex) {
            gLogger.log(Level.FINE, "An error occurred during initialization !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        StandaloneSplash standaloneSplash = this;
        synchronized (standaloneSplash) {
            BufferedReader theReader = null;
            try {
                theReader = new BufferedReader(new FileReader(this.gTextFile));
                String theText = "";
                while (!"-END-".equalsIgnoreCase(theText)) {
                    theText = theReader.readLine();
                    Thread.sleep(2000L);
                    this.setDynamicText(theText);
                }
            }
            catch (FileNotFoundException ex) {
                gLogger.log(Level.FINE, "The file could not be found!", ex);
            }
            catch (IOException ex) {
                gLogger.log(Level.FINE, "Error when trying to read from the file!", ex);
            }
            catch (InterruptedException ex) {
                gLogger.log(Level.FINE, "Thread interrupted...", ex);
            }
        }
    }

    final void splash() throws Exception {
        int iWidth = this.gPanel.getImageWidth();
        int iHeight = this.gPanel.getImageHeight();
        this.setLayout(null);
        this.setSize(iWidth, iHeight);
        this.add((Component)this.gPanel, null);
        this.gPanel.setBorder(new LineBorder(Color.BLACK));
        this.gPanel.setLayout(null);
        this.gPanel.setBounds(0, 0, iWidth, iHeight);
        this.gPanel.add(this.gDynText);
        this.gProgBar.setBorderPainted(true);
        this.gPanel.add(this.gProgBar);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle window = this.getBounds();
        this.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
        this.setDynamicTextBounds(227, iHeight - 120, iWidth - 237, this.getDynamicTextFontHeight() + 2);
        this.setProgressBounds(227, iHeight - 100, iWidth - 237, 4);
        this.setIndeterminateProgress(true);
        this.setProgressBackground(Color.WHITE);
        this.setProgressForeground(Color.BLUE);
        this.setProgressMax(100);
        this.setScreenVisible(true);
    }

    public final void setDynamicText(String text) {
        String dText = text;
        this.gDynText.setText(dText);
    }

    public final void setDynamicTextFont(Font f) {
        this.gDynText.setFont(f);
    }

    public final void setDynamicTextColor(Color c) {
        this.gDynText.setForeground(c);
    }

    public final void setDynamicTextBounds(int aX, int aY, int aWidth, int aHeight) {
        this.gDynText.setBounds(aX, aY, aWidth, aHeight);
    }

    public final int getDynamicTextFontHeight() {
        return this.gDynText.getFontMetrics(this.gDynText.getFont()).getHeight();
    }

    public final void setProgressBackground(Color c) {
        this.gProgBar.setBackground(c);
    }

    public final void setProgressBounds(int aX, int aY, int aWidth, int aHeight) {
        this.gProgBar.setBounds(aX, aY, aWidth, aHeight);
    }

    public final void setProgressForeground(Color c) {
        this.gProgBar.setForeground(c);
    }

    public final void setProgressMax(int maxProgress) {
        this.gProgBar.setMaximum(maxProgress);
    }

    public final void setProgressBorder(Border aBorder) {
        this.gProgBar.setBorder(aBorder);
    }

    public final void setIndeterminateProgress(boolean aBoolean) {
        this.gProgBar.setIndeterminate(aBoolean);
    }

    public final void setProgress(int progress) {
        final int theProgress = progress;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandaloneSplash.this.gProgBar.setValue(theProgress);
            }
        });
    }

    public final void setProgress(String message, int progress) {
        int theProgress = progress;
        String theMessage = message;
        this.setProgress(progress);
        this.gProgBar.setValue(theProgress);
        this.setMessage(theMessage);
    }

    private void setMessage(String message) {
        String fMsg = message;
        if (fMsg == null) {
            fMsg = "";
            this.gProgBar.setStringPainted(false);
        } else {
            this.gProgBar.setStringPainted(true);
        }
        this.gProgBar.setString(fMsg);
    }

    public final void setScreenVisible(boolean b) {
        this.setVisible(b);
    }
}

