/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.provider.dependency.legacy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.provider.dependency.MediaProduct;
import org.openinstaller.provider.dependency.PlatformInstUnit;
import org.openinstaller.sims.Package;
import org.openinstaller.sims.SystemProduct;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.Platform;
import org.openinstaller.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyUtil {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private static List<SystemProduct> gSIMSLegacyProducts = new ArrayList<SystemProduct>();

    private LegacyUtil() {
    }

    public static List<SystemProduct> createSIMSProducts(List<MediaProduct> aLegacyProducts) throws EnhancedException {
        ArrayList<SystemProduct> theLegacySIMSProducts = new ArrayList<SystemProduct>();
        try {
            for (MediaProduct theHybridProduct : aLegacyProducts) {
                SystemProduct theLegacyProduct = LegacyUtil.createProduct(theHybridProduct);
                if (theLegacyProduct == null) continue;
                theLegacySIMSProducts.add(theLegacyProduct);
            }
        }
        catch (EnhancedException theEEx) {
            theEEx.addContext("CANNOT_CREATE_LEGACY_SIMS_PRODUCT", new String[0]);
            throw theEEx;
        }
        return theLegacySIMSProducts;
    }

    public static SystemProduct createProduct(MediaProduct aProduct) throws EnhancedException {
        if (aProduct == null) {
            LOGGER.finest("No HCETPNA Object found to create a SIMS Product");
            return null;
        }
        Platform theCurrentPlatform = Platform.getCurrentPlatform();
        SystemProduct theProd = new SystemProduct(aProduct.getID(), new Version(aProduct.getVersionStr()), "instance0", aProduct.getName());
        theProd.setRelease(new Version(aProduct.getRelease(theCurrentPlatform)));
        LOGGER.log(Level.FINE, "@ Legacy Product : " + theProd.toString());
        LOGGER.fine("@ Legacy Dependencies: " + aProduct.getDependencies());
        for (MediaProduct theDep : aProduct.getDependencies()) {
            if (theDep == null) continue;
            SystemProduct theLegacyDep = new SystemProduct(theDep.getID(), new Version(theDep.getVersionStr()), "instance0", theDep.getName());
            theProd.addRequiredProduct(theLegacyDep);
            LOGGER.fine("Added discovered product.  New set: " + theProd.getRequiredProducts());
        }
        LOGGER.fine("Legacy Features:" + aProduct.getFeatures());
        Set<MediaProduct> theFeatures = aProduct.getFeatures();
        if (!theFeatures.isEmpty()) {
            if (aProduct.isUpgradeAll()) {
                theProd.setUpgradeAll(true);
            }
            for (MediaProduct theFeat : theFeatures) {
                if (theFeat == null) continue;
                SystemProduct theLegacyFeat = new SystemProduct(theFeat.getID(), theFeat.getVersion(), "instance0", theFeat.getName());
                LOGGER.fine("Legacy Feature: " + theLegacyFeat);
                theProd.addContainedProduct(theLegacyFeat);
                LOGGER.fine("Added legacy feature as contained prod. new set: " + theProd.getContainedProducts());
            }
        }
        LOGGER.finer("@ Adding Legacy Pkgs: " + aProduct.getCoreInstallableUnits(theCurrentPlatform));
        ArrayList<PlatformInstUnit> thePlatPkgs = new ArrayList<PlatformInstUnit>();
        thePlatPkgs.addAll(aProduct.getCoreInstallableUnits(theCurrentPlatform));
        thePlatPkgs.addAll(aProduct.getLocalizedInstallableUnits(theCurrentPlatform));
        for (PlatformInstUnit thePlatPkg : thePlatPkgs) {
            if (thePlatPkg == null) continue;
            Version thePkgVer = null;
            thePkgVer = thePlatPkg.getIU().getVersion() != null ? new Version(thePlatPkg.getIU().getVersion()) : aProduct.getVersion();
            Package thePkg = new Package(thePlatPkg.getIU().getCoreInstallableUnitName(), thePkgVer, "instance0");
            if (thePlatPkg.getIU().getOverwrite()) {
                thePkg.setOverwriteAllowed(true);
            }
            if (thePlatPkg.getIU().isCritical()) {
                LOGGER.finest("@ Critical flag set for legacy product = " + theProd.getID());
                theProd.setCritical(true);
            }
            theProd.addContainedPackage(thePkg);
            LOGGER.fine("Added discovered pkg as contained pkg: new set: " + theProd.getContainedPackages());
        }
        return theProd;
    }
}

