/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.core;

import org.openinstaller.core.IllegalConfigException;

public enum EngineConfigItem {
    INSTALLABLE_UNIT_PATH("Installable-Unit-Path"),
    PROVIDER_PATH("Provider-Path"),
    PLATFORM_PLUGIN_PATH("Platform-Plugin-Path"),
    MEDIA_LOCATION("Media-Location"),
    LOGS_LOCATION("Logs-Location"),
    LOG_LEVEL("Log-Level"),
    ANSWER_FILES("Answer-Files"),
    ALTERNATE_ROOT("Alternate-Root"),
    SIMS_DOMAIN("SIMS-Domain"),
    SIMS_DOMAIN_PATH("SIMS-Domain-Path"),
    INIT_CONFIG_LOCATIONS("Init-Config-Locations"),
    DEFAULT_PRODUCT_ID("Default-Product-ID"),
    DRY_RUN_FILE("Dry-Run-File"),
    CONFIG_STATE("Config-State"),
    PROCESSING_MODE("Processing-Mode"),
    DISPLAY_MODE("Display-Mode"),
    UI_OPTIONS("UI-Options"),
    NO_UPGRADE("No-Upgrade"),
    PKG_FORMAT("Pkg-Format"),
    EXCLUDE_JVMS("Exclude-JVMs"),
    MERGE_CONFIG_DATA("Merge-Config-Data");

    private String gKey;

    private EngineConfigItem(String aKey) {
        this.gKey = aKey;
    }

    public String getString() {
        return this.gKey;
    }

    public static EngineConfigItem getConfigItem(String aValue) throws IllegalConfigException {
        for (EngineConfigItem theItem : EngineConfigItem.values()) {
            if (!theItem.getString().equals(aValue)) continue;
            return theItem;
        }
        IllegalConfigException theIEx = new IllegalConfigException("CANNOT_GET_ENGINE_CONFIG_ITEM");
        theIEx.addContext("UNDEFINED_ENGINE_CONFIG_ITEM", "config-item=" + aValue);
        throw theIEx;
    }
}

