/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;

public class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char PAD = '=';
    private static final int BYTE_MASK = 255;
    private static final int BYTE_SHIFT = 8;
    private static final int NIBBLE_SHIFT = 4;
    private static final int FIRST_GROUP_MASK = 0xFC0000;
    private static final int SECOND_GROUP_MASK = 258048;
    private static final int THIRD_GROUP_MASK = 4032;
    private static final int FORTH_GROUP_MASK = 63;
    private static final int FIRST_GROUP_SHIFT = 18;
    private static final int SECOND_GROUP_SHIFT = 12;
    private static final int THIRD_GROUP_SHIFT = 6;

    public static String toProperCase(String aString) {
        if (aString != null) {
            if (aString.length() == 0) {
                return "";
            }
            if (aString.length() == 1) {
                return aString.toUpperCase();
            }
            return aString.substring(0, 1).toUpperCase() + aString.substring(1);
        }
        LOGGER.log(Level.INFO, "NULL_STRING_PASSED");
        return null;
    }

    public static String escape(String aString, char aEsc) {
        return aString.replace(Character.toString(aEsc), "\\" + Character.toString(aEsc));
    }

    public static String unescape(String aString, char aEsc) {
        return aString.replace("\\" + Character.toString(aEsc), Character.toString(aEsc));
    }

    public static String wrap(String aString, int aWidth) {
        if (aString == null) {
            return null;
        }
        if (aWidth <= 0) {
            return aString;
        }
        int theLen = aString.length();
        StringBuffer theResult = new StringBuffer(theLen + theLen / aWidth);
        if (theLen < aWidth) {
            return aString;
        }
        int theIndex = 0;
        while (theIndex < theLen) {
            while (Character.isWhitespace(aString.charAt(theIndex)) && theIndex + 1 < theLen) {
                ++theIndex;
            }
            if (theLen - theIndex == 1) break;
            if (theLen - theIndex < aWidth) {
                theResult.append(aString.substring(theIndex));
                break;
            }
            String theNextLine = aString.substring(theIndex, theIndex + aWidth);
            int theExistingNL = theNextLine.indexOf(LINE_SEP);
            if (theExistingNL != -1) {
                theResult.append(theNextLine.substring(0, theExistingNL));
                theResult.append(LINE_SEP);
                theIndex += theExistingNL;
                continue;
            }
            int theLastSpace = theNextLine.lastIndexOf(32);
            if (theLastSpace != -1) {
                theResult.append(theNextLine.substring(0, theLastSpace));
                theResult.append(LINE_SEP);
                theIndex += theLastSpace;
                continue;
            }
            theResult.append(theNextLine);
            theIndex += aWidth;
        }
        return theResult.toString();
    }

    public static String encodeData(byte[] aData) {
        StringBuffer theResult = new StringBuffer((aData.length + 2) / 3 * 4);
        for (int theIndex = 0; theIndex < aData.length; theIndex += 3) {
            int theChunk;
            int theBytesLeft = aData.length - theIndex;
            if (theBytesLeft >= 3) {
                theChunk = (aData[theIndex] & 0xFF) << 8;
                theChunk = (theChunk | aData[theIndex + 1] & 0xFF) << 8;
                theResult.append(ALPHABET.charAt(((theChunk |= aData[theIndex + 2] & 0xFF) & 0xFC0000) >> 18));
                theResult.append(ALPHABET.charAt((theChunk & 0x3F000) >> 12));
                theResult.append(ALPHABET.charAt((theChunk & 0xFC0) >> 6));
                theResult.append(ALPHABET.charAt(theChunk & 0x3F));
                continue;
            }
            if (theBytesLeft == 1) {
                theChunk = (aData[theIndex] & 0xFF) << 4;
                theResult.append(ALPHABET.charAt((theChunk & 0xFC0) >> 6));
                theResult.append(ALPHABET.charAt(theChunk & 0x3F));
                theResult.append('=');
                theResult.append('=');
                continue;
            }
            if (theBytesLeft != 2) continue;
            theChunk = (aData[theIndex] & 0xFF) << 8;
            theChunk = (theChunk | aData[theIndex + 1] & 0xFF) << 2;
            theResult.append(ALPHABET.charAt((theChunk & 0x3F000) >> 12));
            theResult.append(ALPHABET.charAt((theChunk & 0xFC0) >> 6));
            theResult.append(ALPHABET.charAt(theChunk & 0x3F));
            theResult.append('=');
        }
        return theResult.toString();
    }

    public static String join(List<?> aList, String aDelim) {
        StringBuilder theResult = new StringBuilder();
        Iterator<?> theIt = aList.iterator();
        while (theIt.hasNext()) {
            theResult.append(theIt.next().toString());
            if (!theIt.hasNext()) continue;
            theResult.append(aDelim);
        }
        return theResult.toString();
    }
}

