#!/bin/ksh
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICE OR THIS HEADER.
# 
# Copyright 2006, 2007 Sun Microsystems, Inc. All rights reserved.
# Use is subject to license terms.
# 
# The contents of this file are subject to the terms of the Common Development
# and Distribution License("CDDL") (the "License"). You may not use this file
# except in compliance with the License.
# 
# You can obtain a copy of the License at https://openinstaller.dev.java.net/license.html
# or http://openinstaller.dev.java.net/license.txt . See the License for the
# specific language governing permissions and limitations under the License.
# 
# When distributing the Covered Code, include this CDDL Header Notice in each
# file and include the License file at http://openinstaller.dev.java.net/license.txt .
# If applicable, add the following below this CDDL Header, with the fields
# enclosed by brackets [] replaced by your own identifying information:
# "Portions Copyrighted [year] [name of copyright owner]"
# 
# ident "@(#)%Name% %Revision% %Date% SMI"
#

LC_ALL=C
LANG=C
export LC_ALL LANG
SCRIPT=`basename $0` # Shortname of this script
PLATFORM=`uname -s`  # Machine platform

#-------------------------------------------------------------------------------
# Retrieves the total swap space on linux in MB.
# input(s)  : none
# return(s) : swap space in MB
#-------------------------------------------------------------------------------
swapspace() {
  # -m converts to MB 
  /usr/bin/free -m | grep Swap | tr -s ' ' | cut -d" " -f2
}

#
# Make sure we are running on Linux Platform
#
if [ $PLATFORM != Linux ]
then
   echo "$SCRIPT runs only Linux systems" >&2
   exit 1
fi

swapspace
