/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openinstaller.util.ClassUtils;
import org.openinstaller.util.EnhancedException;
import org.openinstaller.util.InvalidArgumentException;

public class DataModel {
    private static final Logger LOGGER = Logger.getLogger(ClassUtils.getClassName());
    private Map<String, Object> gMap = Collections.synchronizedMap(new HashMap());
    private List<String> gKeys = Collections.synchronizedList(new ArrayList());
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DataModel() {
    }

    public DataModel(URL aLocation) throws Exception {
        this();
        this.load(aLocation);
    }

    public void clear() {
        this.gMap.clear();
        this.gKeys.clear();
    }

    public void dump() {
        List<String> theKeys = this.keys();
        Collections.sort(theKeys);
        LOGGER.finest("DataModel has " + theKeys.size() + " keys");
        for (String theKey : theKeys) {
            Object theValue = this.get(theKey);
            LOGGER.finest("DataModel " + theKey + " : " + theValue);
        }
    }

    public List<String> keys() {
        return this.gKeys;
    }

    public void put(String aKey, Object aValue) throws EnhancedException {
        if (aKey == null || aKey.equals("")) {
            throw new EnhancedException("NULL_OR_EMPTY_KEY", new String[0]);
        }
        if (aValue == null) {
            throw new EnhancedException("NULL_OR_EMPTY_VALUE", new String[0]);
        }
        String[] theParts = aKey.split("\\.");
        Map theLevel = this.gMap;
        for (int theIndex = 0; theIndex < theParts.length - 1; ++theIndex) {
            if (theParts[theIndex].length() == 0) {
                throw new EnhancedException("NULL_OR_EMPTY_KEY", aKey);
            }
            if (!theLevel.containsKey(theParts[theIndex])) {
                theLevel.put(theParts[theIndex], new HashMap());
            }
            theLevel = (Map)theLevel.get(theParts[theIndex]);
        }
        if (theLevel.containsKey(theParts[theParts.length - 1])) {
            Object theOldValue = theLevel.get(theParts[theParts.length - 1]);
            if (theOldValue instanceof List) {
                if (aValue instanceof List) {
                    ((List)theOldValue).addAll((List)aValue);
                } else {
                    ((List)theOldValue).add(aValue);
                }
            } else {
                ArrayList<Object> theNewList = new ArrayList<Object>();
                theNewList.add(theOldValue);
                if (aValue instanceof List) {
                    theNewList.addAll((List)aValue);
                } else {
                    theNewList.add(aValue);
                }
                theLevel.put(theParts[theParts.length - 1], theNewList);
            }
        } else {
            theLevel.put(theParts[theParts.length - 1], aValue);
        }
        if (!this.gKeys.contains(aKey)) {
            this.gKeys.add(aKey);
        }
    }

    public void putOld(String aKey, Object aValue) throws EnhancedException {
        if (null == aKey || "".equals(aKey)) {
            throw new EnhancedException("NULL_OR_EMPTY_KEY", new String[0]);
        }
        if (null == aValue) {
            throw new EnhancedException("NULL_OR_EMPTY_VALUE", new String[0]);
        }
        this.gMap.put(aKey, aValue);
        if (!this.gKeys.contains(aKey)) {
            this.gKeys.add(aKey);
        }
    }

    public void update(String aKey, Object aValue) throws Exception {
        this.delete(aKey);
        this.put(aKey, aValue);
    }

    public Object get(String aKey) {
        if (null == aKey) {
            return null;
        }
        try {
            String[] thePartsOfTheKey = aKey.split("\\.");
            Map theObjectOrMap = this.gMap;
            for (int thePartIndex = 0; thePartIndex < thePartsOfTheKey.length - 1; ++thePartIndex) {
                Object theTempObject = theObjectOrMap.get(thePartsOfTheKey[thePartIndex]);
                if (null == theTempObject) {
                    return null;
                }
                theObjectOrMap = (Map)theTempObject;
            }
            return theObjectOrMap.get(thePartsOfTheKey[thePartsOfTheKey.length - 1]);
        }
        catch (NullPointerException theNPE) {
            LOGGER.log(Level.WARNING, "CANNOT_GET_VALUE_FOR_KEY", theNPE);
            return null;
        }
    }

    public void delete(String aKey) {
        if (null == aKey) {
            return;
        }
        String[] thePartsOfTheKey = aKey.split("\\.");
        Map theObjectOrMap = this.gMap;
        for (int thePartIndex = 0; thePartIndex < thePartsOfTheKey.length - 1; ++thePartIndex) {
            Object theTempObject = theObjectOrMap.get(thePartsOfTheKey[thePartIndex]);
            if (null == theTempObject) {
                LOGGER.log(Level.WARNING, "ERROR_REACHING_KEY", new String[]{"key=" + aKey, "subkey=" + thePartsOfTheKey[thePartIndex]});
                return;
            }
            theObjectOrMap = (Map)theTempObject;
        }
        theObjectOrMap.remove(thePartsOfTheKey[thePartsOfTheKey.length - 1]);
    }

    public synchronized void load(URL aURL) throws Exception {
        LOGGER.fine("Loading datamodel from " + aURL);
        this.load(aURL.openStream());
    }

    private synchronized void load(InputStream inStream) throws Exception {
        int theLimit;
        LOGGER.fine("Loading datamodel from a stream");
        char[] theConversionBuffer = new char[1024];
        LineReader theLineReader = new LineReader(inStream);
        while ((theLimit = theLineReader.readLine()) >= 0) {
            char theChar;
            int theKeyLength;
            int valueStart = theLimit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (theKeyLength = 0; theKeyLength < theLimit; ++theKeyLength) {
                theChar = theLineReader.gLineBuffer[theKeyLength];
                if (!(theChar != '=' && theChar != ':' || precedingBackslash)) {
                    valueStart = theKeyLength + 1;
                    hasSep = true;
                    break;
                }
                if (!(theChar != ' ' && theChar != '\t' && theChar != '\f' || precedingBackslash)) {
                    valueStart = theKeyLength + 1;
                    break;
                }
                precedingBackslash = theChar == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < theLimit) {
                theChar = theLineReader.gLineBuffer[valueStart];
                if (theChar != ' ' && theChar != '\t' && theChar != '\f') {
                    if (hasSep || theChar != '=' && theChar != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(theLineReader.gLineBuffer, 0, theKeyLength, theConversionBuffer);
            String value = this.loadConvert(theLineReader.gLineBuffer, valueStart, theLimit - valueStart, theConversionBuffer);
            this.put(key, value);
        }
    }

    public int size() {
        return this.gKeys.size();
    }

    public boolean isEmpty() {
        return this.gKeys.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.gKeys.contains(key);
    }

    private String loadConvert(char[] aInputChars, int aOffset, int aLength, char[] aConvertBuffer) throws InvalidArgumentException {
        char[] theOutputBuffer;
        if (aConvertBuffer.length < aLength) {
            int newLen = aLength * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            theOutputBuffer = new char[newLen];
        } else {
            theOutputBuffer = aConvertBuffer;
        }
        int theOutputLength = 0;
        int end = aOffset + aLength;
        while (aOffset < end) {
            int aChar;
            if ((aChar = aInputChars[aOffset++]) == 92) {
                if ((aChar = aInputChars[aOffset++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = aInputChars[aOffset++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new InvalidArgumentException("CANNOT_CONVERT_CHAR_BUF_TO_STRING", new String[0]);
                            }
                        }
                    }
                    theOutputBuffer[theOutputLength++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                theOutputBuffer[theOutputLength++] = aChar;
                continue;
            }
            theOutputBuffer[theOutputLength++] = aChar;
        }
        return new String(theOutputBuffer, 0, theOutputLength);
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int theIndex = 0; theIndex < len; ++theIndex) {
            char aChar = theString.charAt(theIndex);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (theIndex == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(hexDigit[aChar >> 12 & 0xF & 0xF]);
                        outBuffer.append(hexDigit[aChar >> 8 & 0xF & 0xF]);
                        outBuffer.append(hexDigit[aChar >> 4 & 0xF & 0xF]);
                        outBuffer.append(hexDigit[aChar & 0xF & 0xF]);
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public synchronized void store(OutputStream aOutstream, String aComments) throws IOException {
        BufferedWriter theWriter = new BufferedWriter(new OutputStreamWriter(aOutstream, "8859_1"));
        if (aComments != null) {
            theWriter.write("#" + aComments);
            theWriter.newLine();
        }
        theWriter.write("#" + new Date().toString());
        theWriter.newLine();
        for (String key : this.gKeys) {
            String val = (String)this.get(key);
            theWriter.write(this.saveConvert(key, true) + "=" + this.saveConvert(val, false));
            theWriter.newLine();
        }
        theWriter.flush();
    }

    static class LineReader {
        byte[] gInputBuffer = new byte[8192];
        char[] gLineBuffer = new char[1024];
        int gInputLimit = 0;
        int gInputOffset = 0;
        InputStream gInputStream;

        LineReader(InputStream aInStream) {
            this.gInputStream = aInStream;
        }

        int readLine() throws IOException {
            int theLength = 0;
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.gInputOffset >= this.gInputLimit) {
                    this.gInputLimit = this.gInputStream.read(this.gInputBuffer);
                    this.gInputOffset = 0;
                    if (this.gInputLimit <= 0) {
                        if (theLength == 0 || isCommentLine) {
                            return -1;
                        }
                        return theLength;
                    }
                }
                char theChar = (char)(0xFF & this.gInputBuffer[this.gInputOffset++]);
                if (skipLF) {
                    skipLF = false;
                    if (theChar == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (theChar == ' ' || theChar == '\t' || theChar == '\f' || !appendedLineBegin && (theChar == '\r' || theChar == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (theChar == '#' || theChar == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (theChar != '\n' && theChar != '\r') {
                    this.gLineBuffer[theLength++] = theChar;
                    if (theLength == this.gLineBuffer.length) {
                        int newLength = this.gLineBuffer.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.gLineBuffer, 0, buf, 0, this.gLineBuffer.length);
                        this.gLineBuffer = buf;
                    }
                    if (theChar == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || theLength == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    theLength = 0;
                    continue;
                }
                if (this.gInputOffset >= this.gInputLimit) {
                    this.gInputLimit = this.gInputStream.read(this.gInputBuffer);
                    this.gInputOffset = 0;
                    if (this.gInputLimit <= 0) {
                        return theLength;
                    }
                }
                if (!precedingBackslash) break;
                --theLength;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (theChar != '\r') continue;
                skipLF = true;
            }
            return theLength;
        }
    }
}

