/*
 * Decompiled with CFR 0.152.
 */
package org.openinstaller.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LocaleUtils {
    public static Locale createLocaleFromString(String aString) {
        String[] theParts;
        if (aString == null || aString == "") {
            Locale locale = new Locale("", "", "");
        }
        Locale theLocale = (theParts = aString.split("[_.]")).length == 3 ? new Locale(theParts[0], theParts[1], theParts[2]) : (theParts.length == 2 ? new Locale(theParts[0], theParts[1]) : (theParts.length == 1 ? new Locale(theParts[0]) : new Locale("", "", "")));
        return theLocale;
    }

    public static List<String> getSubLocaleNames(Locale aLocale) {
        String theLanguage = aLocale.getLanguage();
        String theCountry = aLocale.getCountry();
        String theVariant = aLocale.getVariant();
        ArrayList<String> theCandidates = new ArrayList<String>();
        theCandidates.add("");
        if (theLanguage != null && 0 < theLanguage.length()) {
            theCandidates.add(0, theLanguage);
            if (theCountry != null && 0 < theCountry.length()) {
                theCandidates.add(0, theLanguage + "_" + theCountry);
                if (theVariant != null && 0 < theVariant.length()) {
                    theCandidates.add(0, theLanguage + "_" + theCountry + "_" + theVariant);
                }
            }
        }
        return theCandidates;
    }

    public static List<String> getCandidateResourceNames(String aBaseName, Locale aLocale) {
        String theNewBase = aBaseName;
        String theExtn = "";
        int theLastDot = aBaseName.lastIndexOf(46);
        if (theLastDot != -1) {
            theExtn = aBaseName.substring(theLastDot);
            theNewBase = aBaseName.substring(0, theLastDot);
        }
        String theLanguage = aLocale.getLanguage();
        String theCountry = aLocale.getCountry();
        String theVariant = aLocale.getVariant();
        ArrayList<String> theCandidates = new ArrayList<String>();
        theCandidates.add(0, aBaseName);
        if (theLanguage != null && 0 < theLanguage.length()) {
            theCandidates.add(0, theNewBase + "_" + theLanguage + theExtn);
            if (theCountry != null && 0 < theCountry.length()) {
                theCandidates.add(0, theNewBase + "_" + theLanguage + "_" + theCountry + theExtn);
                if (theVariant != null && 0 < theVariant.length()) {
                    theCandidates.add(0, theNewBase + "_" + theLanguage + "_" + theCountry + "_" + theVariant + theExtn);
                }
            }
        }
        return theCandidates;
    }
}

