/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)PacketFlag.cpp	1.4 06/26/07
 */ 

#include "PacketFlag.hpp"

/**
 *
 */
const char * 
PacketFlag::isQueueStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_IS_QUEUE) {
    return "IS_QUEUE ";
  } else {
    return "";
  }
}


/**
 *
 */
const char * 
PacketFlag::isRedeliveredStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_REDELIVERED) {
    return "REDLIVERED ";
  } else {
    return "";
  }
}



/**
 *
 */
const char * 
PacketFlag::isPersistentStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_PERSISTENT) {
    return "PERSISTENT ";
  } else {
    return "";
  }
}

/**
 *
 */
const char * 
PacketFlag::isSelectorsProcessedStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_SELECTORS_PROCESSED) {
    return "SELECTORS_PROCESSED ";
  } else {
    return "";
  }
}

/**
 *
 */
const char * 
PacketFlag::isSendAckStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_SEND_ACK) {
    return "SEND_ACK ";
  } else {
    return "";
  }
}

/**
 *
 */
const char * 
PacketFlag::isLastMessageStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_LAST_MESSAGE) {
    return "LAST_MESSAGE ";
  } else {
    return "";
  }
}

/**
 *
 */
const char * 
PacketFlag::isFlowPausedStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_FLOW_PAUSED) {
    return "FLOW_PAUSED ";
  } else {
    return "";
  }
}

/**
 *
 */
const char *
PacketFlag::isPartOfTransactionStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_PART_OF_TRANSACTION) {
    return "PART_OF_TRANSACTION ";
  } else {
    return "";
  }
}

/**
 *
 */
const char *
PacketFlag::isConsumerFlowPausedStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_CONSUMER_FLOW_PAUSED) {
    return "CONSUMER_FLOW_PAUSED ";
  } else {
    return "";
  }
}

/**
 *
 */
const char *
PacketFlag::isServerPacketStr(const PRUint16 bitFlags)
{
  if (bitFlags & PACKET_FLAG_SERVER_PACKET) {
    return "SERVER_PACKET ";
  } else {
    return "";
  }
}


