/*
 * @(#)LogAuditSession.java	1.3 06/24/04
 *
 * Copyright (c) 2004 by Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.messaging.jmq.jmsserver.audit;

import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;

/**
 * The LogAuditSession logs audit records in the broker log file.
 *
 * @version    1.3
 */
public class LogAuditSession extends MQAuditSession {

    LogAuditSession() {
	auditOn = MQAuditService.AUDIT_LOGGING_LICENSED &&
			MQAuditService.logAuditEnabled;

	if (auditOn) {
	    // force log level to at least INFO
	    // if not already set lower than that
	    String value = Globals.getConfig().getProperty(
				Globals.IMQ + ".log.level", "INFO");
	    int setAt = Logger.INFO;
	    try {
		setAt = Logger.levelStrToInt(value);
	    } catch (IllegalArgumentException e) {
		setAt = Logger.INFO;
	    }
	    if (setAt > Logger.INFO) {
		logger.updateProperty("imq.log.level", "INFO");
	    }
	}
	logger.log(logger.DEBUG, this + ":auditOn="+auditOn);
    }

    /**
     * Invoked post authentication.
     * @param user	user who is being authenticated
     * @param remoteHost host the user connects from
     * @param success	status of authentication
     */
    public void authentication(String user, String host, boolean success) {
	if (!auditOn)
	    return;

	String status = success ? SUCCESS_STR : FAILURE_STR;
	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + AUTHENTICATION
			+ COMMA + USER + user + COMMA + HOST + host
			+ COMMA + status);
    }

    public void brokerOperation(String user, String host, String op) {
	if (!auditOn)
	    return;

	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + op
			+ COMMA + USER + user + COMMA + HOST
			+ (host == null ? brokerHost : host)
			+ COMMA + SUCCESS_STR);
    }

    public void connectionAuth(
	String user, String host, String type, String name, boolean success) {

	if (!auditOn)
	    return;

	String status = success ? SUCCESS_STR : FAILURE_STR;
	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + AUTHORIZATION
			+ COMMA + USER + user + COMMA + HOST + host
			+ COMMA + TYPE + type + COMMA + NAME + name
			+ COMMA + status);
    }

    public void destinationAuth(String user, String host, String type,
	String name, String op, boolean success) {

	if (!auditOn)
	    return;

	String status = success ? SUCCESS_STR : FAILURE_STR;
	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + AUTHORIZATION
			+ COMMA + USER + user + COMMA + HOST + host
			+ COMMA + TYPE + type + COMMA + NAME + name
			+ COMMA + OPERATION + op + COMMA + status);
    }

    public void storeOperation(String user, String host, String op) {

	if (!auditOn)
	    return;

	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + op
			+ COMMA + USER + user + COMMA + HOST
			+ (host == null ? brokerHost : host)
			+ COMMA + SUCCESS_STR);
    }

    public void destinationOperation(
	String user, String host, String op, String type, String name) {

	if (!auditOn)
	    return;

	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + op
			+ COMMA + USER + user + COMMA + HOST + host
			+ COMMA + TYPE + type + COMMA + NAME + name
			+ COMMA + SUCCESS_STR);
    }

    public void durableSubscriberOperation(
	String user, String host, String op, String name, String clientID) {

	if (!auditOn)
	    return;

	logger.log(logger.INFO, AUDIT_PREFIX + ACTION + op
			+ COMMA + USER + user + COMMA + HOST + host
			+ COMMA + NAME + name + COMMA + CLIENT_ID + clientID
			+ COMMA + SUCCESS_STR);
    }
}
